/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

public enum PermAction {
    CHUNK_CLAIM,
    CHUNK_TAX,
    CHUNK_CUSTOMTAX,
    CREATE_MUNICIPALITY,
    CREATE_MUNICIPALITY_FUND,
    CREATE_DISTRICT,
    CREATE_COUNTY,
    CREATE_COUNTY_FUND,
    CREATE_REGION,
    MANAGE_DISTRICT,
    MANAGE_MUNICIPALITY,
    MANAGE_COUNTY,
    MANAGE_REGION,
    MAIL_READ,
    MAIL_DELETE,
    PLAYER_TAX,
    PLAYER_INVITE,
    FINANCES_USE,
    FINANCES_MANAGE;

    public static PermActions DISTRICT_ACTIONS;
    public static PermActions MUNICIPALITY_STAFF;
    public static PermActions MUNICIPALITY_CITIZEN;
    public static PermActions COUNTY_STAFF;
    public static PermActions COUNTY_CITIZEN;
    public static PermActions REGION_STAFF;

    public static PermAction get(String key) {
        for (PermAction act : PermAction.values()) {
            if (!act.name().equals(key)) continue;
            return act;
        }
        return null;
    }

    static {
        DISTRICT_ACTIONS = new PermActions(CHUNK_CLAIM, CHUNK_TAX, CHUNK_CUSTOMTAX, MAIL_READ, MAIL_DELETE, MANAGE_DISTRICT);
        MUNICIPALITY_STAFF = new PermActions(CHUNK_CLAIM, CHUNK_TAX, CHUNK_CUSTOMTAX, PLAYER_TAX, PLAYER_INVITE, FINANCES_USE, FINANCES_MANAGE, MAIL_READ, MAIL_DELETE, CREATE_DISTRICT, MANAGE_DISTRICT, MANAGE_MUNICIPALITY);
        MUNICIPALITY_CITIZEN = new PermActions(CHUNK_CLAIM);
        COUNTY_STAFF = new PermActions(CHUNK_CLAIM, CHUNK_TAX, CHUNK_CUSTOMTAX, PLAYER_TAX, FINANCES_USE, FINANCES_MANAGE, MAIL_READ, MAIL_DELETE, CREATE_DISTRICT, MANAGE_DISTRICT, MANAGE_COUNTY);
        COUNTY_CITIZEN = new PermActions(CHUNK_CLAIM, CREATE_MUNICIPALITY);
        REGION_STAFF = new PermActions(MANAGE_REGION, FINANCES_USE, FINANCES_MANAGE, MAIL_READ, MAIL_DELETE);
    }

    public static class PermActions {
        public final PermAction[] actions;

        public PermActions(PermAction ... actions) {
            this.actions = actions;
        }

        public boolean isValid(PermAction act) {
            for (PermAction a : this.actions) {
                if (act != a) continue;
                return true;
            }
            return false;
        }
    }
}

