/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.chunk;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;

public class ChunkLink
implements Saveable {
    public ArrayList<ChunkKey> linked;
    public ChunkKey root_key;
    public Chunk_ chunk;

    public ChunkLink(Chunk_ chunk_) {
        this.chunk = chunk_;
    }

    @Override
    public void save(JsonMap map) {
        if (this.linked != null) {
            JsonArray array = new JsonArray();
            for (ChunkKey key : this.linked) {
                array.add(key.toString());
            }
            map.add("linked", (JsonValue)array);
        } else {
            map.add("linked", this.root_key.toString());
        }
    }

    @Override
    public void load(JsonMap map) {
        JsonValue elm = map.get("linked");
        if (elm.isArray()) {
            this.linked = new ArrayList();
            for (JsonValue obj : (List)elm.asArray().value) {
                this.linked.add(new ChunkKey(obj.value.toString()));
            }
        } else {
            this.root_key = new ChunkKey(map.getString("linked", null));
        }
    }

    public boolean validate(ChunkKey key) {
        if (this.valid(key, this.chunk.key)) {
            return true;
        }
        for (ChunkKey link : this.linked) {
            if (!this.valid(key, link)) continue;
            return true;
        }
        return false;
    }

    private boolean valid(ChunkKey key, ChunkKey other) {
        if (key.equals(new int[]{other.x + 1, other.z})) {
            return true;
        }
        if (key.equals(new int[]{other.x - 1, other.z})) {
            return true;
        }
        if (key.equals(new int[]{other.x, other.z + 1})) {
            return true;
        }
        return key.equals(new int[]{other.x, other.z - 1});
    }
}

