/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.chunk;

import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.util.ResManager;

public class ChunkOwner
implements Saveable {
    public boolean unowned;
    public boolean playerchunk;
    public Layers owner = Layers.NONE;
    public UUID player;
    public int owid;

    @Override
    public void save(JsonMap map) {
        if (this.unowned) {
            return;
        }
        map.add("owner_type", this.owner.toString());
        if (this.owner.is(Layers.PLAYER)) {
            map.add("owner", this.player.toString());
        } else {
            map.add("owner", this.owid);
        }
    }

    @Override
    public void load(JsonMap map) {
        this.unowned = !map.has("owner") && !map.has("owner0");
        if (this.unowned) {
            return;
        }
        this.owner = Layers.valueOf(map.getString("owner_type", "NONE"));
        if (!this.owner.isValidChunkOwner()) {
            this.owner = Layers.NONE;
            this.unowned = true;
            return;
        }
        this.playerchunk = this.owner.is(Layers.PLAYER);
        if (this.playerchunk) {
            this.player = map.has("owner") ? UUID.fromString(map.get("owner").string_value()) : new UUID(map.getLong("owner0", 0L), map.getLong("owner1", 0L));
        } else {
            this.owid = map.getInteger("owner", -1);
        }
    }

    public void set(Layers layer, UUID uuid, int id) {
        this.unowned = !layer.isValidChunkOwner();
        if (this.unowned) {
            this.owner = Layers.NONE;
            this.playerchunk = false;
            this.player = null;
            this.owid = -1;
        } else {
            this.owner = layer;
            this.playerchunk = this.owner.is(Layers.PLAYER);
            this.player = this.playerchunk ? uuid : null;
            this.owid = this.playerchunk ? -1 : id;
        }
    }

    public String name() {
        return this.unowned ? "landdev.gui.chunk.unowned" : (this.playerchunk ? ResManager.getPlayerName(this.player) : this.owner.name() + ":" + this.owid);
    }

    public Account getAccount(Chunk_ chunk) {
        if (this.unowned) {
            return ResManager.SERVER_ACCOUNT;
        }
        if (this.playerchunk) {
            return ResManager.getPlayer((UUID)this.player, (boolean)true).account;
        }
        switch (this.owner) {
            case DISTRICT: {
                return chunk.district.account();
            }
            case MUNICIPALITY: {
                return chunk.district.municipality().account;
            }
            case COUNTY: {
                return chunk.district.county().account;
            }
            case REGION: {
                return chunk.district.region().account;
            }
        }
        return ResManager.SERVER_ACCOUNT;
    }

    public boolean issame(ChunkOwner other) {
        if (this.playerchunk) {
            return other.playerchunk && this.player.equals(other.player);
        }
        return this.owner == other.owner && this.owid == other.owid;
    }

    public Layers layer() {
        return this.owner;
    }

    public boolean taxable() {
        return this.playerchunk || this.owner.is(Layers.COMPANY);
    }
}

