/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.chunk;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.db.JsonTagConverter;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.UniChunk;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class ChunkRegion {
    public static ConcurrentHashMap<ChunkKey, ChunkRegion> REGIONS = new ConcurrentHashMap();
    public ConcurrentHashMap<ChunkKey, Chunk_> chunks = new ConcurrentHashMap();
    private JsonMap regionmap;
    private ChunkKey key;
    public long last_access;

    public ChunkRegion(ChunkKey rkey) {
        this.key = rkey;
        File jf = new File(String.valueOf(LandDev.SAVE_DIR) + "/chunks/" + this.key.toString() + ".json");
        File nf = new File(String.valueOf(LandDev.SAVE_DIR) + "/chunks/" + this.key.toString() + ".nbt");
        if (!jf.getParentFile().exists()) {
            jf.getParentFile().mkdirs();
        }
        if (!jf.exists() && nf.exists()) {
            LandDev.debug("Loading chunk region from " + nf.getAbsolutePath());
            this.regionmap = JsonTagConverter.demap(WrapperHolder.read((File)nf));
        } else {
            LandDev.debug("Loading chunk region from " + jf.getAbsolutePath());
            this.regionmap = JsonHandler.parse((File)jf);
        }
        this.setLastAccess();
    }

    public static void save(Chunk_ ck) {
        ChunkRegion region = ChunkRegion.getRegion(ck.region);
        region.chunks.put(ck.key, ck);
        region.saveChunk(ck);
    }

    private void saveChunk(Chunk_ ck) {
        JsonMap map = new JsonMap();
        ck.save(map);
        this.regionmap.add(ck.key.toString(), (JsonValue)map);
        this.setLastAccess();
    }

    private void loadChunk(Chunk_ ck) {
        this.chunks.put(ck.key, ck);
        JsonMap map = this.regionmap.getMap(ck.key.toString());
        if (map.empty()) {
            ck.gendef();
        }
        ck.load(map);
        ResManager.CHUNKS.put(ck.key, ck);
        this.setLastAccess();
    }

    private void setLastAccess() {
        this.last_access = Time.getDate();
    }

    public static Chunk_ getFor(UniChunk uck) {
        ChunkKey key = new ChunkKey(uck.chunk.x(), uck.chunk.z());
        ChunkRegion region = ChunkRegion.getRegion(key.asRegion());
        if (region.chunks.containsKey(key)) {
            Chunk_ ck = region.chunks.get(key);
            ck.uck = uck;
            ck.loaded = Time.getDate();
            region.setLastAccess();
            return ck;
        }
        Chunk_ ck = new Chunk_(uck);
        region.loadChunk(ck);
        region.setLastAccess();
        return ck;
    }

    public static void saveAll() {
        for (ChunkRegion value : REGIONS.values()) {
            value.save();
        }
    }

    private void save() {
        for (Chunk_ ck : this.chunks.values()) {
            this.saveChunk(ck);
        }
        File file = new File(String.valueOf(LandDev.SAVE_DIR) + "/chunks/" + this.key.toString() + ".json");
        JsonHandler.print((File)file, (JsonValue)this.regionmap, (JsonHandler.PrintOption)(LDConfig.SAVE_SPACED_JSON ? JsonHandler.PrintOption.FLAT : JsonHandler.PrintOption.SPACED));
        LandDev.debug("Saving chunk region to " + file.getAbsolutePath());
    }

    public static void saveRegions() {
        long offset = 300000L;
        long date = Time.getDate();
        ArrayList<ChunkKey> remreg = new ArrayList<ChunkKey>();
        for (ChunkRegion region : REGIONS.values()) {
            if (region.last_access + offset >= date) continue;
            region.chunks.values().removeIf(ck -> {
                if (ck.uck == null && ck.loaded + offset < date) {
                    region.saveChunk((Chunk_)ck);
                    return true;
                }
                return false;
            });
            region.save();
            if (!region.chunks.isEmpty()) continue;
            remreg.add(region.key);
        }
        for (ChunkKey key : remreg) {
            REGIONS.remove(key);
        }
    }

    public static void unload(Chunk_ ck) {
        ChunkRegion region = REGIONS.get(ck);
        if (region != null) {
            region.saveChunk(ck);
            ck.uck = null;
            ck.loaded = Time.getDate();
        }
    }

    public static Chunk_ get(int x, int z) {
        return ChunkRegion.get(new ChunkKey(x, z));
    }

    public static Chunk_ get(ChunkKey key) {
        ChunkRegion region = ChunkRegion.getRegion(key.asRegion());
        if (region.chunks.containsKey(key)) {
            region.setLastAccess();
            return region.chunks.get(key);
        }
        Chunk_ ck = new Chunk_(key);
        region.loadChunk(ck);
        return ck;
    }

    public static ChunkRegion getRegion(ChunkKey key) {
        ChunkRegion region = REGIONS.get(key);
        if (region == null) {
            region = new ChunkRegion(key);
            REGIONS.put(key, region);
        }
        return region;
    }
}

