/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.chunk;

import java.util.ArrayList;
import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.data.Createable;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.Sellable;
import net.fexcraft.mod.landdev.data.Taxable;
import net.fexcraft.mod.landdev.data.chunk.AccessList;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.ChunkLabel;
import net.fexcraft.mod.landdev.data.chunk.ChunkLink;
import net.fexcraft.mod.landdev.data.chunk.ChunkOwner;
import net.fexcraft.mod.landdev.data.chunk.ChunkRegion;
import net.fexcraft.mod.landdev.data.chunk.ChunkType;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.hooks.ExternalData;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.TaxSystem;
import net.fexcraft.mod.uni.UniChunk;
import net.fexcraft.mod.uni.world.MessageSender;

public class Chunk_
implements Saveable,
Layer,
LDUIModule {
    public final ChunkKey key;
    public final ChunkKey region;
    public Createable created = new Createable(true);
    public ChunkType type = ChunkType.NORMAL;
    public Sellable sell = new Sellable(this);
    public ChunkLink link = null;
    public AccessList access = new AccessList();
    public ChunkOwner owner = new ChunkOwner();
    public Taxable tax = new Taxable(this);
    public ChunkLabel label = new ChunkLabel();
    public ExternalData external = new ExternalData(this);
    public District district;
    public long loaded;
    public boolean locked;
    public UniChunk uck;
    public static final int UI_LINK = 1;
    public static final int UI_LINKS = 2;
    public static final int UI_LINKED = 3;
    public static final int UI_TYPE = 4;
    public static final int UI_OWNER = 5;
    public static final int UI_PRICE = 6;
    public static final int UI_SET_PRICE = 7;
    public static final int UI_TAX = 8;
    public static final int UI_ACC_PLAYER = 9;
    public static final int UI_ACC_COMPANY = 10;

    public Chunk_(UniChunk ck) {
        this.key = new ChunkKey(ck.chunk.x(), ck.chunk.z());
        this.region = this.key.asRegion();
        this.uck = ck;
    }

    public Chunk_(ChunkKey ckkey) {
        this.key = ckkey;
        this.region = this.key.asRegion();
        this.loaded = Time.getDate();
    }

    @Override
    public void save(JsonMap map) {
        map.add("id", this.key.toString());
        this.created.save(map);
        this.owner.save(map);
        map.add("type", this.type.l1());
        this.sell.save(map);
        if (this.link != null) {
            this.link.save(map);
        }
        this.access.save(map);
        this.tax.save(map);
        this.label.save(map);
        if (this.district != null) {
            map.add("district", this.district.id);
        }
        this.external.save(this, map);
        if (this.locked) {
            map.add("locked", true);
        }
    }

    @Override
    public void load(JsonMap map) {
        this.created.load(map);
        this.owner.load(map);
        this.type = ChunkType.l1(map.getString("type", "N"));
        this.sell.load(map);
        if (map.has("linked")) {
            this.link = new ChunkLink(this);
            this.link.load(map);
        }
        this.access.load(map);
        this.tax.load(map);
        this.label.load(map);
        this.district = ResManager.getDistrict(map.getInteger("district", -1));
        if (this.district.disbanded) {
            this.district = ResManager.getDistrict(-1);
        }
        this.external.load(this, map);
        this.locked = map.getBoolean("locked", false);
        TaxSystem.taxChunk(this, null, false);
    }

    @Override
    public void gendef() {
        this.district = ResManager.getDistrict(-1);
        this.external.gendef(this);
    }

    @Override
    public String saveId() {
        return this.key.toString();
    }

    @Override
    public String saveTable() {
        return "chunks";
    }

    @Override
    public void save() {
        ChunkRegion.save(this);
        if (this.uck != null) {
            this.uck.chunk.markChanged();
        }
    }

    @Override
    public Layers getLayer() {
        return Layers.CHUNK;
    }

    @Override
    public Layers getParentLayer() {
        return Layers.DISTRICT;
    }

    public boolean can_manage(LDPlayer player) {
        if (player.adm) {
            return true;
        }
        if (this.locked) {
            return false;
        }
        UUID uuid = player.uuid;
        if (this.owner.playerchunk && this.owner.player.equals(uuid)) {
            return true;
        }
        if (this.owner.owner.is(Layers.DISTRICT) && this.district.can(PermAction.MANAGE_DISTRICT, uuid)) {
            return true;
        }
        return this.owner.owner.is(Layers.MUNICIPALITY) && this.district.owner.manageable().isManager(uuid);
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("chunk.title");
        switch (container.pos.x) {
            case 0: {
                boolean canman = this.can_manage(container.ldp);
                if (this.locked) {
                    resp.addButton("locked", LDUIRow.ELM_RED, container.ldp.adm ? LDUIButton.ENABLED : LDUIButton.EMPTY);
                }
                resp.addRow("key", LDUIRow.ELM_GENERIC, this.key.comma());
                if (LDConfig.CHUNK_LINK_LIMIT > 0) {
                    if (this.link == null) {
                        if (canman) {
                            resp.addButton("link", LDUIRow.ELM_GENERIC, LDUIButton.ADD);
                        } else {
                            resp.addRow("link", LDUIRow.ELM_GENERIC, LDUIButton.EMPTY);
                        }
                    } else if (this.link.linked != null) {
                        resp.addButton("links", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.link.linked.size());
                    } else if (this.link.root_key != null) {
                        resp.addButton("linked", LDUIRow.ELM_GENERIC, canman ? LDUIButton.OPEN : LDUIButton.EMPTY, this.link.root_key.comma());
                    }
                }
                resp.addRow("type", LDUIRow.ELM_GENERIC, canman ? LDUIButton.OPEN : LDUIButton.EMPTY, canman, this.type.lang());
                resp.addButton("district", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.district.name());
                resp.addBlank();
                resp.addButton("owner", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.owner.name());
                if (this.sell.price > 0L) {
                    resp.addRow("price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, true, this.sell.price_formatted());
                }
                if (canman) {
                    resp.addButton("set_price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                }
                resp.addButton("tax", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, Config.getWorthAsString((long)(this.tax.custom_tax == 0L ? this.district.tax() : this.tax.custom_tax)));
                resp.addBlank();
                resp.addRow("access_interact", LDUIRow.ELM_GENERIC, canman ? (this.access.interact ? LDUIButton.ENABLED : LDUIButton.DISABLED) : LDUIButton.EMPTY, canman, this.access.interact ? "landdev.gui.yes" : "landdev.gui.no");
                resp.addButton("access_player", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.access.players.size());
                resp.addButton("access_company", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.access.companies.size());
                if (this.locked || !container.ldp.adm) break;
                resp.addButton("lock", LDUIRow.ELM_RED, LDUIButton.DISABLED);
                break;
            }
            case 1: {
                resp.setTitle("chunk.link.title");
                resp.addRow("link.info0", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                resp.addRow("link.info1", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                resp.addRow("link.key", LDUIRow.ELM_GENERIC, LDUIButton.BLANK);
                resp.addField("link.field");
                resp.addButton("link.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 2: {
                resp.setTitle("chunk.links.title");
                if (this.link.linked == null) break;
                resp.addButton("links.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN, this.key.comma());
                boolean first = true;
                for (int i = 0; i < this.link.linked.size(); ++i) {
                    resp.addButton("links.key" + i, LDUIRow.ELM_BLUE, LDUIButton.radio(first), "!!!" + this.link.linked.get(i).comma());
                    first = false;
                }
                resp.setFormular();
                break;
            }
            case 3: {
                resp.setTitle("chunk.linked.title");
                resp.addButton("linked.key", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!" + this.link.root_key.comma());
                resp.addButton("linked.disconnect", LDUIRow.ELM_RED, LDUIButton.REM, this.key.comma());
                break;
            }
            case 4: {
                resp.setTitle("chunk.select_type.title");
                resp.addRow("key", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.key.comma());
                resp.addRadio("type.normal", LDUIRow.ELM_BLUE, this.type == ChunkType.NORMAL);
                resp.addRadio("type.private", LDUIRow.ELM_BLUE, this.type == ChunkType.PRIVATE);
                resp.addRadio("type.restricted", LDUIRow.ELM_BLUE, this.type == ChunkType.RESTRICTED);
                resp.addRadio("type.public", LDUIRow.ELM_BLUE, this.type == ChunkType.PUBLIC);
                if (container.ldp.adm) {
                    resp.addRadio("type.locked", LDUIRow.ELM_YELLOW, this.type == ChunkType.LOCKED);
                }
                resp.addButton("select_type.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 5: {
                resp.setTitle("chunk.set_owner.title");
                resp.addRow("key", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.key.comma());
                resp.addRow("set_owner.warning0", LDUIRow.ELM_RED);
                resp.addRow("set_owner.warning1", LDUIRow.ELM_RED);
                resp.addRow("set_owner.warning2", LDUIRow.ELM_RED);
                resp.addRow("set_owner.warning3", LDUIRow.ELM_RED);
                resp.addRadio("set_owner.district", LDUIRow.ELM_BLUE, this.owner.owner == Layers.DISTRICT);
                if (!this.district.owner.is_county) {
                    resp.addRadio("set_owner.municipality", LDUIRow.ELM_BLUE, this.owner.owner == Layers.MUNICIPALITY);
                }
                resp.addRadio("set_owner.county", LDUIRow.ELM_BLUE, this.owner.owner == Layers.COUNTY);
                resp.addRadio("set_owner.region", LDUIRow.ELM_BLUE, this.owner.owner == Layers.REGION);
                resp.addRadio("set_owner.none", LDUIRow.ELM_BLUE, this.owner.owner == Layers.NONE);
                resp.addButton("set_owner.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 6: {
                resp.setTitle("chunk.buy.title");
                resp.addRow("key", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.key.comma());
                resp.addRow("buy.info", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                resp.addButton("buy.self", LDUIRow.ELM_BLUE, LDUIButton.RADIO_CHECKED);
                resp.addButton("buy.company", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                resp.addButton("buy.district", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                if (!this.district.owner.is_county) {
                    resp.addButton("buy.municipality", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                }
                resp.addButton("buy.county", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                resp.addButton("buy.region", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                resp.addButton("buy.payer", LDUIRow.ELM_GENERIC, LDUIButton.CHECK_UNCHECKED);
                resp.addButton("buy.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 7: {
                resp.setTitle("chunk.set_price.title");
                resp.addRow("key", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.key.comma());
                resp.addField("set_price.field");
                resp.addButton("set_price.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 8: {
                boolean bool = this.district.can(PermAction.CHUNK_CUSTOMTAX, container.ldp.uuid) || container.ldp.adm;
                resp.setTitle("chunk.tax.title");
                resp.addRow("tax.info0", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                resp.addRow("tax.info1", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                resp.addRow("tax.info2", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                resp.addRow("tax.default", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, Config.getWorthAsString((long)this.district.tax()));
                if (bool || this.tax.custom_tax > 0L) {
                    resp.addRow("tax.custom", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, Config.getWorthAsString((long)this.tax.custom_tax));
                }
                resp.addRow("tax.last_amount", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, Config.getWorthAsString((long)this.tax.last_tax));
                resp.addRow("tax.last_time", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, Time.getAsString((long)this.tax.last_interval));
                if (!bool) break;
                resp.addBlank();
                resp.addRow("set_tax.title", LDUIRow.ELM_GENERIC, LDUIButton.BLANK);
                resp.addField("set_tax.field", Config.getWorthAsString((long)this.tax.custom_tax, (boolean)false));
                resp.addButton("set_tax.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 9: {
                resp.setTitle("chunk.access_player.title");
                boolean bcm = this.can_manage(container.ldp);
                if (bcm) {
                    resp.addRow("access_player.info", LDUIRow.ELM_GREEN, LDUIButton.BLANK);
                    resp.addField("access_player.field");
                    resp.addButton("access_player.add.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                    resp.addBlank();
                    resp.setFormular();
                }
                if (this.access.players.isEmpty()) {
                    resp.addRow("access_player.empty", LDUIRow.ELM_YELLOW, LDUIButton.BLANK);
                    break;
                }
                if (bcm) {
                    resp.addButton("access_player.rem.submit", LDUIRow.ELM_GENERIC, LDUIButton.REM);
                }
                boolean primo = true;
                UUID[] keys = this.access.players.keySet().toArray(new UUID[0]);
                for (int i = 0; i < this.access.players.size(); ++i) {
                    resp.addButton("access_player.id_" + String.valueOf(keys[i]), LDUIRow.ELM_BLUE, bcm ? LDUIButton.radio(primo) : LDUIButton.EMPTY, "!!!" + ResManager.getPlayerName(keys[i]));
                    primo = false;
                }
                if (!bcm) break;
                resp.setFormular();
                break;
            }
        }
        this.external.sync_packet(container, resp);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        boolean canman = this.can_manage(container.ldp);
        switch (req.event()) {
            case "access_interact": {
                if (!canman) break;
                this.access.interact = !this.access.interact;
                container.sendResp();
                break;
            }
            case "link": {
                container.open(1);
                break;
            }
            case "link.submit": {
                ChunkLink ckl;
                if (!canman || LDConfig.CHUNK_LINK_LIMIT == 0 || this.link != null) break;
                ChunkKey ckk = new ChunkKey(req.getField("link.field"));
                Chunk_ ck = ResManager.getChunk(ckk);
                if (ck == null) {
                    container.msg("link.notfound");
                    break;
                }
                if (ck.link != null && ck.link.root_key != null) {
                    container.msg("link.issub");
                    break;
                }
                ChunkLink chunkLink = ckl = ck.link == null ? new ChunkLink(ck) : ck.link;
                if (ckl.linked == null) {
                    ckl.linked = new ArrayList();
                }
                if (this.key.equals(ckk) || ckl.linked.contains(ckk)) {
                    container.msg("link.islinked");
                    break;
                }
                if (ckl.linked.size() > LDConfig.CHUNK_LINK_LIMIT) {
                    container.msg("link.limit");
                    break;
                }
                if (!ckl.validate(this.key)) {
                    container.msg("link.noborder");
                    break;
                }
                if (!ck.owner.issame(this.owner)) {
                    container.msg("link.nosameowner");
                    break;
                }
                ck.link = ckl;
                ck.link.linked.add(this.key);
                this.link = new ChunkLink(this);
                this.link.root_key = ck.key;
                ck.save();
                this.save();
                container.open(0);
                break;
            }
            case "links": {
                container.open(2);
                break;
            }
            case "links.submit": {
                if (!canman) break;
                ChunkKey key = this.link.linked.get(req.getRadioInt("links.key"));
                container.open(LDKeys.CHUNK, 0, key.x, key.z);
                break;
            }
            case "linked": {
                container.open(3);
                break;
            }
            case "linked.key": {
                container.open(LDKeys.CHUNK, 0, this.link.root_key.x, this.link.root_key.z);
                break;
            }
            case "linked.disconnect": {
                if (!canman) break;
                Chunk_ lt = ResManager.getChunk(this.link.root_key);
                lt.link.linked.remove(this.key);
                if (lt.link.linked.isEmpty()) {
                    lt.link = null;
                }
                this.link = null;
                lt.save();
                this.save();
                container.open(0);
                break;
            }
            case "type": {
                if (!canman) break;
                container.open(4);
                break;
            }
            case "district": {
                container.open(LDKeys.DISTRICT, 0, this.district.id, 0);
                break;
            }
            case "owner": {
                if (!canman) break;
                container.open(5);
                break;
            }
            case "price": {
                container.open(6);
                break;
            }
            case "set_price": {
                container.open(7);
                break;
            }
            case "tax": {
                container.open(8);
                break;
            }
            case "access_player": {
                container.open(9);
                break;
            }
            case "access_company": {
                container.open(10);
                break;
            }
            case "lock": 
            case "locked": {
                if (!container.ldp.adm) break;
                this.locked = !this.locked;
                this.save();
                container.open(0);
                break;
            }
            case "select_type.submit": {
                ChunkType type;
                if (!canman || (type = ChunkType.get(req.getRadio("type."))) == null || !container.ldp.adm && (type == ChunkType.LOCKED || this.type == ChunkType.LOCKED)) break;
                if (this.owner.playerchunk && (type == ChunkType.RESTRICTED || type == ChunkType.LOCKED)) {
                    container.msg("select_type.notforplayerchunks");
                    break;
                }
                this.type = type;
                container.open(0);
                break;
            }
            case "set_price.submit": {
                if (!canman) break;
                String[] err = new String[]{""};
                String val = req.getField("set_price.field");
                long value = LDConfig.format_price(err, val);
                if (err[0].length() > 0) {
                    container.msg(err[0], false);
                    break;
                }
                this.sell.price = value;
                container.open(0);
                break;
            }
            case "set_owner.submit": {
                Layers layer;
                if (!canman || !(layer = Layers.get(req.getRadio("set_owner."))).isValidChunkOwner2()) break;
                if (layer.is(Layers.MUNICIPALITY) && this.district.owner.is_county) {
                    container.msg("landdev.district.not_part_of_municipality", false);
                    break;
                }
                this.owner.set(layer, null, this.getLayerId(layer));
                this.sell.price = 0L;
                container.open(0);
                break;
            }
            case "buy.submit": {
                Account account;
                Layers layer;
                if (this.link != null && this.link.root_key != null) {
                    container.msg("buy.islinked");
                    break;
                }
                String radio = req.getRadio();
                Layers layers = layer = radio.endsWith(".self") ? Layers.PLAYER : Layers.get(radio.replace("buy.", ""));
                if (!layer.isValidChunkOwner()) break;
                if (layer.is(Layers.MUNICIPALITY) && this.district.owner.is_county) {
                    container.msg("landdev.district.not_part_of_municipality", false);
                    break;
                }
                boolean npp = req.getCheck("buy.payer");
                Account account2 = account = npp ? this.district.getLayerAccount(layer, container) : container.ldp.account;
                if (account == null) break;
                if (account.getBalance() < this.sell.price) {
                    container.msg("buy.notenoughmoney");
                    break;
                }
                if (!account.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)container.ldp.entity, account, this.sell.price, this.owner.getAccount(this))) break;
                this.owner.set(layer, layer.is(Layers.PLAYER) ? container.ldp.uuid : null, this.district.getLayerId(layer));
                this.sell.price = 0L;
                this.save();
                if (this.link != null && this.link.linked != null) {
                    for (ChunkKey lk : this.link.linked) {
                        Chunk_ ck = ResManager.getChunk(lk);
                        if (ck.link == null || !this.key.equals(ck.link.root_key)) continue;
                        ck.sell.price = 0L;
                        ck.owner.set(layer, layer.is(Layers.PLAYER) ? container.ldp.uuid : null, this.district.getLayerId(layer));
                        ck.save();
                    }
                }
                container.open(0);
                break;
            }
            case "set_tax.submit": {
                if (!this.district.can(PermAction.CHUNK_CUSTOMTAX, container.ldp.uuid) && !container.ldp.adm) break;
                String val = req.getField("set_tax.field");
                String[] err = new String[]{""};
                long value = LDConfig.format_price(err, val);
                if (err[0].length() > 0) {
                    container.msg(err[0], false);
                    break;
                }
                this.tax.custom_tax = value;
                container.open(8);
                break;
            }
            case "access_player.add.submit": {
                if (!this.can_manage(container.ldp)) break;
                LDPlayer other = req.getPlayerField("access_player.field", true);
                if (other == null) {
                    container.msg("access_player.notfound");
                    break;
                }
                this.access.players.put(other.uuid, 0L);
                container.open(9);
                break;
            }
            case "access_player.rem.submit": {
                if (!this.can_manage(container.ldp)) break;
                UUID uuid = UUID.fromString(req.getRadio("access_player.id_"));
                if (!this.access.players.containsKey(uuid)) {
                    container.msg("access_player.notfound");
                    break;
                }
                this.access.players.remove(uuid);
                container.open(9);
                break;
            }
        }
        this.external.on_interact(container, req);
    }

    private int getLayerId(Layers layer) {
        switch (layer) {
            case COMPANY: {
                return -1;
            }
            case DISTRICT: {
                return this.district.id;
            }
            case MUNICIPALITY: {
                return this.district.owner.is_county ? -1 : this.district.municipality().id;
            }
            case COUNTY: {
                return this.district.county().id;
            }
            case REGION: {
                return this.district.county().region.id;
            }
        }
        return -1;
    }

    public void sendToOwner(Mail mail) {
        if (this.owner.playerchunk) {
            LDPlayer player = ResManager.getPlayer(this.owner.player, true);
            player.addMailAndSave(mail);
            return;
        }
        switch (this.owner.layer()) {
            case COMPANY: {
                break;
            }
            case DISTRICT: {
                this.district.mail.add(mail);
                this.district.save();
                break;
            }
            case MUNICIPALITY: {
                if (this.district.owner.is_county) {
                    return;
                }
                this.district.municipality().mail.add(mail);
                this.district.municipality().save();
                break;
            }
            case COUNTY: {
                if (!this.district.owner.is_county) {
                    return;
                }
                this.district.county().mail.add(mail);
                this.district.county().save();
                break;
            }
            case REGION: {
                this.district.region().mail.add(mail);
                this.district.region().save();
                break;
            }
            case NONE: {
                return;
            }
        }
    }

    public boolean locked() {
        return this.type == ChunkType.LOCKED;
    }
}

