/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.district;

import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.data.ColorData;
import net.fexcraft.mod.landdev.data.Createable;
import net.fexcraft.mod.landdev.data.IconHolder;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.Manageable;
import net.fexcraft.mod.landdev.data.NeighborData;
import net.fexcraft.mod.landdev.data.Norms;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.PermInteractive;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.Sellable;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.DistrictOwner;
import net.fexcraft.mod.landdev.data.district.DistrictType;
import net.fexcraft.mod.landdev.data.hooks.ExternalData;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.norm.BoolNorm;
import net.fexcraft.mod.landdev.data.norm.IntegerNorm;
import net.fexcraft.mod.landdev.data.norm.StringNorm;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.AppearModule;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.ui.modules.NormModule;
import net.fexcraft.mod.landdev.util.Announcer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.world.MessageSender;

public class District
implements Saveable,
Layer,
PermInteractive,
LDUIModule {
    public final int id;
    public Createable created = new Createable();
    public Sellable sell = new Sellable(this);
    public IconHolder icon = new IconHolder();
    public ColorData color = new ColorData();
    public NeighborData neighbors = new NeighborData();
    public MailData mail;
    public DistrictType type = DistrictType.getDefault();
    public Manageable manage = new Manageable(false, PermAction.DISTRICT_ACTIONS);
    public Norms norms = new Norms();
    public DistrictOwner owner = new DistrictOwner();
    public ExternalData external = new ExternalData(this);
    public boolean disbanded;
    public boolean locked;
    public long tax_collected;
    public long chunks;
    public static final int UI_CREATE = -1;
    public static final int UI_TYPE = 1;
    public static final int UI_PRICE = 2;
    public static final int UI_MANAGER = 3;
    public static final int UI_SET_PRICE = 4;
    public static final int UI_NORMS = 5;
    public static final int UI_NORM_EDIT = 6;
    public static final int UI_APPREARANCE = 7;
    public static final int UI_MERGE = 8;
    public static final int UI_DISBAND = 9;

    public District(int id) {
        this.id = id;
        this.mail = new MailData(this.getLayer(), id);
        this.norms.add(new StringNorm("name", "Unnamed District"));
        this.norms.add(new BoolNorm("explosions", false));
        this.norms.add(new IntegerNorm("chunk-tax", 1000));
        this.norms.add(new BoolNorm("municipality-can-form", false));
        this.norms.add(new BoolNorm("county-can-form", false));
        this.norms.add(new BoolNorm("unclaim-bankrupt", false));
    }

    @Override
    public void save(JsonMap map) {
        map.add("id", this.id);
        this.created.save(map);
        this.sell.save(map);
        this.icon.save(map);
        this.color.save(map);
        this.neighbors.save(map);
        this.mail.save(map);
        this.type.save(map);
        this.manage.save(map);
        this.norms.save(map);
        this.owner.save(map);
        map.add("tax_collected", this.tax_collected);
        this.external.save(this, map);
        map.add("chunks", this.chunks);
        if (this.disbanded) {
            map.add("disbanded", true);
        }
        if (this.locked) {
            map.add("locked", true);
        }
    }

    @Override
    public void load(JsonMap map) {
        this.created.load(map);
        this.sell.load(map);
        this.icon.load(map);
        this.color.load(map);
        this.neighbors.load(map);
        this.mail.load(map);
        this.type = DistrictType.get(map);
        this.manage.load(map);
        this.norms.load(map);
        this.owner.load(map);
        this.tax_collected = map.getLong("tax_collected", 0L);
        this.external.load(this, map);
        this.chunks = map.getLong("chunks", 0L);
        this.disbanded = map.getBoolean("disbanded", false);
        this.locked = map.getBoolean("locked", false);
    }

    @Override
    public void gendef() {
        if (this.id == -1) {
            this.norms.get("name").set("Wilderness");
            this.owner.owid = -1;
            this.owner.is_county = true;
            this.owner.county = ResManager.getCounty(-1, true);
            this.color.set(39168);
        } else if (this.id == 0) {
            this.norms.get("name").set("Spawn District");
            this.owner.owid = 0;
            this.owner.is_county = false;
            this.owner.municipality = ResManager.getMunicipality(0, true);
            this.color.set(0xFF9900);
        }
        this.external.gendef(this);
    }

    @Override
    public String saveId() {
        return "" + this.id;
    }

    @Override
    public String saveTable() {
        return "districts";
    }

    @Override
    public Layers getLayer() {
        return Layers.DISTRICT;
    }

    @Override
    public Layers getParentLayer() {
        return this.owner.is_county ? Layers.COUNTY : Layers.MUNICIPALITY;
    }

    @Override
    public int lid() {
        return this.id;
    }

    public String name() {
        return this.norms.get("name").string();
    }

    public long tax() {
        return this.norms.get("chunk-tax").integer();
    }

    public Region region() {
        return this.owner.is_county ? this.owner.county.region : this.owner.municipality.county.region;
    }

    @Override
    public boolean can(PermAction act, UUID uuid) {
        if (this.locked) {
            return false;
        }
        boolean man = this.manage.isManager(uuid);
        for (PermAction action : this.manage.actions()) {
            if (action != act) continue;
            if (man || this.owner.manageable().can(act, uuid)) {
                return true;
            }
            if (!this.owner.citizen().can(act, uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean can(UUID uuid, PermAction ... acts) {
        for (PermAction act : acts) {
            if (!this.can(act, uuid)) continue;
            return true;
        }
        return false;
    }

    public County county() {
        return this.owner.is_county ? this.owner.county : this.owner.municipality.county;
    }

    public Account account() {
        return this.owner.is_county ? this.owner.county.account : this.owner.municipality.account;
    }

    public Municipality municipality() {
        return this.owner.is_county ? null : this.owner.municipality;
    }

    public int getLayerId(Layers layer) {
        if (layer == Layers.DISTRICT) {
            return this.id;
        }
        if (layer == Layers.MUNICIPALITY) {
            return this.owner.is_county ? -1 : this.owner.municipality.id;
        }
        if (layer == Layers.COUNTY) {
            return this.owner.county_id();
        }
        if (layer == Layers.REGION) {
            return this.county().region.id;
        }
        return -1;
    }

    public Account getLayerAccount(Layers layer, BaseCon container) {
        if (layer.is(Layers.PLAYER)) {
            return container.ldp.account;
        }
        boolean dis = layer.is(Layers.DISTRICT);
        if (dis && !this.owner.is_county || layer.is(Layers.MUNICIPALITY)) {
            if (!this.owner.municipality.manage.can(container.ldp.uuid, PermAction.FINANCES_USE, PermAction.FINANCES_MANAGE)) {
                if (container == null) {
                    container.ldp.entity.send("landdev.cmd.account.noperm.municipality");
                } else {
                    container.msg("landdev.cmd.account.noperm.municipality", false);
                }
                return null;
            }
            return this.owner.municipality.account;
        }
        if (dis && this.owner.is_county || layer.is(Layers.COUNTY)) {
            if (!this.county().manage.can(container.ldp.uuid, PermAction.FINANCES_USE, PermAction.FINANCES_MANAGE)) {
                if (container == null) {
                    container.ldp.entity.send("landdev.cmd.account.noperm.county");
                } else {
                    container.msg("landdev.cmd.account.noperm.county", false);
                }
                return null;
            }
            return this.county().account;
        }
        if (layer.is(Layers.REGION)) {
            if (!this.region().manage.can(container.ldp.uuid, PermAction.FINANCES_USE, PermAction.FINANCES_MANAGE)) {
                if (container == null) {
                    container.ldp.entity.send("landdev.cmd.account.noperm.region");
                } else {
                    container.msg("landdev.cmd.account.noperm.region", false);
                }
                return null;
            }
            return this.region().account;
        }
        return null;
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("district.title");
        boolean canman = !this.locked && this.can(PermAction.MANAGE_DISTRICT, container.ldp.uuid) || container.ldp.adm;
        boolean canoman = !this.locked && this.owner.manageable().can(PermAction.MANAGE_DISTRICT, container.ldp.uuid) || container.ldp.adm;
        switch (container.pos.x) {
            case 0: {
                if (this.disbanded) {
                    resp.addRow("disbanded", LDUIRow.ELM_RED, this.id);
                }
                if (this.locked) {
                    resp.addButton("locked", LDUIRow.ELM_RED, container.ldp.adm ? LDUIButton.ENABLED : LDUIButton.EMPTY);
                }
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                if (canman) {
                    resp.addButton("name", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.name());
                    resp.addButton("type", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.type.name());
                } else {
                    resp.addRow("name", LDUIRow.ELM_GENERIC, LDUIButton.EMPTY, this.name());
                    resp.addRow("type", LDUIRow.ELM_GENERIC, LDUIButton.EMPTY, this.type.name());
                }
                resp.addButton("owner", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.owner.name());
                if (canoman || this.manage.hasManager()) {
                    resp.addRow("manager", LDUIRow.ELM_GENERIC, canoman ? LDUIButton.OPEN : LDUIButton.EMPTY, canoman, this.manage.getManagerName());
                }
                resp.addBlank();
                if (this.sell.price > 0L) {
                    resp.addButton("price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.sell.price_formatted());
                }
                if (canman) {
                    resp.addButton("set_price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                }
                if (this.sell.price > 0L) {
                    resp.addBlank();
                }
                resp.addRow("chunk_tax", LDUIRow.ELM_GENERIC, Config.getWorthAsString((long)this.tax()));
                if (this.id >= 0) {
                    resp.addRow("chunks", LDUIRow.ELM_GENERIC, this.chunks);
                }
                if (canman) {
                    resp.addButton("mailbox", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.mail.unread());
                }
                resp.addButton("norms", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                resp.addButton("appearance", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                resp.addBlank();
                resp.addButton("merge", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                resp.addButton("disband", LDUIRow.ELM_RED, LDUIButton.OPEN);
                if (this.locked || !container.ldp.adm) break;
                resp.addButton("lock", LDUIRow.ELM_RED, LDUIButton.DISABLED);
                break;
            }
            case 1: {
                resp.setTitle("district.type.title");
                for (DistrictType dtp : DistrictType.TYPES.values()) {
                    resp.addRadio("type." + dtp.id(), LDUIRow.ELM_BLUE, dtp == this.type, resp.val(dtp.name()));
                }
                resp.addButton("type.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 3: {
                resp.setTitle("district.manager.title");
                resp.addRow("manager.current", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.manage.getManagerName());
                resp.addField("manager.field", this.manage.getManagerName());
                resp.addButton("manager.submit", LDUIRow.ELM_GENERIC, this.manage.hasManager() ? LDUIButton.OPEN : LDUIButton.ADD);
                if (this.manage.hasManager()) {
                    resp.addButton("manager.remove", LDUIRow.ELM_GENERIC, LDUIButton.REM);
                }
                resp.setFormular();
                break;
            }
            case 2: {
                resp.setTitle("district.buy.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.id);
                resp.addRow("buy.info", LDUIRow.ELM_YELLOW, LDUIButton.BLANK, null);
                if (!this.owner.is_county) {
                    resp.addButton("buy.this_county", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                }
                if (container.ldp.municipality.id >= 0 && !this.owner.is_county && this.owner.municipality.id != container.ldp.municipality.id) {
                    resp.addButton("buy.my_municipality", LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                }
                resp.addButton("buy.my_county", this.county().id == container.ldp.county.id ? LDUIRow.ELM_RED : LDUIRow.ELM_BLUE, LDUIButton.RADIO_UNCHECKED);
                resp.addButton("buy.payer", LDUIRow.ELM_GENERIC, LDUIButton.CHECK_UNCHECKED);
                resp.addButton("buy.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 4: {
                resp.setTitle("district.set_price.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.id);
                resp.addField("set_price.field");
                resp.addButton("set_price.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 7: {
                AppearModule.resp(container, resp, "district", this.icon, this.color, canman);
                break;
            }
            case 5: {
                NormModule.respNormList(this.norms, container, resp, "district", canman);
                break;
            }
            case 6: {
                NormModule.respNormEdit(this.norms, container, resp, "district", canman);
                break;
            }
            case 8: {
                resp.setTitle("district.merge.title");
                resp.addRow("merge.wip", LDUIRow.ELM_GENERIC);
                break;
            }
            case 9: {
                resp.setTitle("district.disband.title");
                resp.addRow("disband.warning0", LDUIRow.ELM_RED);
                resp.addButton("disband.warning1", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                resp.addBlank();
                resp.addRow("disband.info", LDUIRow.ELM_GENERIC);
                resp.addField("disband.name");
                resp.addButton("disband.submit", LDUIRow.ELM_YELLOW, canoman ? LDUIButton.OPEN : LDUIButton.EMPTY);
                resp.setFormular();
                break;
            }
            case -1: {
                resp.setTitle("district.create.title");
                resp.addRow("create.name", LDUIRow.ELM_GENERIC);
                resp.addField("create.name_field");
                resp.addBlank();
                resp.addRow("create.owner", LDUIRow.ELM_YELLOW);
                resp.addRadio("create.owner_county", LDUIRow.ELM_BLUE, true);
                if (container.ldp.municipality.manage.can(PermAction.CREATE_DISTRICT, container.ldp.uuid)) {
                    resp.addRadio("create.owner_municipality", LDUIRow.ELM_BLUE, false);
                }
                resp.addCheck("create.owner_funded", LDUIRow.ELM_GREEN, true);
                resp.addBlank();
                resp.addButton("create.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
                resp.setFormular();
                resp.setNoBack();
            }
        }
        this.external.sync_packet(container, resp);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        boolean canman = !this.locked && this.can(PermAction.MANAGE_DISTRICT, container.ldp.uuid) || container.ldp.adm;
        boolean canoman = !this.locked && this.owner.manageable().can(PermAction.MANAGE_DISTRICT, container.ldp.uuid) || container.ldp.adm;
        switch (req.event()) {
            case "name": {
                container.open(6, this.id, this.norms.index(this.norms.get("name")));
                break;
            }
            case "type": {
                container.open(1);
                break;
            }
            case "owner": {
                container.open(this.owner.is_county ? LDKeys.COUNTY : LDKeys.MUNICIPALITY, 0, this.owner.owid, 0);
                break;
            }
            case "manager": {
                if (!canoman) break;
                container.open(3);
                break;
            }
            case "price": {
                container.open(2);
                break;
            }
            case "set_price": {
                if (!canman) break;
                container.open(4);
                break;
            }
            case "mailbox": {
                if (!canman) break;
                container.open(LDKeys.MAILBOX, this.getLayer().ordinal(), this.id, 0);
                break;
            }
            case "norms": {
                container.open(5);
                break;
            }
            case "appearance": {
                container.open(7);
                break;
            }
            case "merge": {
                container.open(8);
                break;
            }
            case "disband": {
                container.open(9);
                break;
            }
            case "lock": 
            case "locked": {
                if (!container.ldp.adm) break;
                this.locked = !this.locked;
                this.save();
                container.open(0);
                break;
            }
            case "type.submit": {
                DistrictType type;
                if (!canman || (type = DistrictType.TYPES.get(req.getRadio("type."))) == null) break;
                this.type = type;
                container.open(0);
                break;
            }
            case "manager.submit": {
                if (!canoman) break;
                LDPlayer man = req.getPlayerField("manager.field");
                if (man == null) {
                    container.msg("landdev.cmd.uuid_player_not_found", false);
                    break;
                }
                if (this.owner.manageable().isStaff(man.uuid)) {
                    this.manage.setManager(man.uuid);
                    container.open(0);
                    break;
                }
                container.msg("landdev.cmd.player_not_staff", false);
                break;
            }
            case "manager.remove": {
                if (!canoman) break;
                this.manage.setNoManager();
                container.open(0);
                break;
            }
            case "buy.submit": {
                Account account;
                String radio = req.getRadio();
                boolean tct = radio.equals("buy.this_county");
                boolean mct = radio.equals("buy.my_county");
                boolean mmu = radio.equals("buy.my_municipality");
                boolean rep = req.getCheck("buy.payer");
                if (!(tct || mct || mmu)) {
                    container.msg("buy.nobuyer");
                    break;
                }
                if (tct || mct) {
                    Account account2;
                    County ct;
                    if (mct && this.county().id == container.ldp.county.id) {
                        container.msg("buy.alreadypartofcounty");
                        break;
                    }
                    if (tct && this.owner.is_county) {
                        container.msg("buy.alreadypartofcounty");
                        break;
                    }
                    County county = ct = mct ? container.ldp.county : this.county();
                    if (rep && !ct.manage.can(PermAction.FINANCES_USE, container.ldp.uuid)) {
                        container.msg("buy.no_county_perm");
                        break;
                    }
                    Account account3 = account2 = rep ? ct.account : container.ldp.account;
                    if (account2.getBalance() < this.sell.price) {
                        container.msg("buy.notenoughmoney");
                        break;
                    }
                    if (!account2.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)container.ldp.entity, account2, this.sell.price, ct.account)) break;
                    this.owner.set(ct);
                    this.sell.price = 0L;
                    container.open(0);
                    break;
                }
                if (!this.owner.is_county && this.municipality().id == container.ldp.municipality.id) {
                    container.msg("buy.alreadypartofmunicipality");
                    break;
                }
                Municipality mun = container.ldp.municipality;
                if (rep && !mun.manage.can(PermAction.FINANCES_USE, container.ldp.uuid)) {
                    container.msg("buy.no_municipality_perm");
                    break;
                }
                Account account4 = account = rep ? mun.account : container.ldp.account;
                if (account.getBalance() < this.sell.price) {
                    container.msg("buy.notenoughmoney");
                    break;
                }
                if (!account.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)container.ldp.entity, account, this.sell.price, mun.account)) break;
                this.owner.set(mun);
                this.sell.price = 0L;
                container.open(0);
                break;
            }
            case "set_price.submit": {
                if (!canoman) break;
                String[] err = new String[]{""};
                String val = req.getField("set_price.field");
                long value = LDConfig.format_price(err, val);
                if (err[0].length() > 0) {
                    container.msg(err[0], false);
                    break;
                }
                this.sell.price = value;
                container.open(0);
                break;
            }
            case "norm_submit": {
                if (!canman) break;
                NormModule.processNorm(this.norms, container, req, 6);
                break;
            }
            case "norm_bool": {
                if (!canman) break;
                NormModule.processBool(this.norms, container, req, 6);
                break;
            }
            case "disband.warning1": {
                container.open(8);
                break;
            }
            case "disband.submit": {
                if (this.id < 0) break;
                if (this.owner.is_county) {
                    if (this.county().districts.size() < 2) {
                        container.msg("disband.last_county");
                        break;
                    }
                } else if (this.municipality().districts.size() < 2) {
                    container.msg("disband.last_municipality");
                    break;
                }
                if (!canoman) {
                    container.msg("disband.no_perm");
                    break;
                }
                String name = req.getField("disband.name");
                if (!name.equals(this.name())) {
                    container.msg("disband.wrong_name");
                    break;
                }
                this.disband();
                container.open(0);
                break;
            }
            case "create.submit": {
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                LDPlayer player = container.ldp;
                long sum = LDConfig.DISTRICT_CREATION_FEE;
                boolean forct = req.getRadio("create.owner_").equals("county");
                boolean opay = req.getCheck("create.owner_funded");
                String name = req.getField("create.name_field");
                Account account = null;
                if (chunk.district.id > -1 && chunk.district.chunks < 2L) {
                    container.msg("create.exists");
                    break;
                }
                if (forct) {
                    if (chunk.district.county().id < 0) {
                        container.msg("create.county_invalid");
                        break;
                    }
                    if (!chunk.district.county().manage.can(PermAction.CREATE_DISTRICT, player.uuid)) {
                        container.msg("create.no_perm");
                        break;
                    }
                    if (opay) {
                        if (!chunk.district.county().manage.can(PermAction.FINANCES_USE, player.uuid)) {
                            container.msg("create.no_fund_perm");
                            break;
                        }
                        account = chunk.district.county().account;
                    }
                } else {
                    if (player.municipality.id < 0) break;
                    if (player.municipality.county.id != chunk.district.county().id) {
                        container.msg("create.wrong_county");
                        break;
                    }
                    if (!player.municipality.manage.can(PermAction.CREATE_DISTRICT, player.uuid)) {
                        container.msg("create.no_perm");
                        break;
                    }
                    if (opay) {
                        if (!player.municipality.manage.can(PermAction.FINANCES_USE, player.uuid)) {
                            container.msg("create.no_fund_perm");
                            break;
                        }
                        account = player.municipality.account;
                    }
                }
                if (account == null) {
                    account = player.account;
                }
                if (account.getBalance() < sum) {
                    container.msg("create.not_enough_money");
                    break;
                }
                int newid = ResManager.getNewIdFor(this.saveTable());
                if (newid < 0) {
                    player.entity.send("DB ERROR, INVALID NEW ID '" + newid + "'!");
                    break;
                }
                if (!account.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)player.entity, account, sum, ResManager.SERVER_ACCOUNT)) break;
                District dis = new District(newid);
                ResManager.DISTRICTS.put(dis.id, dis);
                if (forct) {
                    chunk.district.county().districts.add(dis.id);
                } else {
                    player.municipality.districts.add(dis.id);
                }
                if (forct) {
                    dis.owner.set(chunk.district.county());
                } else {
                    dis.owner.set(player.municipality);
                }
                if (name.length() > 0) {
                    dis.norms.get("name").set(name);
                }
                dis.save();
                chunk.district = dis;
                chunk.save();
                ResManager.bulkSave(dis.owner.is_county ? dis.owner.county : dis.owner.municipality, dis, chunk, player);
                player.entity.closeUI();
                player.entity.send("landdev.gui.district.create.complete");
                Announcer.announce(Announcer.Target.GLOBAL, 0, "announce.district.created", name, newid);
                break;
            }
            case "appearance.submit": {
                if (!canman || !AppearModule.req(container, req, this.icon, this.color)) break;
                container.open(0);
            }
        }
        if (NormModule.isNormReq(this.norms, container, req, 6, this.id)) {
            return;
        }
        this.external.on_interact(container, req);
    }

    public void disband() {
        this.disbanded = true;
        District wil = ResManager.getDistrict(-1);
        for (Chunk_ chunk : ResManager.CHUNKS.values()) {
            if (chunk.district.id != this.id) continue;
            chunk.district = wil;
            if (chunk.owner.layer() == this.owner.layer() && chunk.owner.owid == this.owner.owid) {
                chunk.owner.set(Layers.NONE, null, 0);
            }
            chunk.save();
        }
        if (this.owner.is_county) {
            this.county().districts.remove((Object)this.id);
            this.county().save();
        } else {
            this.municipality().districts.remove((Object)this.id);
            this.municipality().save();
        }
        this.owner.set(ResManager.getCounty(-1, true));
        this.save();
    }

    public void addTaxStat(long tax) {
        this.tax_collected += tax;
        this.owner.addTaxStat(tax);
    }
}

