/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.municipality;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.Citizens;
import net.fexcraft.mod.landdev.data.ColorData;
import net.fexcraft.mod.landdev.data.Createable;
import net.fexcraft.mod.landdev.data.IconHolder;
import net.fexcraft.mod.landdev.data.Joinable;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.data.Manageable;
import net.fexcraft.mod.landdev.data.NeighborData;
import net.fexcraft.mod.landdev.data.Norms;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.Sellable;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.hooks.ExternalData;
import net.fexcraft.mod.landdev.data.norm.BoolNorm;
import net.fexcraft.mod.landdev.data.norm.IntegerNorm;
import net.fexcraft.mod.landdev.data.norm.StringNorm;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.player.Permit;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.AppearModule;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.ui.modules.NormModule;
import net.fexcraft.mod.landdev.util.Announcer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.world.MessageSender;
import org.apache.commons.lang3.tuple.Pair;

public class Municipality
implements Saveable,
Layer,
LDUIModule {
    public final int id;
    public Createable created = new Createable();
    public Sellable sell = new Sellable(this);
    public IconHolder icon = new IconHolder();
    public ColorData color = new ColorData();
    public NeighborData neighbors = new NeighborData();
    public MailData mail;
    public Manageable manage = new Manageable(true, PermAction.MUNICIPALITY_STAFF);
    public Norms norms = new Norms();
    public ArrayList<Integer> districts = new ArrayList();
    public Citizens citizens = new Citizens(PermAction.MUNICIPALITY_CITIZEN);
    public Joinable requests = new Joinable();
    public ExternalData external = new ExternalData(this);
    public boolean abandoned;
    public long tax_collected;
    public Account account;
    public County county;
    public static final int UI_CREATE = -1;
    public static final int UI_STAFF_LIST = 1;
    public static final int UI_STAFF_EDIT = 2;
    public static final int UI_STAFF_ADD = 3;
    public static final int UI_CITIZEN_LIST = 4;
    public static final int UI_CITIZEN_EDIT = 5;
    public static final int UI_CITIZEN_INVITE = 6;
    public static final int UI_DISTRICTS = 7;
    public static final int UI_PRICE = 8;
    public static final int UI_SET_PRICE = 9;
    public static final int UI_NORMS = 10;
    public static final int UI_NORM_EDIT = 11;
    public static final int UI_APPREARANCE = 12;
    public static final int UI_MERGE = 13;
    public static final int UI_DISBAND = 14;
    public static final int UI_CLAIM = 15;

    public Municipality(int id) {
        this.id = id;
        this.mail = new MailData(this.getLayer(), id);
        this.account = DataManager.getAccount((String)("municipality:" + id), (boolean)false, (boolean)true);
        this.norms.add(new StringNorm("name", ""));
        this.norms.add(new StringNorm("title", ""));
        this.norms.add(new BoolNorm("open-to-join", true));
        this.norms.add(new IntegerNorm("citizen-tax", 1000));
        this.norms.add(new BoolNorm("kick-bankrupt", false));
    }

    @Override
    public void save(JsonMap map) {
        map.add("id", this.id);
        this.created.save(map);
        this.sell.save(map);
        this.icon.save(map);
        this.color.save(map);
        this.neighbors.save(map);
        this.mail.save(map);
        this.manage.save(map);
        this.citizens.save(map);
        this.requests.save(map);
        this.norms.save(map);
        JsonArray array = new JsonArray();
        this.districts.forEach(dis -> array.add(dis.intValue()));
        map.add("districts", (JsonValue)array);
        map.add("county", this.county.id);
        map.add("tax_collected", this.tax_collected);
        this.external.save(this, map);
        if (this.abandoned) {
            map.add("abandoned", this.abandoned);
        }
        DataManager.save((Account)this.account);
    }

    @Override
    public void load(JsonMap map) {
        this.created.load(map);
        this.sell.load(map);
        this.icon.load(map);
        this.color.load(map);
        this.neighbors.load(map);
        this.mail.load(map);
        this.manage.load(map);
        this.citizens.load(map);
        this.requests.load(map);
        this.norms.load(map);
        this.account.setName(this.name());
        if (map.has("districts")) {
            JsonArray array = map.getArray("districts");
            this.districts.clear();
            ((List)array.value).forEach(elm -> this.districts.add(elm.integer_value()));
        }
        this.county = ResManager.getCounty(map.getInteger("county", -1), true);
        this.tax_collected = map.getLong("tax_collected", 0L);
        this.abandoned = (Boolean)map.get("abandoned", (Object)false);
        this.external.load(this, map);
    }

    @Override
    public void gendef() {
        this.county = ResManager.getCounty(-1, true);
        if (this.id == -1) {
            this.norms.get("name").set("Wilderness");
            this.norms.get("title").set("Wild");
            this.districts.clear();
            if (!this.county.municipalities.contains(this.id)) {
                this.county.municipalities.add(this.id);
            }
            this.color.set(39168);
        } else if (this.id == 0) {
            this.norms.get("name").set("Spawn Town");
            this.norms.get("title").set("Protected");
            this.districts.clear();
            this.districts.add(0);
            this.county = ResManager.getCounty(0, true);
            if (!this.county.municipalities.contains(this.id)) {
                this.county.municipalities.add(this.id);
            }
            this.color.set(0xFF9900);
        } else {
            this.norms.get("name").set("Unnamed Place");
            this.norms.get("title").set("Untitled");
        }
        this.external.gendef(this);
    }

    @Override
    public String saveId() {
        return "" + this.id;
    }

    @Override
    public String saveTable() {
        return "municipalities";
    }

    @Override
    public Layers getLayer() {
        return Layers.MUNICIPALITY;
    }

    @Override
    public Layers getParentLayer() {
        return Layers.COUNTY;
    }

    @Override
    public int lid() {
        return this.id;
    }

    public String name() {
        return this.norms.get("name").string();
    }

    public String title() {
        return this.norms.get("title").string();
    }

    public boolean opentojoin() {
        return this.norms.get("open-to-join").bool();
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("municipality.title");
        boolean canman = this.manage.can(PermAction.MANAGE_MUNICIPALITY, container.ldp.uuid) || container.ldp.adm;
        switch (container.pos.x) {
            case 0: {
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                if (this.abandoned) {
                    resp.addButton("abandoned", LDUIRow.ELM_RED, LDUIButton.OPEN, this.id);
                }
                resp.addRow("name", LDUIRow.ELM_GENERIC, canman ? LDUIButton.OPEN : LDUIButton.EMPTY, canman, this.name());
                resp.addRow("muntitle", LDUIRow.ELM_GENERIC, canman ? LDUIButton.OPEN : LDUIButton.EMPTY, canman, this.title());
                resp.addButton("county", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.county.name());
                ChunkKey center = ResManager.MUN_CENTERS.get(this.id);
                resp.addButton("center", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, center == null ? "" : center.x + ", " + center.z);
                resp.addButton("districts", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.districts.size());
                resp.addButton("citizen", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.citizens.size());
                resp.addRow("manager", LDUIRow.ELM_GENERIC, this.manage.getManagerName());
                resp.addButton("staff", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.manage.staff.size());
                if (canman) {
                    resp.addRow("balance", LDUIRow.ELM_GENERIC, Config.getWorthAsString((long)this.account.getBalance()));
                }
                resp.addBlank();
                if (this.sell.price > 0L) {
                    resp.addButton("price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.sell.price_formatted());
                }
                if (canman) {
                    resp.addButton("set_price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                }
                if (this.sell.price > 0L) {
                    resp.addBlank();
                }
                if (canman) {
                    resp.addButton("mailbox", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.mail.unread());
                }
                resp.addButton("norms", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                resp.addButton("appearance", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                resp.addBlank();
                resp.addButton("merge", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                resp.addButton("disband", LDUIRow.ELM_RED, LDUIButton.OPEN);
                break;
            }
            case 4: {
                resp.setTitle("municipality.citizen.title");
                if (this.opentojoin() || this.abandoned) {
                    resp.addRow("citizen.open", LDUIRow.ELM_GREEN);
                } else {
                    resp.addRow("citizen.closed", LDUIRow.ELM_RED);
                }
                if (this.manage.can(PermAction.PLAYER_INVITE, container.ldp.uuid) || container.ldp.adm) {
                    resp.addButton("citizen.invite", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                }
                if (container.ldp.municipality.id != this.id) {
                    long to = this.requests.get(container.ldp);
                    if (to > -1L) {
                        if (to > 0L) {
                            resp.addRow("citizen.rejected", LDUIRow.ELM_RED);
                            resp.addRow("citizen.timeout", LDUIRow.ELM_GREEN, Time.getAsString((long)to));
                        } else {
                            resp.addRow("citizen.pending", LDUIRow.ELM_GREEN);
                        }
                    } else if (this.opentojoin()) {
                        resp.addButton("citizen.join", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                    } else {
                        resp.addButton("citizen.request", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                    }
                } else {
                    resp.addButton("citizen.leave", LDUIRow.ELM_RED, LDUIButton.REM);
                }
                resp.addBlank();
                resp.addRow("citizen.list", LDUIRow.ELM_YELLOW);
                for (UUID uuid : this.citizens.map().keySet()) {
                    resp.addButton("citizen.edit." + String.valueOf(uuid), LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!- " + ResManager.getPlayerName(uuid));
                }
                break;
            }
            case 5: {
                resp.setTitle("municipality.citizen.edit.title");
                Citizens.Citizen cit = this.citizens.get(container.pos.z);
                resp.addRow("citizen.name", LDUIRow.ELM_GENERIC, cit.getPlayerName());
                resp.addRow("citizen.uuid", LDUIRow.ELM_GENERIC, cit.uuid);
                if (container.ldp.adm) {
                    resp.addButton("citizen.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                }
                resp.addHiddenField("uuid", cit.uuid);
                resp.addBlank();
                resp.addRow("citizen.permissions", LDUIRow.ELM_YELLOW);
                for (Map.Entry<PermAction, Boolean> entry : cit.actions.entrySet()) {
                    resp.addButton("citizen.permission." + entry.getKey().name().toLowerCase(), LDUIRow.ELM_GENERIC, LDUIButton.enabled(entry.getValue()));
                }
                resp.setNoSubmit();
                break;
            }
            case 6: {
                resp.setTitle("municipality.citizen.invite.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("citizen.invite.info", LDUIRow.ELM_YELLOW);
                resp.addField("citizen.invite.field");
                resp.addButton("citizen.invite.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 1: {
                resp.setTitle("municipality.staff.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("manager", LDUIRow.ELM_GENERIC, this.manage.getManagerName());
                resp.addButton("staff.add", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                resp.addBlank();
                resp.addRow("staff.list", LDUIRow.ELM_YELLOW);
                for (Manageable.Staff staff : this.manage.staff) {
                    resp.addButton("staff.edit." + String.valueOf(staff.uuid), LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!- " + staff.getPlayerName());
                }
                break;
            }
            case 2: {
                resp.setTitle("municipality.staff.edit.title");
                Manageable.Staff staff = this.manage.staff.get(container.pos.z);
                resp.addRow("staff.name", LDUIRow.ELM_GENERIC, staff.getPlayerName());
                resp.addRow("staff.uuid", LDUIRow.ELM_GENERIC, staff.uuid);
                if (container.ldp.adm || !this.manage.isManager(staff) || this.abandoned) {
                    resp.addButton("staff.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                    resp.addButton("staff.setmanager", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                }
                resp.addHiddenField("uuid", staff.uuid);
                resp.addBlank();
                resp.addRow("staff.permissions", LDUIRow.ELM_YELLOW);
                for (Map.Entry<PermAction, Boolean> entry : staff.actions.entrySet()) {
                    resp.addButton("staff.permission." + entry.getKey().name().toLowerCase(), LDUIRow.ELM_GENERIC, LDUIButton.enabled(entry.getValue()));
                }
                resp.setNoSubmit();
                break;
            }
            case 3: {
                resp.setTitle("municipality.staff.add.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("staff.add.info", LDUIRow.ELM_YELLOW);
                resp.addField("staff.add.field");
                resp.addButton("staff.add.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 7: {
                resp.setTitle("municipality.districts.title");
                for (int id : this.districts) {
                    resp.addButton("district." + id, LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!" + ResManager.getDistrict(id).name());
                }
                break;
            }
            case 8: {
                resp.setTitle("municipality.buy.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.id);
                resp.addRow("buy.info0", LDUIRow.ELM_YELLOW, LDUIButton.BLANK, null);
                resp.addRow("buy.info1", LDUIRow.ELM_YELLOW, LDUIButton.BLANK, null);
                resp.addButton("buy.county_pays", LDUIRow.ELM_GENERIC, LDUIButton.CHECK_UNCHECKED);
                resp.addButton("buy.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 9: {
                resp.setTitle("municipality.set_price.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, LDUIButton.BLANK, this.id);
                resp.addField("set_price.field");
                resp.addButton("set_price.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                break;
            }
            case 12: {
                AppearModule.resp(container, resp, "municipality", this.icon, this.color, canman);
                break;
            }
            case 10: {
                NormModule.respNormList(this.norms, container, resp, "municipality", canman);
                break;
            }
            case 11: {
                NormModule.respNormEdit(this.norms, container, resp, "municipality", canman);
                break;
            }
            case 13: {
                resp.setTitle("municipality.merge.title");
                resp.addRow("merge.wip", LDUIRow.ELM_GENERIC);
                break;
            }
            case 14: {
                resp.setTitle("municipality.disband.title");
                resp.addRow("disband.warning0", LDUIRow.ELM_RED);
                resp.addRow("disband.warning1", LDUIRow.ELM_YELLOW);
                resp.addRow("disband.warning2", LDUIRow.ELM_YELLOW);
                resp.addButton("disband.warning3", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                resp.addBlank();
                resp.addRow("disband.mode", LDUIRow.ELM_YELLOW);
                resp.addRadio("disband.abandon", LDUIRow.ELM_BLUE, true);
                resp.addRadio("disband.disband", LDUIRow.ELM_BLUE, false);
                resp.addBlank();
                if (this.county.id >= 0) {
                    resp.addCheck("disband.give_county", LDUIRow.ELM_BLUE, false);
                }
                resp.addCheck("disband.remove_citizen", LDUIRow.ELM_BLUE, false);
                resp.addBlank();
                resp.addRow("disband.info", LDUIRow.ELM_GENERIC);
                resp.addField("disband.name");
                resp.addButton("disband.submit", LDUIRow.ELM_YELLOW, canman ? LDUIButton.OPEN : LDUIButton.EMPTY);
                resp.setFormular();
                break;
            }
            case 15: {
                break;
            }
            case -1: {
                resp.setTitle("municipality.create.title");
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                County county = chunk.district.county();
                boolean cn = county.norms.get("new-municipalities").bool();
                boolean pp = container.ldp.hasPermit(PermAction.CREATE_MUNICIPALITY, county.getLayer(), county.id);
                if (!cn && !pp) {
                    resp.addRow("create.no_perm", LDUIRow.ELM_GENERIC, LDUIButton.BLANK);
                    break;
                }
                resp.addRow("create.name", LDUIRow.ELM_GENERIC);
                resp.addField("create.name_field");
                resp.addCheck("create.county_funded", LDUIRow.ELM_GENERIC, pp);
                if (chunk.district.id >= 0) {
                    resp.addCheck("create.claim_district", LDUIRow.ELM_GENERIC, pp);
                }
                resp.addButton("create.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
                resp.setFormular();
                resp.setNoBack();
            }
        }
        this.external.sync_packet(container, resp);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        Manageable.Staff staff;
        LDPlayer player = container.ldp;
        boolean canman = this.manage.can(PermAction.MANAGE_MUNICIPALITY, container.ldp.uuid) || container.ldp.adm;
        switch (req.event()) {
            case "name": {
                if (!canman) break;
                container.open(11, this.id, this.norms.index(this.norms.get("name")));
                break;
            }
            case "muntitle": {
                if (!canman) break;
                container.open(11, this.id, this.norms.index(this.norms.get("title")));
                break;
            }
            case "county": {
                container.open(LDKeys.COUNTY, 0, this.county.id, 0);
                break;
            }
            case "citizen": {
                container.open(4);
                break;
            }
            case "districts": {
                container.open(7);
                break;
            }
            case "staff": {
                container.open(1);
                break;
            }
            case "price": {
                container.open(8);
                break;
            }
            case "set_price": {
                if (!canman) break;
                container.open(9);
                break;
            }
            case "mailbox": {
                if (!canman) break;
                container.open(LDKeys.MAILBOX, this.getLayer().ordinal(), this.id, 0);
                break;
            }
            case "norms": {
                container.open(10);
                break;
            }
            case "appearance": {
                container.open(12);
                break;
            }
            case "merge": {
                container.open(13);
                break;
            }
            case "disband": {
                container.open(14);
                break;
            }
            case "abandoned": {
                container.open(1);
                break;
            }
            case "buy.submit": {
                break;
            }
            case "set_price.submit": {
                if (!canman) break;
                String[] err = new String[]{""};
                String val = req.getField("set_price.field");
                long value = LDConfig.format_price(err, val);
                if (err[0].length() > 0) {
                    container.msg(err[0], false);
                    break;
                }
                this.sell.price = value;
                container.open(0);
                break;
            }
            case "norm_submit": {
                if (!canman) break;
                NormModule.processNorm(this.norms, container, req, 11);
                break;
            }
            case "norm_bool": {
                if (!canman) break;
                NormModule.processBool(this.norms, container, req, 11);
                break;
            }
            case "citizen.invite": {
                container.open(6);
                break;
            }
            case "citizen.join": {
                if (!this.opentojoin() && !this.abandoned) break;
                if (player.isMunicipalityManager()) {
                    container.msg("landdev.mail.municipality.citizen.ismanager", false);
                    break;
                }
                if (player.isCountyManager() && this.county.id != player.county.id) {
                    container.msg("landdev.mail.county.citizen.ismanager", false);
                    break;
                }
                player.setCitizenOf(this);
                container.open(0);
                break;
            }
            case "citizen.leave": {
                if (player.isMunicipalityManager() && !player.adm) {
                    container.msg("landdev.mail.municipality.citizen.ismanager", false);
                    break;
                }
                if (player.isMunicipalityManager()) {
                    this.manage.setManager(ResManager.CONSOLE_UUID);
                }
                player.leaveMunicipality();
                container.open(0);
                break;
            }
            case "citizen.request": {
                if (this.opentojoin()) break;
                Mail mail = new Mail(MailType.REQUEST, Layers.PLAYER, player.uuid, Layers.MUNICIPALITY, this.id);
                mail.setTitle(player.name_raw()).expireInDays(7);
                mail.addMessage("landdev.mail.player.municipality.join_request0", player.name_raw());
                mail.addMessage("landdev.mail.player.municipality.join_request1");
                this.mail.mails.add(mail);
                this.requests.timeouts.put(player.uuid, 0L);
                container.open(4);
                break;
            }
            case "citizen.invite.submit": {
                if (!this.manage.can(PermAction.PLAYER_INVITE, player.uuid) && !player.adm) break;
                LDPlayer ply = req.getPlayerField("citizen.invite.field");
                if (ply == null) {
                    container.msg("citizen.invite.notfound");
                    break;
                }
                Mail mail = new Mail(MailType.INVITE, Layers.MUNICIPALITY, this.id, Layers.PLAYER, ply.uuid);
                mail.setTitle(this.name()).expireInDays(7);
                mail.addMessage("landdev.mail.municipality.citizen.invite0");
                mail.addMessage("landdev.mail.municipality.citizen.invite1", this.name());
                ply.addMailAndSave(mail);
                player.entity.send("landdev.gui.municipality.citizen.invite.success");
                player.entity.closeUI();
                break;
            }
            case "citizen.remove": {
                if (!canman) break;
                Citizens.Citizen cit = this.citizens.get(req.getUUIDField());
                if (cit != null && !this.manage.isManager(cit.uuid)) {
                    LDPlayer ply = ResManager.getPlayer(cit.uuid, true);
                    ply.setCitizenOf(ResManager.getMunicipality(-1, true));
                    Mail mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage("landdev.mail.municipality.citizen.nolonger");
                    ply.addMailAndSave(mail);
                    mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, this.id, Layers.MUNICIPALITY, this.id).expireInDays(7);
                    mail.setTitle(this.name()).addMessage("landdev.mail.municipality.citizen.removed", cit.getPlayerName());
                    this.mail.mails.add(mail);
                    Announcer.announce(Announcer.Target.MUNICIPALITY, this.id, "announce.municipality.citizen.removed", cit.getPlayerName(), this.name(), this.id);
                }
                container.open(4);
                break;
            }
            case "staff.add": {
                container.open(3);
                break;
            }
            case "staff.add.submit": {
                if (!canman && !this.abandoned) break;
                LDPlayer ply = req.getPlayerField("staff.add.field");
                if (ply == null) {
                    container.msg("staff.add.notfound");
                    break;
                }
                if (!this.citizens.isCitizen(ply.uuid)) {
                    container.msg("staff.add.notmember");
                    break;
                }
                Mail mail = new Mail(MailType.INVITE, Layers.MUNICIPALITY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                mail.setTitle(this.name()).setStaffInvite();
                mail.addMessage("landdev.mail.municipality.staff.invite0");
                mail.addMessage("landdev.mail.municipality.staff.invite1");
                ply.addMailAndSave(mail);
                player.entity.send("landdev.gui.municipality.staff.add.success");
                player.entity.closeUI();
                break;
            }
            case "staff.remove": {
                if (!canman) break;
                Manageable.Staff staff2 = this.manage.getStaff(req.getUUIDField());
                if (staff2 != null && !this.manage.isManager(staff2)) {
                    this.manage.removeStaff(staff2.uuid);
                    LDPlayer ply = ResManager.getPlayer(staff2.uuid, true);
                    Mail mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage("landdev.mail.municipality.staff.nolonger");
                    ply.addMailAndSave(mail);
                    for (Manageable.Staff stf : this.manage.staff) {
                        LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                        mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, this.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                        mail.setTitle(this.name()).addMessage("landdev.mail.municipality.staff.removed", staff2.getPlayerName());
                        stp.addMailAndSave(mail);
                    }
                    Announcer.announce(Announcer.Target.MUNICIPALITY, this.id, "announce.municipality.staff.removed", staff2.getPlayerName(), this.name(), this.id);
                }
                container.open(1);
                break;
            }
            case "staff.setmanager": {
                if (!player.adm && !canman && !this.abandoned) break;
                Manageable.Staff staff3 = this.manage.getStaff(req.getUUIDField());
                if (staff3 != null) {
                    this.manage.setManager(staff3.uuid);
                    LDPlayer ply = ResManager.getPlayer(staff3.uuid, true);
                    Mail mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage("landdev.mail.municipality.manager_now");
                    ply.addMailAndSave(mail);
                    this.abandoned = false;
                    this.save();
                    for (Manageable.Staff stf : this.manage.staff) {
                        LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                        mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, this.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                        mail.setTitle(this.name()).addMessage("landdev.mail.municipality.manager_set", staff3.getPlayerName());
                        stp.addMailAndSave(mail);
                    }
                    Announcer.announce(Announcer.Target.MUNICIPALITY, this.id, "announce.municipality.manager_set", staff3.getPlayerName(), this.name(), this.id);
                }
                container.open(0);
                break;
            }
            case "disband.warning3": {
                container.open(13);
                break;
            }
            case "disband.submit": {
                if (!canman && !player.adm) {
                    container.msg("disband.no_perm");
                    break;
                }
                boolean disband = req.getRadio().equals("disband.disband");
                if (disband && this.county.municipalities.size() < 2 && this.county.id >= 0) {
                    container.msg("disband.last_county");
                    break;
                }
                boolean gc = req.getCheck("disband.give_county");
                boolean rc = req.getCheck("disband.remove_citizen");
                if (!disband && gc) {
                    container.msg("disband.abandon_give_county");
                    break;
                }
                String name = req.getField("disband.name");
                if (!name.equals(this.name())) {
                    container.msg("disband.wrong_name");
                    break;
                }
                boolean bl = this.abandoned = !disband;
                if (this.county.id >= 0) {
                    this.county.municipalities.remove((Object)this.id);
                    this.county.save();
                }
                this.manage.staff.clear();
                this.manage.setManager((UUID)null);
                if (rc || disband) {
                    this.citizens.clear(true);
                }
                if (gc && this.county.id >= 0) {
                    ArrayList<Integer> ids = new ArrayList<Integer>(this.districts);
                    for (int did : ids) {
                        District dis = ResManager.getDistrict(did);
                        dis.owner.set(this.county);
                        dis.save();
                    }
                } else if (disband) {
                    ArrayList<Integer> ids = new ArrayList<Integer>(this.districts);
                    for (int did : ids) {
                        District dis = ResManager.getDistrict(did);
                        dis.disband();
                    }
                }
                this.save();
                container.open(0);
                break;
            }
            case "create.submit": {
                Account acc;
                Permit perm;
                Pair<Integer, Double> mdis;
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                County county = chunk.district.county();
                long sum = LDConfig.MUNICIPALITY_CREATION_FEE;
                boolean cn = county.norms.get("new-municipalities").bool();
                boolean pp = player.hasPermit(PermAction.CREATE_MUNICIPALITY, county.getLayer(), county.id);
                if (!cn && !pp) {
                    player.entity.send("landdev.cmd.mun.no_new_municipalities");
                    player.entity.send("landdev.cmd.mun.no_create_permit");
                    player.entity.closeUI();
                    break;
                }
                if (player.isInManagement(Layers.MUNICIPALITY)) {
                    container.msg("create.leave_management");
                    break;
                }
                if (player.isInManagement(Layers.COUNTY) && player.county.id != county.id) {
                    container.msg("create.leave_county_management");
                    break;
                }
                if (player.isInManagement(Layers.REGION) && player.county.region.id != county.region.id) {
                    container.msg("create.leave_region_management");
                    break;
                }
                int min_dis = Math.max(LDConfig.MIN_MUN_DIS, county.norms.get("min-municipality-distance").integer());
                if (min_dis < LDConfig.MIN_MUN_DIS) {
                    min_dis = LDConfig.MIN_MUN_DIS;
                }
                if ((Integer)(mdis = ResManager.disToNearestMun(chunk.key, -1)).getLeft() >= 0 && (Double)mdis.getRight() < (double)min_dis) {
                    container.msg("create.too_close");
                    player.entity.send("landdev.cmd.mun.center_too_close", new Object[]{ResManager.getMunicipality((Integer)mdis.getLeft(), true).name(), mdis.getLeft()});
                    break;
                }
                String name = req.getField("create.name_field");
                if (!this.validateName(container, name)) break;
                boolean uca = req.getCheck("create.county_funded");
                if (!pp && !uca) {
                    sum += (long)county.norms.get("new-municipality-fee").integer();
                }
                Permit permit = perm = pp ? player.getPermit(PermAction.CREATE_MUNICIPALITY_FUND, county.getLayer(), county.id) : null;
                if (!pp && uca) {
                    container.msg("create.no_fund_permit");
                    break;
                }
                Account account = acc = pp && uca ? perm.getAccount() : player.account;
                if (acc.getBalance() < sum) {
                    LandDev.log("Municipality creation failed due to missing funds.");
                    LandDev.log("Expected: " + sum + "; Available: " + acc.getBalance());
                    LandDev.log("Account: " + player.account.getTypeAndId() + "; Bank: " + player.account.getBank().id);
                    LandDev.log("Chunk: " + String.valueOf(chunk.key));
                    container.msg("create.not_enough_money");
                    break;
                }
                boolean claim = req.getCheck("create.claim_district");
                if (claim && !chunk.district.norms.get("municipality-can-form").bool()) {
                    container.msg("create.district_no_forming");
                    break;
                }
                if (!claim && chunk.district.id >= 0) {
                    container.msg("create.chunk_is_claimed");
                    break;
                }
                int newid = ResManager.getNewIdFor(this.saveTable());
                int ndid = -2;
                if (newid < 0) {
                    player.entity.send("DB ERROR, INVALID NEW ID '" + newid + "'!");
                    break;
                }
                if (!claim && (ndid = ResManager.getNewIdFor(chunk.district.saveTable())) < 0) {
                    player.entity.send("DB ERROR, INVALID NEW DISTRICT ID '" + newid + "'!");
                    break;
                }
                if (!acc.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)player.entity, acc, sum, ResManager.SERVER_ACCOUNT)) break;
                if (!uca) {
                    ResManager.SERVER_ACCOUNT.getBank().processAction(Bank.Action.TRANSFER, null, ResManager.SERVER_ACCOUNT, (long)county.norms.get("new-municipality-fee").integer(), county.account);
                }
                Municipality mold = player.municipality;
                County cold = player.county;
                Municipality mnew = new Municipality(newid);
                mnew.created.create(player.uuid);
                ResManager.MUN_CENTERS.put(mnew.id, chunk.key);
                mnew.gendef();
                ResManager.MUNICIPALITIES.put(mnew.id, mnew);
                mnew.norms.get("name").set(name);
                mnew.county = county;
                county.municipalities.add(mnew.id);
                player.setCitizenOf(mnew);
                mnew.manage.add(player);
                mnew.manage.setManager(player);
                if (claim) {
                    mnew.districts.add(chunk.district.id);
                    chunk.district.owner.set(mnew);
                    chunk.district.manage.clear();
                    chunk.district.save();
                } else {
                    District dis = new District(ndid);
                    dis.created.create(player.uuid);
                    ResManager.DISTRICTS.put(dis.id, dis);
                    mnew.districts.add(dis.id);
                    chunk.district = dis;
                    chunk.owner.set(Layers.MUNICIPALITY, null, mnew.id);
                    chunk.sell.price = 0L;
                    chunk.save();
                    dis.owner.set(mnew);
                    dis.save();
                }
                ResManager.SERVER_ACCOUNT.getBank().processAction(Bank.Action.TRANSFER, null, ResManager.SERVER_ACCOUNT, LDConfig.MUNICIPALITY_CREATION_FEE / 2L, mnew.account);
                ResManager.bulkSave(mnew, county, player, mold, cold);
                player.entity.closeUI();
                player.entity.send("landdev.gui.municipality.create.complete");
                Announcer.announce(Announcer.Target.GLOBAL, 0, "announce.municipality.created", name, newid);
                break;
            }
            case "appearance.submit": {
                if (!canman || !AppearModule.req(container, req, this.icon, this.color)) break;
                container.open(0);
            }
        }
        if (NormModule.isNormReq(this.norms, container, req, 11, this.id)) {
            return;
        }
        if (req.event().startsWith("district.")) {
            int id = Integer.parseInt(req.event().substring("district.".length()));
            container.open(LDKeys.DISTRICT, 0, id, 0);
            return;
        }
        if (req.event().startsWith("citizen.edit.")) {
            UUID uuid = UUID.fromString(req.event().substring("citizen.edit.".length()));
            if (!this.citizens.isCitizen(uuid)) {
                return;
            }
            container.open(5, this.id, this.citizens.indexOf(uuid));
            return;
        }
        if (req.event().startsWith("staff.edit.")) {
            staff = this.manage.getStaff(UUID.fromString(req.event().substring("staff.edit.".length())));
            if (staff == null) {
                return;
            }
            container.open(2, this.id, this.manage.staff.indexOf(staff));
            return;
        }
        if (req.event().startsWith("staff.permission.")) {
            if (!canman) {
                return;
            }
            staff = this.manage.getStaff(req.getUUIDField());
            if (this.manage.isManager(staff)) {
                container.msg("staff.permissions.ismanager");
                return;
            }
            PermAction action = PermAction.get(req.event().substring("staff.permission.".length()).toUpperCase());
            if (action == null) {
                return;
            }
            staff.actions.put(action, staff.actions.get((Object)action) == false);
            container.open(2);
            return;
        }
        if (req.event().startsWith("citizen.permission.")) {
            if (!canman) {
                return;
            }
            Citizens.Citizen cit = this.citizens.get(req.getUUIDField());
            PermAction action = PermAction.get(req.event().substring("citizen.permission.".length()).toUpperCase());
            if (action == null) {
                return;
            }
            cit.actions.put(action, cit.actions.get((Object)action) == false);
            container.open(5);
            return;
        }
        this.external.on_interact(container, req);
    }
}

