/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.events;

import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.TaxSystem;
import net.fexcraft.mod.landdev.util.broad.BroadcastChannel;
import net.fexcraft.mod.landdev.util.broad.Broadcaster;
import net.fexcraft.mod.uni.UniEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="landdev", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    private static long time;
    private static boolean moved;
    private static boolean label;

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LDPlayer player = ResManager.getPlayer(event.getEntity().m_36316_().getId(), true);
        player.entity = UniEntity.getEntity((Object)event.getEntity());
        player.offline = false;
        player.login = Time.getDate();
        player.chunk_last = ResManager.getChunkP(event.getEntity());
        TaxSystem.taxPlayer(player, null, false);
        Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.SERVER, null, LDConfig.SERVLANG_JOINED.formatted(player.name_raw()), new Object[0]);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LDPlayer player = ResManager.getPlayer(event.getEntity().m_36316_().getId(), false);
        if (player != null) {
            Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.SERVER, null, LDConfig.SERVLANG_LEFT.formatted(player.name_raw()), new Object[0]);
            player.save();
            player.last_login = player.login;
            player.last_logout = Time.getDate();
            player.login = 0L;
            player.offline = true;
            player.entity = null;
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LDPlayer player = ResManager.getPlayer(event.getEntity().m_36316_().getId(), false);
        if (player != null) {
            player.entity = UniEntity.getEntity((Object)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().f_46443_) {
            return;
        }
        if (event.player.m_9236_() != ((MinecraftServer)FCL.SERVER.get()).m_129783_()) {
            return;
        }
        LDPlayer player = ResManager.getPlayer(event.player);
        if (player == null) {
            return;
        }
        time = Time.getDate();
        if (time > player.last_pos_update) {
            player.last_pos_update = time;
            player.chunk_last = player.chunk_current;
            player.chunk_current = ResManager.getChunkP(event.player);
            if (player.chunk_current == null) {
                return;
            }
            if (player.chunk_last == null) {
                player.chunk_last = player.chunk_current;
            }
            moved = player.chunk_current.district.id != player.chunk_last.district.id;
            boolean bl = label = player.chunk_current.label.present && player.chunk_current != player.chunk_last;
            if (moved || label) {
                player.sendLocationUpdate(moved, label, 0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMessage(ServerChatEvent event) {
        LDPlayer player = ResManager.getPlayer(event.getPlayer());
        Broadcaster.send(player, event.getMessage().getString());
        event.setCanceled(LDConfig.CHAT_OVERRIDE);
    }
}

