/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.data.chunk.ChunkType;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;

public class InteractHandler {
    public static boolean control(int x, int y, int z, Object entity, boolean interact) {
        LDPlayer player = ResManager.getPlayer(entity);
        if (player == null) {
            return false;
        }
        if (player.adm) {
            return true;
        }
        Chunk_ chunk = ResManager.getChunkS(x, z);
        if (chunk.district.id < 0) {
            if (chunk.district.id == -1) {
                return LDConfig.EDIT_WILDERNESS;
            }
            if (chunk.district.id == -2) {
                return false;
            }
            player.entity.bar("interact.control.unknown_district");
            return false;
        }
        return InteractHandler.hasperm(chunk, player, interact);
    }

    public static boolean hasperm(Chunk_ chunk, LDPlayer player, boolean interact) {
        Long l;
        if (interact && chunk.access.interact) {
            return true;
        }
        ChunkType type = chunk.owner.unowned ? ChunkType.NORMAL : chunk.type;
        boolean pass = false;
        block0 : switch (type) {
            case NORMAL: {
                pass = chunk.district.owner.isPartOf(player);
                break;
            }
            case PRIVATE: {
                if (chunk.owner.playerchunk) {
                    pass = player.uuid.equals(chunk.owner.player);
                    break;
                }
                switch (chunk.owner.owner) {
                    case COMPANY: {
                        break block0;
                    }
                    case COUNTY: {
                        pass = chunk.district.owner.manageable().isManager(player.uuid);
                        break block0;
                    }
                    case DISTRICT: {
                        pass = chunk.district.manage.isManager(player.uuid) || chunk.district.owner.manageable().isManager(player.uuid);
                        break block0;
                    }
                    case MUNICIPALITY: {
                        pass = chunk.district.owner.manageable().isManager(player.uuid);
                        break block0;
                    }
                    case REGION: {
                        pass = chunk.district.region().manage.isManager(player.uuid);
                        break block0;
                    }
                }
                break;
            }
            case PUBLIC: {
                pass = true;
                break;
            }
            case RESTRICTED: {
                switch (chunk.owner.owner) {
                    case COMPANY: {
                        break block0;
                    }
                    case COUNTY: {
                        pass = chunk.district.owner.manageable().isStaff(player.uuid);
                        break block0;
                    }
                    case DISTRICT: {
                        pass = chunk.district.manage.isManager(player.uuid) || chunk.district.owner.manageable().isStaff(player.uuid);
                        break block0;
                    }
                    case MUNICIPALITY: {
                        pass = chunk.district.owner.manageable().isStaff(player.uuid);
                        break block0;
                    }
                    case REGION: {
                        pass = chunk.district.region().manage.isStaff(player.uuid);
                        break block0;
                    }
                }
                break;
            }
            case LOCKED: {
                break;
            }
            default: {
                player.entity.bar("interact.control.unknown_chunk_type");
                return false;
            }
        }
        if (!pass && (l = chunk.access.players.get(player.uuid)) != null) {
            if (Time.getDate() < l) {
                return true;
            }
            chunk.access.players.remove(player.uuid);
        }
        return pass;
    }
}

