/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ProtectorInstance {
    public static ProtectorInstance get(boolean abs, JsonMap map) {
        return abs ? new Absolute() : new Default(map.getArray("blocks"));
    }

    public abstract boolean isProtected(BlockState var1);

    public static class Absolute
    extends ProtectorInstance {
        @Override
        public boolean isProtected(BlockState state) {
            return true;
        }
    }

    public static class Default
    extends ProtectorInstance {
        private ArrayList<Block> blocks = new ArrayList();

        public Default(JsonArray array) {
            ((List)array.value).forEach(elm -> {
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(elm.string_value()));
                if (block != null) {
                    this.blocks.add(block);
                }
            });
        }

        @Override
        public boolean isProtected(BlockState state) {
            return this.blocks.contains(state.m_60734_());
        }
    }
}

