/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.landdev.LDN;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.ChunkRegion;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.util.TaxSystem;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import org.apache.commons.lang3.tuple.Pair;

public class ResManager
implements Saveable {
    public boolean LOADED = false;
    public static ResManager INSTANCE = new ResManager();
    public static Timer SAVER = new Timer();
    public static final UUID CONSOLE_UUID = UUID.fromString("f78a4d8d-d51b-4b39-98a3-230f2de0c670");
    public static ConcurrentHashMap<ChunkKey, Chunk_> CHUNKS = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, District> DISTRICTS = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, Municipality> MUNICIPALITIES = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, County> COUNTIES = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, Region> REGIONS = new ConcurrentHashMap();
    public static ConcurrentHashMap<UUID, LDPlayer> PLAYERS = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, ChunkKey> MUN_CENTERS = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, ChunkKey> CT_CENTERS = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, ChunkKey> RG_CENTERS = new ConcurrentHashMap();
    public static Account SERVER_ACCOUNT;

    public static Chunk_ getChunk(int x, int z) {
        for (Chunk_ ck : CHUNKS.values()) {
            if (ck.key.x != x || ck.key.z != z) continue;
            return ck;
        }
        return ChunkRegion.get(x, z);
    }

    public static Chunk_ getChunkS(double x, double z) {
        return ResManager.getChunk((int)x >> 4, (int)z >> 4);
    }

    public static Chunk_ getChunkS(int x, int z) {
        return ResManager.getChunk(x >> 4, z >> 4);
    }

    public static Chunk_ getChunk(ChunkKey key) {
        for (Chunk_ ck : CHUNKS.values()) {
            if (!ck.key.equals(key)) continue;
            return ck;
        }
        return ChunkRegion.get(key);
    }

    public static Chunk_ getChunk(V3D pos) {
        return ResManager.getChunk((int)pos.x >> 4, (int)pos.z >> 4);
    }

    public static Chunk_ getChunk(EntityW player) {
        return ResManager.getChunk(player.getPos());
    }

    public static Chunk_ getChunkP(Object player) {
        return ResManager.getChunk(UniEntity.get((Object)player).entity);
    }

    public static void remChunk(int x, int z) {
        Chunk_ ck = ResManager.getChunk(x, z);
        if (ck != null) {
            CHUNKS.remove(ck.key);
            ChunkRegion.unload(ck);
        }
    }

    public static District getDistrict(int idx) {
        District dis = DISTRICTS.get(idx);
        if (dis == null && idx >= -2) {
            dis = new District(idx);
            DISTRICTS.put(idx, (District)ResManager.load(dis));
        }
        return dis;
    }

    public static Municipality getMunicipality(int idx, boolean load) {
        if (!load) {
            return MUNICIPALITIES.get(idx);
        }
        Municipality mun = MUNICIPALITIES.get(idx);
        if (mun == null) {
            mun = new Municipality(idx);
            MUNICIPALITIES.put(idx, (Municipality)ResManager.load(mun));
        }
        return mun;
    }

    public static County getCounty(int idx, boolean load) {
        if (!load) {
            return COUNTIES.get(idx);
        }
        County cty = COUNTIES.get(idx);
        if (cty == null) {
            cty = new County(idx);
            COUNTIES.put(idx, (County)ResManager.load(cty));
        }
        return cty;
    }

    public static Region getRegion(int idx, boolean load) {
        if (!load) {
            return REGIONS.get(idx);
        }
        Region stt = REGIONS.get(idx);
        if (stt == null) {
            stt = new Region(idx);
            REGIONS.put(idx, (Region)ResManager.load(stt));
        }
        return stt;
    }

    public static LDPlayer getPlayer(UUID uuid, boolean load) {
        if (!load) {
            return PLAYERS.get(uuid);
        }
        LDPlayer ply = PLAYERS.get(uuid);
        if (ply == null) {
            ply = new LDPlayer(uuid);
            PLAYERS.put(uuid, (LDPlayer)ResManager.load(ply));
        }
        return ply;
    }

    public static LDPlayer getPlayer(UniEntity player) {
        return player == null ? null : PLAYERS.get(player.entity.getUUID());
    }

    public static LDPlayer getPlayer(EntityW entity) {
        return PLAYERS.get(entity.getUUID());
    }

    public static LDPlayer getPlayer(Object player) {
        return ResManager.getPlayer(UniEntity.get((Object)player));
    }

    public static void unloadIfOffline(LDPlayer player) {
        if (!WrapperHolder.getOnlinePlayerIDs().contains(player.uuid)) {
            player.save();
            PLAYERS.remove(player.uuid);
        }
    }

    public static LDPlayer getPlayer(String string, boolean load) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(string);
        }
        catch (Exception e) {
            if (EnvInfo.DEV) {
                e.printStackTrace();
            }
            uuid = WrapperHolder.getUUIDFor((String)string);
        }
        return uuid == null ? null : ResManager.getPlayer(uuid, load);
    }

    public static <S> S load(Saveable save) {
        if (!LDN.DB.exists(save.saveTable(), save.saveId())) {
            save.gendef();
            return (S)save;
        }
        JsonMap map = (JsonMap)LDN.DB.load(save.saveTable(), save.saveId());
        if (map != null) {
            save.load(map);
        } else {
            save.gendef();
        }
        return (S)save;
    }

    public static Pair<Integer, Double> disToNearestMun(ChunkKey key, int except) {
        double nr = 2.147483647E9;
        int id = -1;
        for (Map.Entry<Integer, ChunkKey> entry : MUN_CENTERS.entrySet()) {
            int z;
            int x;
            double ds;
            if (except == entry.getKey() || !((ds = Math.sqrt((x = Math.abs(entry.getValue().x - key.x)) * x + (z = Math.abs(entry.getValue().z - key.z)) * z)) < nr)) continue;
            nr = ds;
            id = entry.getKey();
        }
        return Pair.of((Object)id, (Object)nr);
    }

    public static String getDistrictName(int id) {
        return ResManager.getDistrict(id).name();
    }

    public static String getMunicipalityName(int id) {
        return ResManager.getMunicipality(id, true).name();
    }

    public static String getCountyName(int id) {
        return ResManager.getCounty(id, true).name();
    }

    public static String getRegionName(int id) {
        return ResManager.getRegion(id, true).name();
    }

    public void load() {
        JsonMap map;
        SERVER_ACCOUNT = DataManager.getAccount((String)"server:landdev", (boolean)false, (boolean)false);
        if (SERVER_ACCOUNT == null) {
            SERVER_ACCOUNT = DataManager.getAccount((String)"server:landdev", (boolean)false, (boolean)true);
            SERVER_ACCOUNT.setBalance(1000000000000L);
            SERVER_ACCOUNT.setName("LandDeveloper Server Account");
        }
        if ((map = (JsonMap)LDN.DB.load(this.saveTable(), this.saveId())) != null) {
            this.load(map);
        }
        SAVER.schedule(new TimerTask(){

            @Override
            public void run() {
                ResManager.saveAll(false);
            }
        }, 300000L, 300000L);
        this.LOADED = true;
    }

    public static void saveAll(boolean unload) {
        if (unload) {
            ChunkRegion.saveAll();
        }
        DISTRICTS.values().forEach(save -> LDN.DB.save((Saveable)save));
        MUNICIPALITIES.values().forEach(save -> LDN.DB.save((Saveable)save));
        COUNTIES.values().forEach(save -> LDN.DB.save((Saveable)save));
        REGIONS.values().forEach(save -> LDN.DB.save((Saveable)save));
        PLAYERS.values().forEach(save -> LDN.DB.save((Saveable)save));
        INSTANCE.save();
        ResManager.INSTANCE.LOADED = false;
    }

    public static void clear() {
        ChunkRegion.REGIONS.clear();
        DISTRICTS.clear();
        MUNICIPALITIES.clear();
        COUNTIES.clear();
        REGIONS.clear();
        PLAYERS.clear();
        MUN_CENTERS.clear();
        CT_CENTERS.clear();
        RG_CENTERS.clear();
        TaxSystem.stop();
    }

    public static String getPlayerName(UUID uuid) {
        return WrapperHolder.getNameFor((UUID)uuid);
    }

    @Override
    public void save(JsonMap map) {
        JsonMap mc = new JsonMap();
        MUN_CENTERS.forEach((key, val) -> mc.add("" + key, val.toString()));
        map.add("municipality-centers", (JsonValue)mc);
        JsonMap cc = new JsonMap();
        CT_CENTERS.forEach((key, val) -> cc.add("" + key, val.toString()));
        map.add("county-centers", (JsonValue)cc);
        JsonMap sc = new JsonMap();
        RG_CENTERS.forEach((key, val) -> sc.add("" + key, val.toString()));
        map.add("region-centers", (JsonValue)sc);
    }

    @Override
    public void load(JsonMap map) {
        if (map.has("municipality-centers")) {
            ((Map)map.get((String)"municipality-centers").asMap().value).forEach((key, val) -> {
                try {
                    MUN_CENTERS.put(Integer.parseInt(key), new ChunkKey(val.string_value()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (map.has("county-centers")) {
            ((Map)map.get((String)"county-centers").asMap().value).forEach((key, val) -> {
                try {
                    CT_CENTERS.put(Integer.parseInt(key), new ChunkKey(val.string_value()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (map.has("region-centers")) {
            ((Map)map.get((String)"region-centers").asMap().value).forEach((key, val) -> {
                try {
                    RG_CENTERS.put(Integer.parseInt(key), new ChunkKey(val.string_value()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public String saveId() {
        return "resources";
    }

    @Override
    public String saveTable() {
        return "general";
    }

    public static int getNewIdFor(String table) {
        return LDN.DB.getNewEntryId(table);
    }

    public static void bulkSave(Saveable ... saveables) {
        for (Saveable save : saveables) {
            save.save();
        }
    }
}

