/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util.broad;

import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.broad.BroadcastChannel;
import net.fexcraft.mod.landdev.util.broad.InternalTransmitter;
import net.fexcraft.mod.landdev.util.broad.LogTransmitter;

public class Broadcaster {
    public static ConcurrentHashMap<TransmitterType, Transmitter> SENDERS = new ConcurrentHashMap();

    public static void send(LDPlayer player, String message) {
        Broadcaster.send(TargetTransmitter.ALL, BroadcastChannel.CHAT.name, player.name(), message, player.adm ? LDConfig.CHAT_ADMIN_COLOR : LDConfig.CHAT_PLAYER_COLOR);
    }

    public static void send(TargetTransmitter target, BroadcastChannel channel, String sender, String message, Object ... args) {
        Broadcaster.send(target, channel.name, sender, message, args);
    }

    public static void send(TargetTransmitter target, String channel, String sender, String message, Object ... args) {
        Transmitter trs = null;
        for (TransmitterType type : target.types) {
            trs = SENDERS.get((Object)type);
            if (trs == null) continue;
            trs.transmit(channel, sender, message, args);
        }
    }

    static {
        SENDERS.put(TransmitterType.INTERNAL, new InternalTransmitter());
        SENDERS.put(TransmitterType.LOG, new LogTransmitter());
    }

    public static enum TargetTransmitter {
        ALL(TransmitterType.values()),
        NO_INTERNAL(TransmitterType.DISCORD),
        NO_DISCORD(TransmitterType.INTERNAL),
        INTERNAL_ONLY(TransmitterType.INTERNAL),
        LOG_ONLY(TransmitterType.LOG);

        private TransmitterType[] types;

        private TargetTransmitter(TransmitterType ... types) {
            this.types = types;
        }
    }

    public static enum TransmitterType {
        INTERNAL,
        DISCORD,
        LOG;


        public boolean is(TransmitterType other) {
            return this == other;
        }

        public boolean internal() {
            return this == INTERNAL || this == LOG;
        }
    }

    public static interface Transmitter {
        public void transmit(String var1, String var2, String var3, Object[] var4);

        default public boolean internal() {
            return false;
        }

        public TransmitterType type();
    }
}

