/*
 * Decompiled with CFR 0.152.
 */
package dev.g_ab.neovelocity;

import dev.g_ab.neovelocity.NeoVelocity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoVelocityConfig {
    public static final Common COMMON;
    static final ModConfigSpec commonSpec;

    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        NeoVelocity.getLogger().debug("Detected new secret!");
    }

    public static void register(IEventBus bus, ModContainer mod) {
        bus.addListener(NeoVelocityConfig::onFileChange);
        mod.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public ModConfigSpec.ConfigValue<String> SECRET;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Configure the NeoVelocity Server mod");
            this.SECRET = builder.comment("The Forwarding secret of your velocity proxy").define("forwarding-secret", (Object)"secret!");
        }
    }
}

