/*
 * Decompiled with CFR 0.152.
 */
package dev.g_ab.neovelocity;

import dev.g_ab.neovelocity.NeoVelocity;
import dev.g_ab.neovelocity.VelocityProxy;
import dev.g_ab.neovelocity.mixin.ConnectionAccessor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.Validate;

public class VelocityLoginPacketListerImpl
extends ServerLoginPacketListenerImpl {
    private static final Component DISCONNECT_UNEXPECTED_QUERY = Component.translatable((String)"multiplayer.disconnect.unexpected_query_response");
    private int velocityLoginMessageId = -1;

    public VelocityLoginPacketListerImpl(MinecraftServer server, Connection connection, boolean transferred) {
        super(server, connection, transferred);
    }

    public void handleHello(ServerboundHelloPacket pPacket) {
        Validate.validState((this.state == ServerLoginPacketListenerImpl.State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)StringUtil.isValidPlayerName((String)pPacket.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
        ClientboundCustomQueryPacket packet = new ClientboundCustomQueryPacket(this.velocityLoginMessageId, (CustomQueryPayload)new VelocityProxy.VersionPayload(1));
        this.connection.send((Packet)packet);
    }

    public void handleCustomQueryPacket(ServerboundCustomQueryAnswerPacket packet) {
        if (packet.transactionId() != this.velocityLoginMessageId || this.velocityLoginMessageId == -1) {
            this.disconnect(DISCONNECT_UNEXPECTED_QUERY);
            return;
        }
        try {
            VelocityProxy.QueryAnswerPayload payload = (VelocityProxy.QueryAnswerPayload)packet.payload();
            if (payload == null) {
                this.disconnect((Component)Component.literal((String)"This server requires you to connect with Velocity."));
                NeoVelocity.getLogger().warn("Someone/{} tried to login without proxy details!!!! Ports are exposed, they shouldn't be!!!!!!!", (Object)this.connection.getRemoteAddress());
                return;
            }
            FriendlyByteBuf buf = payload.buffer();
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect((Component)Component.literal((String)"Unable to verify player details."));
                NeoVelocity.getLogger().warn("Someone/{} is trying to login with invalid secrets! Make sure ports are not exposed or that your secrets are corrects on both sides!", (Object)this.connection.getRemoteAddress());
                return;
            }
            int version = buf.readVarInt();
            if (version > 1) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 1");
            }
            SocketAddress listening = this.connection.getRemoteAddress();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            InetSocketAddress address = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            ((ConnectionAccessor)this.connection).neovelocity$setAddress(address);
            this.startClientVerification(VelocityProxy.createProfile(buf));
            NeoVelocity.getLogger().info("Player {}({}) authenticated through Velocity proxy", (Object)this.authenticatedProfile.getName(), (Object)this.authenticatedProfile.getId());
        }
        catch (ClassCastException exception) {
            this.disconnect((Component)Component.literal((String)"Velocity Forwarding error pls report to sever admins"));
            NeoVelocity.LOGGER.error("Error from casting packet", (Throwable)exception);
        }
    }
}

