/*
 * Decompiled with CFR 0.152.
 */
package dev.g_ab.neovelocity.mixin;

import dev.g_ab.neovelocity.VelocityLoginPacketListerImpl;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerHandshakePacketListenerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerHandshakePacketListenerImpl.class})
public class ServerHandshakePacketListenerImplMixin {
    @Shadow
    @Final
    private Connection connection;
    @Shadow
    @Final
    private MinecraftServer server;

    @Inject(method={"handleIntention"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleIntention(ClientIntentionPacket packet, CallbackInfo ci) {
        if (packet.intention() == ClientIntent.LOGIN) {
            this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
            if (packet.protocolVersion() != SharedConstants.getCurrentVersion().getProtocolVersion()) {
                MutableComponent component = packet.protocolVersion() < 754 ? Component.translatable((String)"multiplayer.disconnect.outdated_client", (Object[])new Object[]{SharedConstants.getCurrentVersion().getName()}) : Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{SharedConstants.getCurrentVersion().getName()});
                this.connection.send((Packet)new ClientboundLoginDisconnectPacket((Component)component));
                this.connection.disconnect((Component)component);
            } else {
                this.connection.setupInboundProtocol(LoginProtocols.SERVERBOUND, (PacketListener)new VelocityLoginPacketListerImpl(this.server, this.connection, false));
            }
        } else if (packet.intention() == ClientIntent.TRANSFER) {
            MutableComponent component = Component.literal((String)"NUH-uh");
            this.connection.send((Packet)new ClientboundLoginDisconnectPacket((Component)component));
            this.connection.disconnect((Component)component);
        }
        ci.cancel();
    }
}

