/*
 * Decompiled with CFR 0.152.
 */
package com.dosse.upnp;

import com.dosse.upnp.Gateway;
import com.dosse.upnp.GatewayFinder;

public class UPnP {
    private static Gateway defaultGW = null;
    private static final GatewayFinder finder = new GatewayFinder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gatewayFound(Gateway g) {
            GatewayFinder gatewayFinder = finder;
            synchronized (gatewayFinder) {
                if (defaultGW == null) {
                    defaultGW = g;
                }
            }
        }
    };

    public static void waitInit() {
        while (finder.isSearching()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isUPnPAvailable() {
        UPnP.waitInit();
        return defaultGW != null;
    }

    public static boolean openPortTCP(int port) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.openPort(port, false);
    }

    public static boolean openPortUDP(int port) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.openPort(port, true);
    }

    public static boolean closePortTCP(int port) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.closePort(port, false);
    }

    public static boolean closePortUDP(int port) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.closePort(port, true);
    }

    public static boolean isMappedTCP(int port) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.isMapped(port, false);
    }

    public static boolean isMappedUDP(int port) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.isMapped(port, true);
    }

    public static String getExternalIP() {
        if (!UPnP.isUPnPAvailable()) {
            return null;
        }
        return defaultGW.getExternalIP();
    }

    public static String getLocalIP() {
        if (!UPnP.isUPnPAvailable()) {
            return null;
        }
        return defaultGW.getLocalIP();
    }

    public static String getDefaultGatewayIP() {
        if (!UPnP.isUPnPAvailable()) {
            return null;
        }
        return defaultGW.getGatewayIP();
    }
}

