/*
 * Decompiled with CFR 0.152.
 */
package xyz.bobkinn.opentopublic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.bobkinn.opentopublic.Config;
import xyz.bobkinn.opentopublic.OpenMode;
import xyz.bobkinn.opentopublic.PortContainer;
import xyz.bobkinn.opentopublic.upnp.UpnpThread;

public abstract class OpenToPublic {
    public static final String MOD_ID = "opentopublic";
    public static final Logger LOGGER = LogManager.getLogger((String)"OpenToPublic");
    public static OpenMode selectedMode = OpenMode.LAN;
    public static OpenMode openedMode = null;
    public static Path modConfigPath = null;
    public static File backupFile = null;
    public static boolean lanOpening = false;
    public static int customPort = 25565;
    public static String upnpIp = null;
    public static boolean serverStopped = false;
    public static Config cfg = null;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Config.class, type -> new Config()).create();

    public OpenToPublic() {
        modConfigPath = this.getConfigsFolder().resolve(MOD_ID);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (serverStopped && upnpIp != null && !PortContainer.INSTANCE.isEmpty()) {
                LOGGER.info("Closing ports at shutdown..");
                UpnpThread.runClose();
            }
        }));
    }

    public static void saveConfig(Path to) {
        boolean created;
        Config cfg = OpenToPublic.cfg;
        if (cfg == null) {
            return;
        }
        File folder = to.getParent().toFile();
        if (!folder.exists() && !(created = folder.mkdirs())) {
            LOGGER.error("Failed to create config folder");
            return;
        }
        File file = to.toFile();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(GSON.toJson((Object)cfg, Config.class));
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public static void updateConfig(Path path) {
        boolean created;
        File folder = path.getParent().toFile();
        if (!folder.exists() && !(created = folder.mkdirs())) {
            LOGGER.error("Failed to create config folder");
            return;
        }
        File file = path.toFile();
        if (!file.exists()) {
            try {
                boolean created2 = file.createNewFile();
                if (!created2) {
                    LOGGER.error("Failed to create config file");
                    return;
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write(GSON.toJson((Object)new Config(), Config.class));
                bw.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to write config file", (Throwable)e);
            }
            return;
        }
        try {
            FileReader fr = new FileReader(file);
            Config cfg = (Config)GSON.fromJson((Reader)fr, Config.class);
            cfg.getTcp().forEach(p -> PortContainer.INSTANCE.addTCP((int)p));
            cfg.getUdp().forEach(p -> PortContainer.INSTANCE.addUDP((int)p));
            OpenToPublic.cfg = cfg;
            FileWriter fw = new FileWriter(file);
            GSON.toJson((Object)OpenToPublic.cfg, Config.class, (Appendable)fw);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to update config.json", (Throwable)e);
        }
    }

    public abstract Path getConfigsFolder();
}

