/*
 * Decompiled with CFR 0.152.
 */
package xyz.bobkinn.opentopublic;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import xyz.bobkinn.opentopublic.OpenToPublic;

public class PortContainer
implements Serializable {
    private static final long serialVersionUID = 42L;
    public static PortContainer INSTANCE;
    public final Map<String, ArrayList<Integer>> upnpPorts;
    public Integer mainPort;
    public boolean fileExists;

    public PortContainer(Map<String, ArrayList<Integer>> upnpPorts, Integer mainPort) {
        if (INSTANCE != null) {
            throw new RuntimeException("Container filled");
        }
        this.upnpPorts = upnpPorts;
        this.mainPort = mainPort;
    }

    public static PortContainer newEmpty() {
        HashMap<String, ArrayList<Integer>> addiPorts = new HashMap<String, ArrayList<Integer>>();
        addiPorts.put("tcp", new ArrayList());
        addiPorts.put("udp", new ArrayList());
        return new PortContainer(addiPorts, null);
    }

    public static void saveBackup(PortContainer container, File file) {
        if (container.isEmpty()) {
            return;
        }
        try {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Failed to create folders for " + String.valueOf(file));
            }
            ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            oos.writeObject(container);
            oos.close();
            PortContainer.INSTANCE.fileExists = true;
        }
        catch (IOException e) {
            OpenToPublic.LOGGER.error("Failed to save container backup", (Throwable)e);
        }
    }

    public static PortContainer loadBackup(File file) {
        PortContainer res;
        if (!file.exists()) {
            return null;
        }
        try {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Failed to create folders for " + String.valueOf(file));
            }
            ObjectInputStream oos = new ObjectInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
            res = (PortContainer)oos.readObject();
            oos.close();
            res.fileExists = true;
        }
        catch (IOException | ClassNotFoundException e) {
            OpenToPublic.LOGGER.error("Failed to load container backup", (Throwable)e);
            return null;
        }
        if (res.isEmpty()) {
            try {
                if (!file.delete()) {
                    throw new IOException("Failed to delete empty file " + String.valueOf(file));
                }
                res.fileExists = false;
            }
            catch (Exception e) {
                OpenToPublic.LOGGER.error("Failed to delete empty file", (Throwable)e);
            }
        }
        return res;
    }

    public boolean isEmpty() {
        return this.upnpPorts.get("tcp").isEmpty() && this.upnpPorts.get("udp").isEmpty() && this.mainPort == null;
    }

    public String toString() {
        return "PortContainer{upnpPorts=" + String.valueOf(this.upnpPorts) + ", mainPort=" + this.mainPort + "}";
    }

    public ArrayList<Integer> getTcpPorts() {
        return this.upnpPorts.get("tcp");
    }

    public ArrayList<Integer> getUdpPorts() {
        return this.upnpPorts.get("udp");
    }

    public void addTCP(int port) {
        if (this.mainPort != null && port == this.mainPort) {
            return;
        }
        ArrayList<Integer> ports = this.upnpPorts.get("tcp");
        if (ports.contains(port)) {
            return;
        }
        ports.add(port);
        this.upnpPorts.put("tcp", ports);
    }

    public void addUDP(int port) {
        ArrayList<Integer> ports = this.upnpPorts.get("udp");
        if (ports.contains(port)) {
            return;
        }
        ports.add(port);
        this.upnpPorts.put("udp", ports);
    }
}

