/*
 * Decompiled with CFR 0.152.
 */
package xyz.bobkinn.opentopublic.upnp;

import com.dosse.upnp.UPnP;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import xyz.bobkinn.opentopublic.OpenToPublic;
import xyz.bobkinn.opentopublic.PortContainer;
import xyz.bobkinn.opentopublic.Util;
import xyz.bobkinn.opentopublic.upnp.UpnpEnum;
import xyz.bobkinn.opentopublic.upnp.UpnpEx;

public class UpnpThread
extends Thread {
    public final boolean doSetup;

    public UpnpThread(boolean doSetup) {
        super("UpnpWorksThread");
        this.doSetup = doSetup;
        this.setUncaughtExceptionHandler(new Handler());
    }

    public static void runSetup() {
        UpnpThread t = new UpnpThread(true);
        t.setName("UpnpSetupThread");
        t.start();
    }

    public static void runClose() {
        UpnpThread t = new UpnpThread(false);
        t.setName("UpnpCloseThread");
        t.start();
    }

    @Override
    public void run() {
        if (this.doSetup) {
            this.setup();
        } else {
            this.doClose();
        }
    }

    public void doClose() {
        try {
            boolean available = UPnP.isUPnPAvailable();
            if (!available) {
                throw new RuntimeException("Failed isUPnPAvailable()");
            }
        }
        catch (Exception e) {
            throw new UpnpEx(UpnpEnum.CHECK_AVAILABLE, e);
        }
        OpenToPublic.LOGGER.info("Closing main port {}", (Object)OpenToPublic.customPort);
        try {
            if (!UPnP.closePortTCP(OpenToPublic.customPort)) {
                throw new RuntimeException();
            }
            PortContainer.INSTANCE.mainPort = null;
        }
        catch (Exception e) {
            OpenToPublic.LOGGER.error("Failed close of main port {}", (Object)OpenToPublic.customPort, (Object)e);
        }
        ArrayList<Integer> closedTcp = new ArrayList<Integer>();
        for (int port : PortContainer.INSTANCE.getTcpPorts()) {
            try {
                if (!UPnP.closePortTCP(port)) {
                    throw new RuntimeException();
                }
                closedTcp.add(port);
            }
            catch (Exception e) {
                OpenToPublic.LOGGER.error("Failed close additional port {} [TCP]. Maybe it already closed?", (Object)port);
            }
        }
        if (!closedTcp.isEmpty()) {
            OpenToPublic.LOGGER.info("Closed TCP ports: {}", closedTcp);
        }
        PortContainer.INSTANCE.upnpPorts.get("tcp").clear();
        ArrayList<Integer> closedUdp = new ArrayList<Integer>();
        for (int port : PortContainer.INSTANCE.getUdpPorts()) {
            try {
                if (!UPnP.closePortUDP(port)) {
                    throw new RuntimeException();
                }
                closedUdp.add(port);
            }
            catch (Exception e) {
                OpenToPublic.LOGGER.error("Failed close additional port {} [UDP]. Maybe it already closed?", (Object)port);
            }
        }
        if (!closedUdp.isEmpty()) {
            OpenToPublic.LOGGER.info("Closed UDP ports: {}", closedUdp);
        }
        PortContainer.INSTANCE.upnpPorts.get("udp").clear();
        if (!OpenToPublic.backupFile.delete()) {
            OpenToPublic.LOGGER.error("Failed to delete container file");
        }
    }

    public void setup() {
        try {
            boolean available = UPnP.isUPnPAvailable();
            if (!available) {
                throw new RuntimeException("not available");
            }
        }
        catch (Exception e) {
            Util.addChatMsg((Component)Component.m_237115_((String)"opentopublic.message.upnp_not_available").m_130940_(ChatFormatting.RED));
            throw new UpnpEx(UpnpEnum.CHECK_AVAILABLE, e);
        }
        try {
            boolean success = UPnP.openPortTCP(OpenToPublic.customPort);
            if (!success) {
                throw new RuntimeException("Unknown error");
            }
        }
        catch (Exception e) {
            OpenToPublic.LOGGER.error("Failed to open main port: ", (Throwable)e);
            throw new UpnpEx(UpnpEnum.OPEN_PORT, e);
        }
        try {
            OpenToPublic.upnpIp = UPnP.getExternalIP();
            if (OpenToPublic.upnpIp == null) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            throw new UpnpEx(UpnpEnum.FAIL_GET_IP, e);
        }
        Util.atSuccessOpen(true);
        for (int port : PortContainer.INSTANCE.getTcpPorts()) {
            try {
                if (UPnP.openPortTCP(port)) continue;
                throw new RuntimeException();
            }
            catch (Exception e) {
                Util.addChatMsg((Component)Component.m_237110_((String)"opentopublic.message.additional_open_fail", (Object[])new Object[]{port + " [TCP]"}).m_130940_(ChatFormatting.RED));
            }
        }
        for (int port : PortContainer.INSTANCE.getUdpPorts()) {
            try {
                if (UPnP.openPortUDP(port)) continue;
                throw new RuntimeException();
            }
            catch (Exception e) {
                Util.addChatMsg((Component)Component.m_237110_((String)"opentopublic.message.additional_open_fail", (Object[])new Object[]{port + " [UDP]"}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static class Handler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof UpnpEx)) {
                OpenToPublic.LOGGER.error("Exception in UpnpWorksThread: ", e);
                return;
            }
            UpnpEx err = (UpnpEx)e;
            if (err.getType() == UpnpEnum.CHECK_AVAILABLE) {
                Util.addChatMsg((Component)Component.m_237115_((String)"opentopublic.message.upnp_not_available").m_130940_(ChatFormatting.RED));
                OpenToPublic.LOGGER.error((Object)err.getEx());
            } else if (err.getType() == UpnpEnum.FAIL_GET_IP) {
                OpenToPublic.LOGGER.error("Failed to get ip:", e);
                Util.addChatMsg((Component)Component.m_237115_((String)"opentopublic.publish.failed_wan").m_130940_(ChatFormatting.RED));
            } else if (err.getType() == UpnpEnum.OPEN_PORT) {
                Util.addChatMsg((Component)Component.m_237115_((String)"opentopublic.publish.failed_wan").m_130940_(ChatFormatting.RED));
            }
        }
    }
}

