/*
 * Decompiled with CFR 0.152.
 */
package com.dosse.upnp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

class Gateway {
    private final Inet4Address iface;
    private final InetAddress routerip;
    private String serviceType = null;
    private String controlURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gateway(byte[] data, Inet4Address ip, InetAddress gatewayip) throws Exception {
        this.iface = ip;
        this.routerip = gatewayip;
        String location = null;
        StringTokenizer st = new StringTokenizer(new String(data, StandardCharsets.UTF_8), "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.isEmpty() || s.startsWith("HTTP/1.") || s.startsWith("NOTIFY *")) continue;
            String name = s.substring(0, s.indexOf(58));
            String val = s.substring(name.length() + 1).trim();
            if (!name.equalsIgnoreCase("location")) continue;
            location = val;
        }
        if (location == null) {
            throw new Exception("Unsupported Gateway");
        }
        byte[] xmlBytes = null;
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = new BufferedInputStream(new URI(location).toURL().openConnection().getInputStream());
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            xmlBytes = outputStream.toByteArray();
        }
        catch (IOException buffer) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException buffer) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException buffer) {}
        }
        if (xmlBytes == null) {
            throw new Exception("Unable to retrieve XML file " + location);
        }
        String xmlString = new String(xmlBytes).replaceAll("\u0000", "");
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
        NodeList services = d.getElementsByTagName("service");
        for (int i = 0; i < services.getLength(); ++i) {
            Node service = services.item(i);
            NodeList n = service.getChildNodes();
            String serviceType = null;
            String controlURL = null;
            for (int j = 0; j < n.getLength(); ++j) {
                Node x = n.item(j);
                if (x.getNodeName().trim().equalsIgnoreCase("serviceType")) {
                    serviceType = x.getFirstChild().getNodeValue();
                    continue;
                }
                if (!x.getNodeName().trim().equalsIgnoreCase("controlURL")) continue;
                controlURL = x.getFirstChild().getNodeValue();
            }
            if (serviceType == null || controlURL == null || !serviceType.trim().toLowerCase().contains(":wanipconnection:") && !serviceType.trim().toLowerCase().contains(":wanpppconnection:")) continue;
            this.serviceType = serviceType.trim();
            this.controlURL = controlURL.trim();
        }
        if (this.controlURL == null) {
            throw new Exception("Unsupported Gateway");
        }
        int slash = location.indexOf("/", 7);
        if (slash == -1) {
            throw new Exception("Unsupported Gateway");
        }
        location = location.substring(0, slash);
        if (!this.controlURL.startsWith("/")) {
            this.controlURL = "/" + this.controlURL;
        }
        this.controlURL = location + this.controlURL;
    }

    private Map<String, String> command(String action, Map<String, String> params) throws Exception {
        Node n;
        HashMap<String, String> ret = new HashMap<String, String>();
        byte[] req = this.getReq(action, params);
        HttpURLConnection conn = (HttpURLConnection)new URI(this.controlURL).toURL().openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("SOAPAction", "\"" + this.serviceType + "#" + action + "\"");
        conn.setRequestProperty("Connection", "Close");
        conn.setRequestProperty("Content-Length", "" + req.length);
        conn.getOutputStream().write(req);
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(conn.getInputStream());
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d.getDocumentElement(), 1, null, true);
        while ((n = iter.nextNode()) != null) {
            try {
                if (n.getFirstChild().getNodeType() != 3) continue;
                ret.put(n.getNodeName(), n.getTextContent());
            }
            catch (Throwable throwable) {}
        }
        conn.disconnect();
        return ret;
    }

    private byte[] getReq(String action, Map<String, String> params) {
        StringBuilder soap = new StringBuilder("<?xml version=\"1.0\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><m:" + action + " xmlns:m=\"" + this.serviceType + "\">");
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                soap.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
            }
        }
        soap.append("</m:").append(action).append("></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        return soap.toString().getBytes(StandardCharsets.UTF_8);
    }

    public String getGatewayIP() {
        return this.routerip.getHostAddress();
    }

    public String getLocalIP() {
        return this.iface.getHostAddress();
    }

    public String getExternalIP() {
        try {
            Map<String, String> r = this.command("GetExternalIPAddress", null);
            return r.get("NewExternalIPAddress");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean openPort(int port, String remoteHost, boolean udp, String appName) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", remoteHost == null ? "" : remoteHost);
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewInternalClient", this.iface.getHostAddress());
        params.put("NewExternalPort", "" + port);
        params.put("NewInternalPort", "" + port);
        params.put("NewEnabled", "1");
        params.put("NewPortMappingDescription", appName);
        params.put("NewLeaseDuration", "0");
        try {
            Map<String, String> r = this.command("AddPortMapping", params);
            return r.get("errorCode") == null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean closePort(int port, String remoteHost, boolean udp) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", remoteHost == null ? "" : remoteHost);
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewExternalPort", "" + port);
        try {
            this.command("DeletePortMapping", params);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isMapped(int port, String remoteHost, boolean udp) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", remoteHost == null ? "" : remoteHost);
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewExternalPort", "" + port);
        try {
            Map<String, String> r = this.command("GetSpecificPortMappingEntry", params);
            if (r.get("errorCode") != null) {
                throw new Exception();
            }
            return r.get("NewInternalPort") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

