/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.mojang.brigadier.CommandDispatcher;
import io.github.satxm.mcwifipnp.MCWiFiPnP;
import io.github.satxm.mcwifipnp.UUIDFixer;
import io.github.satxm.mcwifipnp.commands.IpCommand;
import io.github.satxm.mcwifipnp.commands.OnlineModeCommand;
import io.github.satxm.mcwifipnp.commands.UPnPCommand;
import io.github.satxm.mcwifipnp.commands.UUIDFixerCommand;
import io.github.satxm.mcwifipnp.network.UPnPModule;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.BanIpCommands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.DeOpCommands;
import net.minecraft.server.commands.OpCommand;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.PardonIpCommand;
import net.minecraft.server.commands.WhitelistCommand;
import net.minecraft.server.players.OldUsersConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCWiFiPnPUnit {
    public static final String MODID = "mcwifipnp";
    public static final Logger LOGGER = LogManager.getLogger(MCWiFiPnP.class);

    public static void registerCommands(CommandDispatcher<CommandSourceStack> cmdDispatcher, boolean isDedicatedServer) {
        UUIDFixerCommand.register(cmdDispatcher);
        IpCommand.register(cmdDispatcher);
        if (isDedicatedServer) {
            MCWiFiPnPUnit.enableUUIDFixerOnDedicatedServer();
            return;
        }
        OnlineModeCommand.register(cmdDispatcher);
        UPnPCommand.register(cmdDispatcher);
        DeOpCommands.register(cmdDispatcher);
        OpCommand.register(cmdDispatcher);
        WhitelistCommand.register(cmdDispatcher);
        BanIpCommands.register(cmdDispatcher);
        BanListCommands.register(cmdDispatcher);
        BanPlayerCommands.register(cmdDispatcher);
        PardonCommand.register(cmdDispatcher);
        PardonIpCommand.register(cmdDispatcher);
    }

    public static void onServerStops(MinecraftServer server) {
        UPnPModule.stop(server);
    }

    public static void enableUUIDFixerOnDedicatedServer() {
        UUIDFixer.enabled = true;
        LOGGER.info("UUID Fixer has been enabled on the dedicated server.To disable, delete mod McWifiPnP. Config file is \"uuid_fixer.json\".");
    }

    public static boolean convertOldUsers(MinecraftServer server) {
        int i;
        boolean bl = false;
        for (i = 0; !bl && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl = OldUsersConverter.convertUserBanlist((MinecraftServer)server);
        }
        boolean bl2 = false;
        for (i = 0; !bl2 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl2 = OldUsersConverter.convertIpBanlist((MinecraftServer)server);
        }
        boolean bl3 = false;
        for (i = 0; !bl3 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl3 = OldUsersConverter.convertOpsList((MinecraftServer)server);
        }
        boolean bl4 = false;
        for (i = 0; !bl4 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl4 = OldUsersConverter.convertWhiteList((MinecraftServer)server);
        }
        return bl || bl2 || bl3 || bl4;
    }

    private static void waitForRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

