/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import net.minecraft.network.chat.Component;

public enum OnlineMode {
    ONLINE(true, false, "online"),
    OFFLINE(false, false, "offline"),
    FIX_UUID(false, true, "fixuuid");

    public final boolean onlineMode;
    public final boolean fixUUID;
    private final Component displayName;
    private final Component toolTip;

    private OnlineMode(boolean onlineModeEnabled, boolean tryOnlineUUIDFirst, String name) {
        this.onlineMode = onlineModeEnabled;
        this.fixUUID = tryOnlineUUIDFirst;
        this.displayName = Component.translatable((String)("mcwifipnp.gui.OnlineMode." + name));
        this.toolTip = Component.translatable((String)("mcwifipnp.gui.OnlineMode." + name + ".info"));
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Component gettoolTip() {
        return this.toolTip;
    }

    public static OnlineMode of(boolean onlineModeEnabled, boolean tryOnlineUUIDFirst) {
        if (onlineModeEnabled) {
            return ONLINE;
        }
        return tryOnlineUUIDFirst ? FIX_UUID : OFFLINE;
    }
}

