/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UUIDFixer {
    private static final Logger LOGGER = LogManager.getLogger(UUIDFixer.class);
    public static boolean enabled = false;

    public static UUID hookEntry(String playerName) {
        if (!enabled) {
            return null;
        }
        return new PolicyHolder().uuidOf(playerName);
    }

    @Nullable
    public static UUID getOfficialUUID(String playerName) {
        String url = "https://api.mojang.com/users/profiles/minecraft/" + playerName;
        try {
            String UUIDJson = IOUtils.toString((URI)URI.create(url), (Charset)Charset.defaultCharset());
            if (!UUIDJson.isEmpty()) {
                JsonObject root = JsonParser.parseString((String)UUIDJson).getAsJsonObject();
                String playerName2 = root.getAsJsonPrimitive("name").getAsString();
                String uuidString = root.getAsJsonPrimitive("id").getAsString();
                long uuidMSB = Long.parseLong(uuidString.substring(0, 8), 16);
                uuidMSB <<= 32;
                long uuidLSB = Long.parseLong(uuidString.substring(16, 24), 16);
                uuidLSB <<= 32;
                UUID uuid = new UUID(uuidMSB |= Long.parseLong(uuidString.substring(8, 16), 16), uuidLSB |= Long.parseLong(uuidString.substring(24, 32), 16));
                if (playerName2.equalsIgnoreCase(playerName)) {
                    return uuid;
                }
            }
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class PolicyHolder {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        private static final String UUID_MAP_FILE = "uuid_fixer.json";
        private static final String POLICY_ONLINE = "online";
        private static final String POLICY_OFFLINE = "offline";
        public final Path location;
        private final JsonObject rootNode;

        public PolicyHolder() {
            this(Path.of(UUID_MAP_FILE, new String[0]));
        }

        public PolicyHolder(Path filePath) {
            this.location = filePath;
            JsonObject rootNode = null;
            try (FileReader reader = new FileReader(filePath.toFile());){
                rootNode = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (IOException e) {
                rootNode = new JsonObject();
            }
            this.rootNode = rootNode;
        }

        public boolean isOnlineByDefault() {
            return !POLICY_OFFLINE.equalsIgnoreCase(this.getOrNull("*"));
        }

        public void setDefaultPolicy(boolean defaultIsOnline) {
            this.set("*", defaultIsOnline ? POLICY_ONLINE : POLICY_OFFLINE);
        }

        public Set<String> getUsers() {
            TreeSet<String> users = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry entry : this.rootNode.entrySet()) {
                String key = (String)entry.getKey();
                if ("*".equals(key)) continue;
                users.add(key);
            }
            return users;
        }

        public static boolean isUUID(String policy) {
            try {
                UUID.fromString(policy);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean isOnlinePolicy(String policy) {
            return POLICY_ONLINE.equalsIgnoreCase(policy);
        }

        public static boolean isOfflinePolicy(String policy) {
            return POLICY_OFFLINE.equalsIgnoreCase(policy);
        }

        public static boolean isValidPolicy(String policy) {
            if (PolicyHolder.isOnlinePolicy(policy)) {
                return true;
            }
            if (PolicyHolder.isOfflinePolicy(policy)) {
                return true;
            }
            return PolicyHolder.isUUID(policy);
        }

        public int count() {
            int count = 0;
            for (Map.Entry entry : this.rootNode.entrySet()) {
                try {
                    String policy = ((JsonElement)entry.getValue()).getAsString();
                    if (!PolicyHolder.isValidPolicy(policy)) continue;
                    ++count;
                }
                catch (Exception exception) {}
            }
            return count;
        }

        public void set(String key, String value) {
            this.remove(key);
            this.rootNode.addProperty(key, value);
        }

        public String getOrNull(String key) {
            for (Map.Entry entry : this.rootNode.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(key)) continue;
                try {
                    return ((JsonElement)entry.getValue()).getAsString();
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        public boolean remove(String playerName) {
            boolean removed = false;
            Iterator iterator = this.rootNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((String)entry.getKey()).equalsIgnoreCase(playerName)) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }

        @Nullable
        public UUID uuidOf(String playerName) {
            String policy = this.getOrNull(playerName);
            if (policy == null) {
                policy = this.isOnlineByDefault() ? POLICY_ONLINE : POLICY_OFFLINE;
            }
            LOGGER.info("Policy of " + playerName + " is: " + policy);
            if (POLICY_OFFLINE.equalsIgnoreCase(policy)) {
                return null;
            }
            try {
                return UUID.fromString(policy);
            }
            catch (IllegalArgumentException e) {
                return UUIDFixer.getOfficialUUID(playerName);
            }
        }

        public void save() {
            try {
                String json = GSON.toJson((JsonElement)this.rootNode);
                Files.write(this.location, json.getBytes("utf-8"), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to write config file!", (Throwable)e);
            }
        }
    }
}

