/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.netty.channel.socket.InternetProtocolFamily;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class EnumArgument<T extends Enum<T>> {
    public static final EnumArgument<InternetProtocolFamily> IP_FAMILY = new EnumArgument<InternetProtocolFamily>(InternetProtocolFamily.class);
    private final Function<T, String> namingFunction;
    private final Map<String, T> mapping = new HashMap<String, T>();

    public EnumArgument(Class<T> enumClass) {
        this(enumClass, t -> t.name().toLowerCase().replace('_', '-'));
    }

    public EnumArgument(Class<T> enumClass, Function<T, String> namingFunction) {
        this.namingFunction = namingFunction;
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            String name = namingFunction.apply(value);
            Enum existing = (Enum)this.mapping.get(name);
            if (existing != null) {
                throw new RuntimeException(String.valueOf(existing) + " and " + String.valueOf(value) + " has the same mapped key: " + name);
            }
            this.mapping.put(name, value);
        }
    }

    public String nameOf(T value) {
        return this.namingFunction.apply(value);
    }

    public T valueOf(String argVal) {
        return (T)((Enum)this.mapping.get(argVal));
    }

    public T valueOf(CommandContext<CommandSourceStack> context, int index) {
        return (T)((Enum)this.mapping.get(EnumArgument.getArgValue(context, index)));
    }

    public LiteralArgumentBuilder<CommandSourceStack> appendTo(LiteralArgumentBuilder<CommandSourceStack> parent, UnaryOperator<LiteralArgumentBuilder<CommandSourceStack>> operation) {
        return EnumArgument.literals(parent, this.mapping.keySet().toArray(new String[0])).apply(operation);
    }

    public static Function<UnaryOperator<LiteralArgumentBuilder<CommandSourceStack>>, LiteralArgumentBuilder<CommandSourceStack>> literals(LiteralArgumentBuilder<CommandSourceStack> parent, String ... values) {
        return operation -> {
            LiteralArgumentBuilder result = parent;
            for (String value : values) {
                result = (LiteralArgumentBuilder)result.then((ArgumentBuilder)operation.apply(Commands.literal((String)value)));
            }
            return result;
        };
    }

    public static String getArgValue(CommandContext<CommandSourceStack> context, int index) {
        List nodes = context.getNodes();
        ParsedCommandNode node = (ParsedCommandNode)nodes.get(nodes.size() - 1 - index);
        CommandNode commandNode = node.getNode();
        if (commandNode instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)commandNode;
            return literal.getLiteral();
        }
        return null;
    }
}

