/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.dosse.upnp.UPnP;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.satxm.mcwifipnp.commands.EnumArgument;
import io.github.satxm.mcwifipnp.network.GlobalIPs;
import io.github.satxm.mcwifipnp.network.UPnPModule;
import io.netty.channel.socket.InternetProtocolFamily;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;

public class IpCommand {
    public static String LOCAL_IP_KEY = "mcwifipnp.gui.localIP";
    public static String GLOBAL_IP_KEY = "mcwifipnp.gui.globalIP";
    public static Component CANNOT_GET_IP = Component.translatable((String)"mcwifipnp.upnp.cantgetip");

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder cmdBuilder = (LiteralArgumentBuilder)Commands.literal((String)"ip").requires(cmdStack -> cmdStack.hasPermission(4));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").then(EnumArgument.IP_FAMILY.appendTo((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"local").executes(IpCommand::showLocalIPsAll)), enumOption -> (LiteralArgumentBuilder)enumOption.executes(IpCommand::showLocalIPs)))).then(EnumArgument.IP_FAMILY.appendTo((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"global").executes(IpCommand::showGlobalIPAll)), enumOption -> (LiteralArgumentBuilder)enumOption.executes(IpCommand::showGlobalIP)))).then(Commands.literal((String)"upnp").executes(IpCommand::showUPnPIP))).executes(IpCommand::showDetail));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.executes(IpCommand::showBrief);
        commandDispatcher.register(cmdBuilder);
    }

    private static int showLocalIPs(CommandContext<CommandSourceStack> context) {
        InternetProtocolFamily family = EnumArgument.IP_FAMILY.valueOf(context, 0);
        return IpCommand.getAndReply(context, components -> IpCommand.getIPComponentLocal(components, family));
    }

    private static void showLocalIPsAllImpl(List<MutableComponent> results) {
        int labelIndex = results.size();
        int count = IpCommand.getIPComponentLocal(results, InternetProtocolFamily.IPv4);
        if ((count += IpCommand.getIPComponentLocal(results, InternetProtocolFamily.IPv6)) > 0) {
            results.add(labelIndex, Component.translatable((String)LOCAL_IP_KEY, (Object[])new Object[]{"IP:"}));
        }
    }

    private static int showLocalIPsAll(CommandContext<CommandSourceStack> context) {
        return IpCommand.getAndReply(context, IpCommand::showLocalIPsAllImpl);
    }

    private static int showGlobalIP(CommandContext<CommandSourceStack> context) {
        InternetProtocolFamily family = EnumArgument.IP_FAMILY.valueOf(context, 0);
        return IpCommand.getAndReply(context, components -> IpCommand.getIPComponentGlobal(components, family));
    }

    private static void showGlobalIPAllImpl(List<MutableComponent> results) {
        int labelIndex = results.size();
        int count = IpCommand.getIPComponentGlobal(results, InternetProtocolFamily.IPv4);
        if ((count += IpCommand.getIPComponentGlobal(results, InternetProtocolFamily.IPv6)) > 0) {
            results.add(labelIndex, Component.translatable((String)GLOBAL_IP_KEY, (Object[])new Object[]{"IP:"}));
        }
    }

    private static int showGlobalIPAll(CommandContext<CommandSourceStack> context) {
        return IpCommand.getAndReply(context, IpCommand::showGlobalIPAllImpl);
    }

    private static int showUPnPIP(CommandContext<CommandSourceStack> context) {
        return IpCommand.getAndReply(context, components -> IpCommand.showUPnPIPAllImpl(components, context));
    }

    private static void showUPnPIPAllImpl(List<MutableComponent> results, CommandContext<CommandSourceStack> context) {
        int labelIndex = results.size();
        if (IpCommand.getIPComponentUPnP(results, context) > 0) {
            results.add(labelIndex, Component.literal((String)"UPnP IPv4:"));
        }
    }

    private static int showDetail(CommandContext<CommandSourceStack> context) {
        return IpCommand.getAndReply(context, components -> {
            IpCommand.showGlobalIPAllImpl(components);
            IpCommand.showLocalIPsAllImpl(components);
            IpCommand.showUPnPIPAllImpl(components, context);
        });
    }

    private static int showBrief(CommandContext<CommandSourceStack> context) {
        Component result = IpCommand.getBrief(((CommandSourceStack)context.getSource()).getServer());
        if (result == CANNOT_GET_IP) {
            ((CommandSourceStack)context.getSource()).sendFailure(result);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> result, false);
        }
        return result == CANNOT_GET_IP ? 0 : 1;
    }

    private static int getAndReply(CommandContext<CommandSourceStack> context, Consumer<List<MutableComponent>> sources) {
        LinkedList components = new LinkedList();
        sources.accept(components);
        if (components.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure(CANNOT_GET_IP);
            return 0;
        }
        components.forEach(component -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false));
        return components.size();
    }

    private static int getIPComponentLocal(List<MutableComponent> results, InternetProtocolFamily family) {
        List<InetAddress> localIPs = IpCommand.getLocalIPs();
        if (localIPs.isEmpty()) {
            return 0;
        }
        for (InetAddress addr : localIPs) {
            if (family != InternetProtocolFamily.of((InetAddress)addr)) continue;
            String addrString = addr.getHostAddress();
            addrString = IpCommand.formatIPString(addrString, family);
            results.add(IpCommand.copyable(addrString));
        }
        return results.size();
    }

    private static int getIPComponentGlobal(List<MutableComponent> results, InternetProtocolFamily family) {
        String ip = GlobalIPs.fetchGlobalIP(family);
        if (ip == null) {
            return 0;
        }
        ip = IpCommand.formatIPString(ip, family);
        results.add(IpCommand.copyable(ip));
        return 1;
    }

    private static int getIPComponentUPnP(List<MutableComponent> results, CommandContext<CommandSourceStack> context) {
        String upnpIP = UPnP.getExternalIP();
        if (!UPnPModule.has(((CommandSourceStack)context.getSource()).getServer()) || upnpIP == null) {
            return 0;
        }
        MutableComponent component = IpCommand.copyable(upnpIP);
        results.add(component);
        return 1;
    }

    public static Component getBrief(MinecraftServer server) {
        String ipv6;
        int port = server.getPort();
        boolean useUPnP = UPnPModule.has(server);
        LinkedList<MutableComponent> IPComponentList = new LinkedList<MutableComponent>();
        ArrayList<String> IPList = new ArrayList<String>();
        List<InetAddress> localIPs = IpCommand.getLocalIPs();
        for (InetAddress addr : localIPs) {
            String addrString = addr.getHostAddress();
            InternetProtocolFamily family = InternetProtocolFamily.of((InetAddress)addr);
            IPComponentList.add(IpCommand.copyable(LOCAL_IP_KEY, addrString, family, port));
            IPList.add(addrString);
        }
        String ipv4 = GlobalIPs.fetchGlobalIP(InternetProtocolFamily.IPv4);
        if (ipv4 != null && !IPList.contains(ipv4)) {
            IPComponentList.add(IpCommand.copyable(GLOBAL_IP_KEY, ipv4, InternetProtocolFamily.IPv4, port));
            IPList.add(ipv4);
        }
        if ((ipv6 = GlobalIPs.fetchGlobalIP(InternetProtocolFamily.IPv6)) != null && !IPList.contains(ipv6)) {
            IPComponentList.add(IpCommand.copyable(GLOBAL_IP_KEY, ipv6, InternetProtocolFamily.IPv6, port));
            IPList.add(ipv6);
        }
        String upnpIP = UPnP.getExternalIP();
        if (useUPnP && upnpIP != null && !IPList.contains(upnpIP)) {
            IPComponentList.add(ComponentUtils.wrapInSquareBrackets((Component)IpCommand.copyable(Component.literal((String)"UPnP IPv4"), upnpIP + ":" + port)));
            IPList.add(upnpIP);
        }
        if (IPComponentList.isEmpty()) {
            return CANNOT_GET_IP;
        }
        MutableComponent component = Component.empty();
        IPComponentList.forEach(arg_0 -> ((MutableComponent)component).append(arg_0));
        return Component.translatable((String)"mcwifipnp.upnp.clipboard", (Object[])new Object[]{component});
    }

    public static MutableComponent copyable(String ipTypeKey, String ip, InternetProtocolFamily family, int port) {
        return IpCommand.copyable(ipTypeKey, ip, family, ":" + port);
    }

    public static String formatIPString(String ip, InternetProtocolFamily family) {
        if (family == InternetProtocolFamily.IPv6) {
            ip = "[" + (String)ip + "]";
        }
        return ip;
    }

    public static MutableComponent copyable(String ipTypeKey, String ip, InternetProtocolFamily family, String suffix) {
        return IpCommand.copyable(ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)ipTypeKey, (Object[])new Object[]{family.toString()})), IpCommand.formatIPString(ip, family) + suffix);
    }

    public static MutableComponent copyable(String content) {
        return IpCommand.copyable(Component.literal((String)content), content);
    }

    public static MutableComponent copyable(MutableComponent base, String content) {
        return base.withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(content)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"chat.copy.click").append("\n").append(content))).withInsertion(content));
    }

    public static List<InetAddress> getLocalIPs() {
        LinkedList<InetAddress> results = new LinkedList<InetAddress>();
        Enumeration<NetworkInterface> ifaces = null;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Throwable t) {
            return results;
        }
        while (ifaces.hasMoreElements()) {
            Enumeration<InetAddress> addrs;
            NetworkInterface iface = ifaces.nextElement();
            try {
                if (!iface.isUp() || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint()) {
                    continue;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (iface.getDisplayName().contains("Virtual") || iface.getDisplayName().contains("VMware") || iface.getDisplayName().contains("VirtualBox") || iface.getDisplayName().contains("Bluetooth") || iface.getDisplayName().contains("Hyper-V") || (addrs = iface.getInetAddresses()) == null) continue;
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLinkLocalAddress()) continue;
                results.add(addr);
            }
        }
        return results;
    }
}

