/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.satxm.mcwifipnp.Config;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;

public class OnlineModeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder cmdBuilder = (LiteralArgumentBuilder)Commands.literal((String)"onlinemode").requires(cmdStack -> cmdStack.hasPermission(3));
        cmdBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)cmdBuilder.then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> OnlineModeCommand.setEnabled((CommandSourceStack)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"enabled"))))).executes(commandContext -> OnlineModeCommand.showEnabled((CommandSourceStack)commandContext.getSource()));
        commandDispatcher.register(cmdBuilder);
    }

    private static int setEnabled(CommandSourceStack commandSourceStack, boolean enabled) {
        MinecraftServer server = commandSourceStack.getServer();
        Config cfg = Config.readFromPublishedServer(server);
        cfg.onlineMode = enabled;
        cfg.saveAndApply(server);
        return OnlineModeCommand.showEnabled(commandSourceStack);
    }

    private static int showEnabled(CommandSourceStack commandSourceStack) {
        MinecraftServer server = commandSourceStack.getServer();
        Config cfg = Config.readFromPublishedServer(server);
        MutableComponent status = Component.translatable((String)"mcwifipnp.gui.OnlineMode").append(": ").append(cfg.onlineMode ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        commandSourceStack.sendSuccess(() -> OnlineModeCommand.lambda$showEnabled$3((Component)status), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$showEnabled$3(Component status) {
        return status;
    }
}

