/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import io.github.satxm.mcwifipnp.MCWiFiPnPUnit;
import io.github.satxm.mcwifipnp.ReadListFile;
import io.github.satxm.mcwifipnp.UUIDFixer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.Logger;

public class Config {
    public int port = 25565;
    @SerializedName(value="allow-host-cheat", alternate={"AllowCommands"})
    public boolean allowHostCheat = false;
    @SerializedName(value="max-players", alternate={"maxPlayers"})
    public int maxPlayers = 8;
    @SerializedName(value="gamemode", alternate={"GameMode"})
    public GameType gameType = GameType.SURVIVAL;
    public String motd = Component.translatable((String)"lanServer.title").getString();
    @SerializedName(value="allow-everyone-cheat", alternate={"AllPlayersCheats"})
    public boolean allowEveryoneCheat = false;
    @SerializedName(value="enforce-whitelist", alternate={"Whitelist"})
    public boolean enforceWhitelist = false;
    @SerializedName(value="enable-upnp", alternate={"UseUPnP"})
    public boolean useUPnP = true;
    @SerializedName(value="online-mode", alternate={"OnlineMode"})
    public boolean onlineMode = true;
    @SerializedName(value="enable-uuid-fixer", alternate={"EnableUUIDFixer"})
    public boolean enableUUIDFixer = false;
    @SerializedName(value="pvp", alternate={"PvP"})
    public boolean enablePvP = true;
    @SerializedName(value="get-public-ip", alternate={"CopyToClipboard"})
    public boolean getPublicIP = true;
    @SerializedName(value="remove-player-reporting", alternate={"removePlayerReportingButton"})
    public boolean removePlayerReportingButton = false;
    public transient Path location;
    public final transient boolean usingDefaults;
    public static final transient Logger LOGGER = MCWiFiPnPUnit.LOGGER;
    public static final transient Gson GSON = new GsonBuilder().registerTypeAdapter(GameType.class, new EnumLowerCaseAdapter()).setPrettyPrinting().create();

    private Config() {
        this(false);
    }

    private Config(boolean usingDefaults) {
        this.usingDefaults = usingDefaults;
    }

    public static Path getConfigPath(MinecraftServer server) {
        return server.getWorldPath(LevelResource.ROOT).resolve("mcwifipnp.json");
    }

    public static Config read(MinecraftServer server) {
        return Config.read(Config.getConfigPath(server));
    }

    public static Config readFromPublishedServer(MinecraftServer server) {
        Config cfg = Config.read(Config.getConfigPath(server));
        if (server.isPublished()) {
            cfg.readFromRunningServer(server);
        }
        return cfg;
    }

    public static Config read(Path location) {
        Config cfg;
        try {
            cfg = (Config)GSON.fromJson(new String(Files.readAllBytes(location), StandardCharsets.UTF_8), Config.class);
            cfg.location = location;
        }
        catch (JsonParseException | IOException e) {
            try {
                Files.deleteIfExists(location);
            }
            catch (IOException ie) {
                LOGGER.warn("Unable to read config file!", (Throwable)ie);
            }
            cfg = new Config(true);
            cfg.location = location;
        }
        return cfg;
    }

    public void save() {
        try {
            Files.write(this.location, GSON.toJson((Object)this).getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to write config file!", (Throwable)e);
        }
    }

    public void saveAndApply(MinecraftServer server) {
        if (server.isPublished()) {
            this.applyTo(server);
        }
        this.save();
    }

    public void readFromRunningServer(MinecraftServer server) {
        PlayerList playerList = server.getPlayerList();
        this.port = server.getPort();
        this.allowEveryoneCheat = playerList.isAllowCommandsForAllPlayers();
        this.gameType = server.getDefaultGameType();
        this.maxPlayers = playerList.getMaxPlayers();
        this.onlineMode = server.usesAuthentication();
        this.enablePvP = server.isPvpAllowed();
        this.enforceWhitelist = server.isEnforceWhitelist();
        this.motd = server.getMotd();
        this.enableUUIDFixer = UUIDFixer.enabled;
    }

    public void applyTo(MinecraftServer server) {
        PlayerList playerList = server.getPlayerList();
        server.setDefaultGameType(this.gameType);
        playerList.setAllowCommandsForAllPlayers(this.allowEveryoneCheat);
        server.setUsesAuthentication(this.onlineMode);
        ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_PVP)).set(this.enablePvP, server);
        server.setEnforceWhitelist(this.enforceWhitelist);
        server.setUsingWhitelist(this.enforceWhitelist);
        server.setMotd(this.motd);
        UUIDFixer.enabled = this.enableUUIDFixer;
        ReadListFile.ReadListFile(server);
    }

    private static class EnumLowerCaseAdapter<T extends Enum<T>>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private EnumLowerCaseAdapter() {
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).name().toLowerCase());
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Enum.valueOf((Class)typeOfT, json.getAsString().toUpperCase());
        }
    }
}

