/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.GsonHelper;

public class ReadListFile {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void ReadListFile(MinecraftServer server) {
        ServerOpListEntry entry;
        JsonObject jsonObject;
        JsonArray jsonArray;
        BufferedReader bufferedReader2;
        PlayerList playerList = server.getPlayerList();
        try {
            bufferedReader2 = Files.newReader((File)PlayerList.OPLIST_FILE, (Charset)StandardCharsets.UTF_8);
            jsonArray = (JsonArray)GSON.fromJson((Reader)bufferedReader2, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                jsonObject = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"entry");
                entry = new ServerOpListEntry(jsonObject);
                if (entry.getUser() == null) continue;
                playerList.getOps().add(entry);
            }
        }
        catch (JsonParseException | IOException | NullPointerException bufferedReader2) {
            // empty catch block
        }
        try {
            bufferedReader2 = Files.newReader((File)PlayerList.WHITELIST_FILE, (Charset)StandardCharsets.UTF_8);
            jsonArray = (JsonArray)GSON.fromJson((Reader)bufferedReader2, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                jsonObject = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"entry");
                entry = new UserWhiteListEntry(jsonObject);
                if (entry.getUser() == null) continue;
                playerList.getWhiteList().add((UserWhiteListEntry)entry);
            }
        }
        catch (JsonParseException | IOException | NullPointerException bufferedReader3) {
            // empty catch block
        }
        try {
            bufferedReader2 = Files.newReader((File)PlayerList.IPBANLIST_FILE, (Charset)StandardCharsets.UTF_8);
            jsonArray = (JsonArray)GSON.fromJson((Reader)bufferedReader2, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                jsonObject = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"entry");
                entry = new IpBanListEntry(jsonObject);
                if (entry.getUser() == null) continue;
                playerList.getIpBans().add((IpBanListEntry)entry);
            }
        }
        catch (JsonParseException | IOException | NullPointerException bufferedReader4) {
            // empty catch block
        }
        try {
            bufferedReader2 = Files.newReader((File)PlayerList.USERBANLIST_FILE, (Charset)StandardCharsets.UTF_8);
            jsonArray = (JsonArray)GSON.fromJson((Reader)bufferedReader2, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                jsonObject = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"entry");
                entry = new UserBanListEntry(jsonObject);
                if (entry.getUser() == null) continue;
                playerList.getBans().add((UserBanListEntry)entry);
            }
        }
        catch (JsonParseException | IOException | NullPointerException throwable) {
            // empty catch block
        }
    }
}

