/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.network;

import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.util.NetUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nullable;

public enum GlobalIPs {
    IP_SB_4("https://api-ipv4.ip.sb/ip", InternetProtocolFamily.IPv4),
    IP_SB_6("https://api-ipv6.ip.sb/ip", InternetProtocolFamily.IPv6),
    IPW_CN_4("https://4.ipw.cn", InternetProtocolFamily.IPv4),
    IPW_CN_6("https://6.ipw.cn", InternetProtocolFamily.IPv6);

    public final String apiEndPoint;
    public final InternetProtocolFamily family;

    private GlobalIPs(String apiEndPoint, InternetProtocolFamily family) {
        this.apiEndPoint = apiEndPoint;
        this.family = family;
    }

    @Nullable
    public String fetch() {
        return GlobalIPs.fetchGlobalIP(this.apiEndPoint, this.family);
    }

    @Nullable
    public static String fetchGlobalIP(String apiProvider, InternetProtocolFamily family) {
        String ip = null;
        try {
            String line;
            URL url = URI.create(apiProvider).toURL();
            URLConnection URLconnection = url.openConnection();
            InputStreamReader isr = new InputStreamReader(URLconnection.getInputStream());
            BufferedReader bufferReader = new BufferedReader(isr);
            while ((line = bufferReader.readLine()) != null) {
                ip = line;
            }
            bufferReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ip == null) {
            return null;
        }
        switch (family) {
            case IPv4: {
                if (NetUtil.isValidIpV4Address(ip)) break;
                ip = null;
                break;
            }
            case IPv6: {
                if (NetUtil.isValidIpV6Address(ip)) break;
                ip = null;
                break;
            }
            default: {
                ip = null;
            }
        }
        return ip;
    }

    @Nullable
    public static String fetchGlobalIP(InternetProtocolFamily family) {
        for (GlobalIPs api : GlobalIPs.values()) {
            String ip;
            if (api.family != family || (ip = api.fetch()) == null) continue;
            return ip;
        }
        return null;
    }
}

