/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    public static final int COLUMN_WIDTH = 150;
    public static final int GAP = 10;
    public final Screen screen;
    public final Font font;

    public OptionsList(Minecraft minecraft, int width, HeaderAndFooterLayout layout, Screen screen, Font font) {
        super(minecraft, width, layout.getContentHeight(), layout.getHeaderHeight(), 25);
        this.centerListVertically = false;
        this.screen = screen;
        this.font = font;
    }

    public void add(AbstractWidget widgets) {
        this.add(widgets, null);
    }

    public void add(AbstractWidget left, @Nullable AbstractWidget right) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(left, right));
    }

    public void add(Component labelLeft, AbstractWidget left) {
        this.addEntry((AbstractSelectionList.Entry)new LabeledEntry(labelLeft, left, null, null));
    }

    public void add(Component labelLeft, AbstractWidget left, Component labelRight, AbstractWidget right) {
        this.addEntry((AbstractSelectionList.Entry)new LabeledEntry(labelLeft, left, labelRight, right));
    }

    public int getRowWidth() {
        return 340;
    }

    protected class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final List<AbstractWidget> children;
        protected static final int X_OFFSET = 160;

        Entry(@Nullable AbstractWidget left, AbstractWidget right) {
            this.children = right == null ? ImmutableList.of((Object)left) : ImmutableList.of((Object)left, (Object)right);
        }

        public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f) {
            int xStart = OptionsList.this.screen.width / 2 - 150 - 5;
            for (AbstractWidget abstractwidget : this.children) {
                abstractwidget.setPosition(xStart, this.getContentY());
                abstractwidget.render(guiGraphics, i, j, f);
                xStart += 160;
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }

    protected class LabeledEntry
    extends Entry {
        protected final AbstractWidget left;
        protected final AbstractWidget right;
        protected final Component labelLeft;
        protected final Component labelRight;

        LabeledEntry(Component labelLeft, AbstractWidget left, Component labelRight, AbstractWidget right) {
            super(left, right);
            this.left = left;
            this.right = right;
            this.labelLeft = labelLeft;
            this.labelRight = labelRight;
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f) {
            int xStart = OptionsList.this.screen.width / 2 - 150 - 5;
            guiGraphics.drawString(OptionsList.this.font, this.labelLeft, xStart, this.getContentY() + (this.left.getHeight() - 9) / 2, 0xFFFFFF);
            if (this.right == null) {
                xStart += 160;
            }
            this.left.setPosition(xStart + (150 - this.left.getWidth()), this.getContentY());
            this.left.render(guiGraphics, i, j, f);
            if (this.right == null) {
                return;
            }
            guiGraphics.drawString(OptionsList.this.font, this.labelRight, xStart += 160, this.getContentY() + (this.right.getHeight() - 9) / 2, 0xFFFFFF);
            this.right.setPosition(xStart + (150 - this.right.getWidth()), this.getContentY());
            this.right.render(guiGraphics, i, j, f);
        }
    }
}

