/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.client;

import io.github.satxm.mcwifipnp.Config;
import io.github.satxm.mcwifipnp.MCWiFiPnPUnit;
import io.github.satxm.mcwifipnp.OnlineMode;
import io.github.satxm.mcwifipnp.client.EditBoxEx;
import io.github.satxm.mcwifipnp.commands.IpCommand;
import io.github.satxm.mcwifipnp.network.UPnPModule;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.CommonLayouts;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;

public class ShareToLanScreenNew
extends Screen {
    private final Config cfg;
    private final Screen lastScreen;
    private final boolean serverPublished;
    private final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
    }, x$0 -> this.removeWidget((GuiEventListener)x$0));
    @Nullable
    private TabNavigationBar tabNavigationBar;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected Button confirmButton;
    protected Checkbox removePlayerReportingButtonBox;
    @Nullable
    protected Button backToVanillaScreenButton;
    private boolean oldUPnPEnabled;
    private boolean oldCopyIP;
    private String oldMotd;

    public ShareToLanScreenNew(Screen screen, boolean serverPublished) {
        super((Component)Component.translatable((String)"lanServer.title"));
        this.lastScreen = screen;
        this.serverPublished = serverPublished;
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        this.cfg = Config.read((MinecraftServer)server);
        if (serverPublished) {
            this.cfg.readFromRunningServer((MinecraftServer)server);
        } else if (this.cfg.usingDefaults) {
            this.cfg.readFromRunningServer((MinecraftServer)server);
            this.cfg.port = HttpUtil.getAvailablePort();
            this.cfg.allowHostCheat = server.getWorldData().isAllowCommands();
        }
        this.oldMotd = this.cfg.motd;
        this.oldUPnPEnabled = this.cfg.useUPnP;
        this.oldCopyIP = this.cfg.getPublicIP;
    }

    protected void onConfirmClicked() {
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        PlayerList playerList = server.getPlayerList();
        NameAndId hostPlayer = new NameAndId(server.getSingleplayerProfile());
        this.cfg.save();
        if (this.serverPublished) {
            if (!this.oldMotd.equals(this.cfg.motd) || this.cfg.useUPnP ^ this.oldUPnPEnabled) {
                UPnPModule.stop((MinecraftServer)server);
                UPnPModule.startIfEnabled((MinecraftServer)server, this.cfg);
            }
            if (this.cfg.getPublicIP && this.cfg.getPublicIP ^ this.oldCopyIP) {
                new Thread(() -> server.getPlayerList().getPlayer(hostPlayer.id()).sendSystemMessage(IpCommand.getBrief((MinecraftServer)server)), "MCWiFiPnP").start();
            }
        } else {
            MutableComponent component = server.publishServer(this.cfg.gameType, this.cfg.allowEveryoneCheat, this.cfg.port) ? PublishCommand.getSuccessMessage((int)this.cfg.port) : Component.translatable((String)"commands.publish.failed");
            this.minecraft.gui.getChat().addMessage((Component)component);
            UPnPModule.startIfEnabled((MinecraftServer)server, this.cfg);
            if (this.cfg.getPublicIP) {
                new Thread(() -> server.getPlayerList().getPlayer(hostPlayer.id()).sendSystemMessage(IpCommand.getBrief((MinecraftServer)server)), "MCWiFiPnP").start();
            }
        }
        this.cfg.applyTo((MinecraftServer)server);
        if (!this.cfg.allowEveryoneCheat) {
            playerList.getOps().clear();
        }
        if (this.cfg.allowHostCheat) {
            playerList.getOps().add(new ServerOpListEntry(hostPlayer, 4, playerList.canBypassPlayerLimit(hostPlayer)));
        }
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            playerList.sendPlayerPermissionLevel(serverPlayer);
        }
        if (playerList.isUsingWhitelist()) {
            playerList.getWhiteList().add(new UserWhiteListEntry(hostPlayer));
            playerList.reloadWhiteList();
        }
        if (MCWiFiPnPUnit.convertOldUsers((MinecraftServer)this.minecraft.getSingleplayerServer())) {
            this.minecraft.getSingleplayerServer().services().nameToIdCache().add(hostPlayer);
        }
        this.minecraft.updateTitle();
        this.minecraft.setScreen((Screen)null);
    }

    protected void init() {
        this.tabNavigationBar = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(new Tab[]{new DefaultTab1(), new DefaultTab2(), new DefaultTab3()}).build();
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        this.confirmButton = Button.builder((Component)(this.serverPublished ? CommonComponents.GUI_DONE : Component.translatable((String)"lanServer.start")), button -> this.onConfirmClicked()).width(150).build();
        footer.addChild((LayoutElement)this.confirmButton);
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.tabNavigationBar.selectTab(0, false);
        this.repositionElements();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void repositionElements() {
        if (this.tabNavigationBar != null) {
            this.tabNavigationBar.setWidth(this.width);
            this.tabNavigationBar.arrangeElements();
            int i = this.tabNavigationBar.getRectangle().bottom();
            ScreenRectangle screenrectangle = new ScreenRectangle(0, i, this.width, this.height - this.layout.getFooterHeight() - i);
            this.tabManager.setTabArea(screenrectangle);
            this.layout.setHeaderHeight(i);
            this.layout.arrangeElements();
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, this.height - this.layout.getFooterHeight() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
    }

    private class DefaultTab1
    extends GridLayoutTab {
        public DefaultTab1() {
            EditBoxEx<Integer> portField;
            super((Component)Component.translatable((String)"mcwifipnp.gui.lanServerOptions"));
            GridLayout.RowHelper tabContents = this.layout.columnSpacing(8).rowSpacing(4).createRowHelper(4);
            if (ShareToLanScreenNew.this.serverPublished) {
                portField = new EditBoxEx<Integer>(ShareToLanScreenNew.this.font, 0, 0, 70, 20, (Component)Component.translatable((String)"lanServer.port"));
                portField.setEditable(false);
                portField.setValue(Integer.toString(ShareToLanScreenNew.this.cfg.port));
            } else {
                portField = EditBoxEx.numerical(ShareToLanScreenNew.this.font, 0, 0, 70, 20, (Component)Component.translatable((String)"lanServer.port")).defaults(ShareToLanScreenNew.this.cfg.port, -9408400, Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.port.info"))).invalid(-43691, Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.port.invalid"))).validator(port -> {
                    if (port < 1024 || port > 65535) {
                        throw new NumberFormatException("Port out of range:" + port);
                    }
                    if (!HttpUtil.isPortAvailable((int)port)) {
                        return new EditBoxEx.ValidatorResult(-43691, Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.port.unavailable")), false, true);
                    }
                    return null;
                }).responder((newState, newPort) -> {
                    ShareToLanScreenNew.this.confirmButton.active = newState.valid();
                    if (newState.updateBackendValue()) {
                        ShareToLanScreenNew.this.cfg.port = newPort;
                    }
                });
                portField.setMaxLength(5);
            }
            tabContents.addChild((LayoutElement)new StringWidget(portField.getMessage(), ShareToLanScreenNew.this.font), 1, this.layout.newCellSettings().alignHorizontallyLeft().paddingTop(6));
            tabContents.addChild(portField, 1, this.layout.newCellSettings().alignHorizontallyRight());
            EditBoxEx<Integer> maxPlayersField = EditBoxEx.numerical(ShareToLanScreenNew.this.font, 0, 0, 70, 20, (Component)Component.translatable((String)"mcwifipnp.gui.players")).bistate(ShareToLanScreenNew.this.cfg.maxPlayers, Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.players.info")), maxPlayers -> maxPlayers > 0).responder((newState, maxPlayers) -> {
                ShareToLanScreenNew.this.confirmButton.active = newState.valid();
                if (newState.updateBackendValue()) {
                    ShareToLanScreenNew.this.cfg.maxPlayers = maxPlayers;
                }
            });
            tabContents.addChild((LayoutElement)new StringWidget(maxPlayersField.getMessage(), ShareToLanScreenNew.this.font), 1, this.layout.newCellSettings().alignHorizontallyLeft().paddingTop(6));
            tabContents.addChild(maxPlayersField, 1, this.layout.newCellSettings().alignHorizontallyRight());
            tabContents.addChild((LayoutElement)CommonLayouts.labeledElement((Font)ShareToLanScreenNew.this.font, EditBoxEx.text(ShareToLanScreenNew.this.font, 0, 0, 308, 20, (Component)Component.translatable((String)"mcwifipnp.gui.motd")).bistate(ShareToLanScreenNew.this.cfg.motd, Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.motd.info")), newMotd -> true).responder((newState, newMotd) -> {
                ShareToLanScreenNew.this.confirmButton.active = newState.valid();
                if (newState.updateBackendValue()) {
                    ShareToLanScreenNew.this.cfg.motd = newMotd;
                }
            }).maxLength(32), (Component)Component.translatable((String)"mcwifipnp.gui.motd")), 4);
            if (!ShareToLanScreenNew.this.serverPublished) {
                tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.allowHostCheat).create((Component)Component.translatable((String)"selectWorld.allowCommands"), (cycleButton, allowHostCheat) -> {
                    ShareToLanScreenNew.this.cfg.allowHostCheat = allowHostCheat;
                }), 2);
            }
            tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.enforceWhitelist).withTooltip(state -> Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.Whitelist.info"))).create((Component)Component.translatable((String)"mcwifipnp.gui.Whitelist"), (cycleButton, enforceWhitelist) -> {
                ShareToLanScreenNew.this.cfg.enforceWhitelist = enforceWhitelist;
            }), 2);
            tabContents.addChild((LayoutElement)CycleButton.builder(OnlineMode::getDisplayName).withValues((Object[])OnlineMode.values()).withInitialValue((Object)OnlineMode.of(ShareToLanScreenNew.this.cfg.onlineMode, ShareToLanScreenNew.this.cfg.enableUUIDFixer)).withTooltip(OnlineMode2 -> Tooltip.create((Component)OnlineMode2.gettoolTip())).create((Component)Component.translatable((String)"mcwifipnp.gui.OnlineMode"), (cycleButton, onlineMode) -> {
                ShareToLanScreenNew.this.cfg.onlineMode = onlineMode.onlineMode;
                ShareToLanScreenNew.this.cfg.enableUUIDFixer = onlineMode.fixUUID;
            }), 2);
            tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.enablePvP).withTooltip(state -> Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.PvP.info"))).create((Component)Component.translatable((String)"mcwifipnp.gui.PvP"), (cycleButton, PvP) -> {
                ShareToLanScreenNew.this.cfg.enablePvP = PvP;
            }), 2);
        }
    }

    private class DefaultTab2
    extends GridLayoutTab {
        public DefaultTab2() {
            super((Component)Component.translatable((String)"lanServer.otherPlayers"));
            GridLayout.RowHelper tabContents = this.layout.columnSpacing(8).rowSpacing(4).createRowHelper(4);
            tabContents.addChild((LayoutElement)CycleButton.builder(GameType::getShortDisplayName).withValues((Object[])GameType.values()).withInitialValue((Object)ShareToLanScreenNew.this.cfg.gameType).create((Component)Component.translatable((String)"selectWorld.gameMode"), (cycleButton, gameType) -> {
                ShareToLanScreenNew.this.cfg.gameType = gameType;
            }), 2);
            tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.allowEveryoneCheat).withTooltip(state -> Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.AllPlayersCheats.info"))).create((Component)Component.translatable((String)"mcwifipnp.gui.AllPlayersCheats"), (cycleButton, allowEveryoneCheat) -> {
                ShareToLanScreenNew.this.cfg.allowEveryoneCheat = allowEveryoneCheat;
            }), 2);
        }
    }

    private class DefaultTab3
    extends GridLayoutTab {
        public DefaultTab3() {
            super((Component)Component.translatable((String)"mcwifipnp.gui.otherOptions"));
            GridLayout.RowHelper tabContents = this.layout.columnSpacing(8).rowSpacing(4).createRowHelper(4);
            tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.useUPnP).withTooltip(state -> Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.UseUPnP.info"))).create((Component)Component.translatable((String)"mcwifipnp.gui.UseUPnP"), (cycleButton, useUPnP) -> {
                ShareToLanScreenNew.this.cfg.useUPnP = useUPnP;
            }), 2);
            tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.getPublicIP).withTooltip(state -> Tooltip.create((Component)Component.translatable((String)"mcwifipnp.gui.CopyIP.info"))).create((Component)Component.translatable((String)"mcwifipnp.gui.CopyIP"), (cycleButton, getPublicIP) -> {
                ShareToLanScreenNew.this.cfg.getPublicIP = getPublicIP;
            }), 2);
            tabContents.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)ShareToLanScreenNew.this.cfg.removePlayerReportingButton).create((Component)Component.translatable((String)"mcwifipnp.gui.removePlayerReportingButton"), (cycleButton, removePlayerReportingButton) -> {
                ShareToLanScreenNew.this.cfg.removePlayerReportingButton = removePlayerReportingButton;
            }), 2);
            if (!ShareToLanScreenNew.this.serverPublished) {
                tabContents.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"mcwifipnp.gui.backToVanillaScreen"), button -> ShareToLanScreenNew.this.minecraft.setScreen((Screen)new ShareToLanScreen(ShareToLanScreenNew.this.lastScreen))).build(), 2);
            }
        }
    }
}

