/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.satxm.mcwifipnp.Config;
import io.github.satxm.mcwifipnp.UUIDFixer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;

public class UUIDFixerCommand {
    private static final Component POLICY_ONLINE = Component.translatable((String)"mcwifipnp.commands.uuidfixer.policy.online");
    private static final Component POLICY_OFFLINE = Component.translatable((String)"mcwifipnp.commands.uuidfixer.policy.offline");
    private static final Component POLICY_INVALID = Component.translatable((String)"mcwifipnp.commands.uuidfixer.policy.invalid");

    private static Component policyToComponent(String policy) {
        if (UUIDFixer.PolicyHolder.isUUID(policy)) {
            return Component.literal((String)policy);
        }
        if (UUIDFixer.PolicyHolder.isOfflinePolicy(policy)) {
            return POLICY_OFFLINE;
        }
        if (UUIDFixer.PolicyHolder.isOnlinePolicy(policy)) {
            return POLICY_ONLINE;
        }
        return POLICY_INVALID;
    }

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder cmdBuilder = (LiteralArgumentBuilder)Commands.literal((String)"uuidfixer").requires(cmdStack -> cmdStack.hasPermission(3));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(Commands.literal((String)"list").executes(commandContext -> UUIDFixerCommand.showList((CommandSourceStack)commandContext.getSource())));
        RequiredArgumentBuilder anyKnownPlayerNameArg = Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            MinecraftServer server = ((CommandSourceStack)commandContext.getSource()).getServer();
            Set players = server.getPlayerList().getPlayers().stream().map(player -> player.getGameProfile().name()).collect(Collectors.toSet());
            LinkedHashSet hints = new LinkedHashSet();
            UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
            policyHolder.getUsers().stream().filter(playerName -> !players.contains(playerName)).forEach(hints::add);
            hints.addAll(players);
            return SharedSuggestionProvider.suggest(hints, (SuggestionsBuilder)suggestionsBuilder);
        });
        RequiredArgumentBuilder modeArg = Commands.argument((String)"mode", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest(List.of("online", "offline", "<UUID>"), (SuggestionsBuilder)suggestionsBuilder));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(Commands.literal((String)"force").then(modeArg.then(anyKnownPlayerNameArg.executes(commandContext -> UUIDFixerCommand.setPolicy((CommandSourceStack)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"playerName"), StringArgumentType.getString((CommandContext)commandContext, (String)"mode"))))));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"default-online").then(Commands.argument((String)"mode", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> UUIDFixerCommand.setDefaultPolicy((CommandSourceStack)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"mode"))))).executes(commandContext -> UUIDFixerCommand.showDefaultPolicy((CommandSourceStack)commandContext.getSource())));
        RequiredArgumentBuilder playerNameArg = Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
            return SharedSuggestionProvider.suggest(policyHolder.getUsers(), (SuggestionsBuilder)suggestionsBuilder);
        });
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(Commands.literal((String)"remove").then(playerNameArg.executes(commandContext -> UUIDFixerCommand.removePolicy((CommandSourceStack)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"playerName")))));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(Commands.literal((String)"test").then(anyKnownPlayerNameArg.executes(commandContext -> UUIDFixerCommand.testPolicy((CommandSourceStack)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"playerName")))));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"enabled").then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> UUIDFixerCommand.setEnabled((CommandSourceStack)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"enabled"))))).executes(commandContext -> UUIDFixerCommand.showEnabled((CommandSourceStack)commandContext.getSource())));
        commandDispatcher.register(cmdBuilder);
    }

    private static int setEnabled(CommandSourceStack commandSourceStack, boolean enabled) {
        MinecraftServer server = commandSourceStack.getServer();
        Config cfg = Config.readFromPublishedServer(server);
        cfg.enableUUIDFixer = enabled;
        cfg.saveAndApply(server);
        return UUIDFixerCommand.showEnabled(commandSourceStack);
    }

    private static int showEnabled(CommandSourceStack commandSourceStack) {
        MinecraftServer server = commandSourceStack.getServer();
        Config cfg = Config.readFromPublishedServer(server);
        MutableComponent status = Component.translatable((String)"mcwifipnp.commands.uuidfixer.name").append(": ").append(cfg.enableUUIDFixer ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        commandSourceStack.sendSuccess(() -> UUIDFixerCommand.lambda$showEnabled$14((Component)status), false);
        return 1;
    }

    private static int setPolicy(CommandSourceStack commandSourceStack, String playerName, String policy) throws CommandSyntaxException {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        if (!UUIDFixer.PolicyHolder.isValidPolicy(policy)) {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"mcwifipnp.commands.uuidfixer.set.bad-policy", (Object[])new Object[]{policy})).create();
        }
        policyHolder.set(playerName, policy);
        if (UUIDFixer.PolicyHolder.isUUID(policy)) {
            commandSourceStack.sendSuccess(() -> Component.translatable((String)"mcwifipnp.commands.uuidfixer.set.override", (Object[])new Object[]{playerName, policy}), true);
        } else {
            commandSourceStack.sendSuccess(() -> Component.translatable((String)"mcwifipnp.commands.uuidfixer.set.success", (Object[])new Object[]{playerName, UUIDFixerCommand.policyToComponent(policy)}), true);
        }
        policyHolder.save();
        return 1;
    }

    private static int removePolicy(CommandSourceStack commandSourceStack, String playerName) throws CommandSyntaxException {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        if (policyHolder.getOrNull(playerName) == null) {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"mcwifipnp.commands.uuidfixer.policy.not-exist", (Object[])new Object[]{playerName})).create();
        }
        policyHolder.remove(playerName);
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"mcwifipnp.commands.uuidfixer.remove.success", (Object[])new Object[]{playerName}), true);
        policyHolder.save();
        commandSourceStack.getServer().kickUnlistedPlayers();
        return 1;
    }

    private static int setDefaultPolicy(CommandSourceStack commandSourceStack, boolean defaultIsOnline) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        policyHolder.setDefaultPolicy(defaultIsOnline);
        policyHolder.save();
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"mcwifipnp.commands.uuidfixer.default.set", (Object[])new Object[]{defaultIsOnline ? POLICY_ONLINE : POLICY_OFFLINE}), false);
        return 1;
    }

    private static Supplier<Component> showDefaultPolicy(UUIDFixer.PolicyHolder policyHolder) {
        boolean defaultIsOnline = policyHolder.isOnlineByDefault();
        return () -> Component.translatable((String)"mcwifipnp.commands.uuidfixer.default.show", (Object[])new Object[]{defaultIsOnline ? POLICY_ONLINE : POLICY_OFFLINE});
    }

    private static int showDefaultPolicy(CommandSourceStack commandSourceStack) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        commandSourceStack.sendSuccess(UUIDFixerCommand.showDefaultPolicy(policyHolder), false);
        return 1;
    }

    private static Component showPolicy(UUIDFixer.PolicyHolder policyHolder, String playerName, boolean simulate) {
        MutableComponent policyStr = Component.empty();
        policyStr.append(playerName + ": ");
        String policy = policyHolder.getOrNull(playerName);
        if (simulate && policy == null) {
            policyStr.append(policyHolder.isOnlineByDefault() ? POLICY_ONLINE : POLICY_OFFLINE);
        } else {
            policyStr.append(UUIDFixerCommand.policyToComponent(policy));
        }
        return policyStr;
    }

    private static int showList(CommandSourceStack commandSourceStack) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        int count = policyHolder.count();
        MutableComponent list = (MutableComponent)UUIDFixerCommand.showDefaultPolicy(policyHolder).get();
        if (count == 0) {
            list.append("\n");
            list.append((Component)Component.translatable((String)"mcwifipnp.commands.uuidfixer.none"));
        } else {
            list.append("\n");
            list.append((Component)Component.translatable((String)"mcwifipnp.commands.uuidfixer.list", (Object[])new Object[]{policyHolder.count()}));
            for (String playerName : policyHolder.getUsers()) {
                list.append("\n");
                list.append(UUIDFixerCommand.showPolicy(policyHolder, playerName, false));
            }
        }
        commandSourceStack.sendSuccess(() -> list, false);
        return count;
    }

    private static int testPolicy(CommandSourceStack commandSourceStack, String playerName) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        Component component = UUIDFixerCommand.showPolicy(policyHolder, playerName, true);
        commandSourceStack.sendSuccess(() -> component, false);
        return 1;
    }

    private static /* synthetic */ Component lambda$showEnabled$14(Component status) {
        return status;
    }
}

