/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import io.github.satxm.mcwifipnp.MCWiFiPnPUnit;
import io.github.satxm.mcwifipnp.UUIDFixer;
import io.github.satxm.mcwifipnp.client.MaxPlayers;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class Config {
    public int port = 25565;
    @SerializedName(value="allow-host-cheat", alternate={"AllowCommands"})
    public boolean allowHostCheat = false;
    @SerializedName(value="max-players", alternate={"maxPlayers"})
    public int maxPlayers = 8;
    @SerializedName(value="gamemode", alternate={"GameMode"})
    public class_1934 gameType = class_1934.field_9215;
    public String motd = class_2561.method_43471((String)"lanServer.title").getString();
    @SerializedName(value="allow-everyone-cheat", alternate={"AllPlayersCheats"})
    public boolean allowEveryoneCheat = false;
    @SerializedName(value="enforce-whitelist", alternate={"Whitelist"})
    public boolean enforceWhitelist = false;
    @SerializedName(value="enable-upnp", alternate={"UseUPnP"})
    public boolean useUPnP = true;
    @SerializedName(value="online-mode", alternate={"OnlineMode"})
    public boolean onlineMode = true;
    @SerializedName(value="enable-uuid-fixer", alternate={"EnableUUIDFixer"})
    public boolean enableUUIDFixer = false;
    @SerializedName(value="pvp", alternate={"PvP"})
    public boolean enablePvP = true;
    @SerializedName(value="get-public-ip", alternate={"CopyToClipboard"})
    public boolean getPublicIP = true;
    @SerializedName(value="remove-player-reporting", alternate={"removePlayerReportingButton"})
    public boolean removePlayerReportingButton = false;
    public transient Path location;
    public final transient boolean usingDefaults;
    public static final transient Logger LOGGER = MCWiFiPnPUnit.LOGGER;
    public static final transient Gson GSON = new GsonBuilder().registerTypeAdapter(class_1934.class, new EnumLowerCaseAdapter()).setPrettyPrinting().create();

    private Config() {
        this(false);
    }

    private Config(boolean usingDefaults) {
        this.usingDefaults = usingDefaults;
    }

    public static Path getConfigPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("mcwifipnp.json");
    }

    public static Config read(MinecraftServer server) {
        return Config.read(Config.getConfigPath(server));
    }

    public static Config readFromPublishedServer(MinecraftServer server) {
        Config cfg = Config.read(Config.getConfigPath(server));
        if (server.method_3860()) {
            cfg.readFromRunningServer(server);
        }
        return cfg;
    }

    public static Config read(Path location) {
        Config cfg;
        try {
            cfg = (Config)GSON.fromJson(new String(Files.readAllBytes(location), "utf-8"), Config.class);
            cfg.location = location;
        }
        catch (JsonParseException | IOException e) {
            try {
                Files.deleteIfExists(location);
            }
            catch (IOException ie) {
                LOGGER.warn("Unable to read config file!", (Throwable)ie);
            }
            cfg = new Config(true);
            cfg.location = location;
        }
        return cfg;
    }

    public void save() {
        try {
            Files.write(this.location, GSON.toJson((Object)this).getBytes("utf-8"), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to write config file!", (Throwable)e);
        }
    }

    public void saveAndApply(MinecraftServer server) {
        if (server.method_3860()) {
            this.applyTo(server);
        }
        this.save();
    }

    public void readFromRunningServer(MinecraftServer server) {
        class_3324 playerList = server.method_3760();
        this.port = server.method_3756();
        this.allowEveryoneCheat = playerList.method_14579();
        this.gameType = server.method_3790();
        this.maxPlayers = playerList.method_14592();
        this.onlineMode = server.method_3828();
        this.enablePvP = server.method_3852();
        this.enforceWhitelist = server.method_3729();
        this.motd = server.method_3818();
        this.enableUUIDFixer = UUIDFixer.enabled;
    }

    public void applyTo(MinecraftServer server) {
        class_3324 playerList = server.method_3760();
        server.method_3838(this.gameType);
        playerList.method_14607(this.allowEveryoneCheat);
        ((MaxPlayers)server).setMaxPlayers(this.maxPlayers);
        server.method_3864(this.onlineMode);
        ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_62434)).method_20758(this.enablePvP, server);
        server.method_3731(this.enforceWhitelist);
        server.method_73589(this.enforceWhitelist);
        server.method_3834(this.motd);
        UUIDFixer.enabled = this.enableUUIDFixer;
    }

    private static class EnumLowerCaseAdapter<T extends Enum<T>>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private EnumLowerCaseAdapter() {
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).name().toLowerCase());
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Enum.valueOf((Class)typeOfT, json.getAsString().toUpperCase());
        }
    }
}

