/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.dosse.upnp.UPnP;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.satxm.mcwifipnp.commands.EnumArgument;
import io.github.satxm.mcwifipnp.network.GlobalIPs;
import io.github.satxm.mcwifipnp.network.UPnPModule;
import io.netty.channel.socket.InternetProtocolFamily;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class IpCommand {
    public static String LOCAL_IP_KEY = "mcwifipnp.gui.localIP";
    public static String GLOBAL_IP_KEY = "mcwifipnp.gui.globalIP";
    public static class_2561 CANNOT_GET_IP = class_2561.method_43471((String)"mcwifipnp.upnp.cantgetip");

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        LiteralArgumentBuilder cmdBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"ip").requires(cmdStack -> cmdStack.method_9259(4));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(EnumArgument.IP_FAMILY.appendTo((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"local").executes(IpCommand::showLocalIPsAll)), enumOption -> (LiteralArgumentBuilder)enumOption.executes(IpCommand::showLocalIPs)))).then(EnumArgument.IP_FAMILY.appendTo((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"global").executes(IpCommand::showGlobalIPAll)), enumOption -> (LiteralArgumentBuilder)enumOption.executes(IpCommand::showGlobalIP)))).then(class_2170.method_9247((String)"upnp").executes(IpCommand::showUPnPIP))).executes(IpCommand::showDetail));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.executes(IpCommand::showBrief);
        commandDispatcher.register(cmdBuilder);
    }

    private static int showLocalIPs(CommandContext<class_2168> context) {
        InternetProtocolFamily family = EnumArgument.IP_FAMILY.valueOf(context, 0);
        return IpCommand.getAndReply(context, components -> IpCommand.getIPComponentLocal(components, family));
    }

    private static void showLocalIPsAllImpl(List<class_5250> results) {
        int labelIndex = results.size();
        int count = IpCommand.getIPComponentLocal(results, InternetProtocolFamily.IPv4);
        if ((count += IpCommand.getIPComponentLocal(results, InternetProtocolFamily.IPv6)) > 0) {
            results.add(labelIndex, class_2561.method_43469((String)LOCAL_IP_KEY, (Object[])new Object[]{"IP"}).method_27693(":"));
        }
    }

    private static int showLocalIPsAll(CommandContext<class_2168> context) {
        return IpCommand.getAndReply(context, components -> {
            IpCommand.getIPComponentLocal(components, InternetProtocolFamily.IPv4);
            IpCommand.getIPComponentLocal(components, InternetProtocolFamily.IPv6);
        });
    }

    private static int showGlobalIP(CommandContext<class_2168> context) {
        InternetProtocolFamily family = EnumArgument.IP_FAMILY.valueOf(context, 0);
        return IpCommand.getAndReply(context, components -> IpCommand.getIPComponentGlobal(components, family));
    }

    private static void showGlobalIPAllImpl(List<class_5250> results) {
        int labelIndex = results.size();
        int count = IpCommand.getIPComponentGlobal(results, InternetProtocolFamily.IPv4);
        if ((count += IpCommand.getIPComponentGlobal(results, InternetProtocolFamily.IPv6)) > 0) {
            results.add(labelIndex, class_2561.method_43469((String)GLOBAL_IP_KEY, (Object[])new Object[]{"IP"}).method_27693(":"));
        }
    }

    private static int showGlobalIPAll(CommandContext<class_2168> context) {
        return IpCommand.getAndReply(context, IpCommand::showGlobalIPAllImpl);
    }

    private static int showUPnPIP(CommandContext<class_2168> context) {
        return IpCommand.getAndReply(context, components -> IpCommand.getIPComponentUPnP(components, context));
    }

    private static int showDetail(CommandContext<class_2168> context) {
        return IpCommand.getAndReply(context, components -> {
            IpCommand.showGlobalIPAllImpl(components);
            IpCommand.showLocalIPsAllImpl(components);
            int labelIndex = components.size();
            if (IpCommand.getIPComponentUPnP(components, context) > 0) {
                components.add(labelIndex, class_2561.method_43470((String)"UPnP IPv4:"));
            }
        });
    }

    private static int showBrief(CommandContext<class_2168> context) {
        class_2561 result = IpCommand.getBrief(((class_2168)context.getSource()).method_9211());
        if (result == CANNOT_GET_IP) {
            ((class_2168)context.getSource()).method_9213(result);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> result, false);
        }
        return result == CANNOT_GET_IP ? 0 : 1;
    }

    private static int getAndReply(CommandContext<class_2168> context, Consumer<List<class_5250>> sources) {
        LinkedList components = new LinkedList();
        sources.accept(components);
        if (components.isEmpty()) {
            ((class_2168)context.getSource()).method_9213(CANNOT_GET_IP);
            return 0;
        }
        components.forEach(component -> ((class_2168)context.getSource()).method_9226(() -> component, false));
        return components.size();
    }

    private static int getIPComponentLocal(List<class_5250> results, InternetProtocolFamily family) {
        List<InetAddress> localIPs = IpCommand.getLocalIPs();
        if (localIPs.isEmpty()) {
            return 0;
        }
        for (InetAddress addr : localIPs) {
            if (family != InternetProtocolFamily.of((InetAddress)addr)) continue;
            String addrString = addr.getHostAddress();
            addrString = IpCommand.formatIPString(addrString, family);
            results.add(IpCommand.copyable(addrString));
        }
        return results.size();
    }

    private static int getIPComponentGlobal(List<class_5250> results, InternetProtocolFamily family) {
        String ip = GlobalIPs.fetchGlobalIP(family);
        if (ip == null) {
            return 0;
        }
        ip = IpCommand.formatIPString(ip, family);
        results.add(IpCommand.copyable(ip));
        return 1;
    }

    private static int getIPComponentUPnP(List<class_5250> results, CommandContext<class_2168> context) {
        String upnpIP = UPnP.getExternalIP();
        if (!UPnPModule.has(((class_2168)context.getSource()).method_9211()) || upnpIP == null) {
            return 0;
        }
        class_5250 component = IpCommand.copyable(upnpIP);
        results.add(component);
        return 1;
    }

    public static class_2561 getBrief(MinecraftServer server) {
        String ipv6;
        int port = server.method_3756();
        boolean useUPnP = UPnPModule.has(server);
        LinkedList<class_5250> IPComponentList = new LinkedList<class_5250>();
        ArrayList<String> IPList = new ArrayList<String>();
        List<InetAddress> localIPs = IpCommand.getLocalIPs();
        for (InetAddress addr : localIPs) {
            String addrString = addr.getHostAddress();
            InternetProtocolFamily family = InternetProtocolFamily.of((InetAddress)addr);
            IPComponentList.add(IpCommand.copyable(LOCAL_IP_KEY, addrString, family, port));
            IPList.add(addrString);
        }
        String ipv4 = GlobalIPs.fetchGlobalIP(InternetProtocolFamily.IPv4);
        if (ipv4 != null && !IPList.contains(ipv4)) {
            IPComponentList.add(IpCommand.copyable(GLOBAL_IP_KEY, ipv4, InternetProtocolFamily.IPv4, port));
            IPList.add(ipv4);
        }
        if ((ipv6 = GlobalIPs.fetchGlobalIP(InternetProtocolFamily.IPv6)) != null && !IPList.contains(ipv6)) {
            IPComponentList.add(IpCommand.copyable(GLOBAL_IP_KEY, ipv6, InternetProtocolFamily.IPv6, port));
            IPList.add(ipv6);
        }
        String upnpIP = UPnP.getExternalIP();
        if (useUPnP && upnpIP != null && !IPList.contains(upnpIP)) {
            IPComponentList.add(class_2564.method_10885((class_2561)IpCommand.copyable(class_2561.method_43470((String)"UPnP IPv4"), upnpIP)));
            IPList.add(upnpIP);
        }
        if (IPComponentList.isEmpty()) {
            return CANNOT_GET_IP;
        }
        class_5250 component = class_2561.method_43473();
        IPComponentList.forEach(arg_0 -> ((class_5250)component).method_10852(arg_0));
        return class_2561.method_43469((String)"mcwifipnp.upnp.clipboard", (Object[])new Object[]{component});
    }

    public static class_5250 copyable(String ipTypeKey, String ip, InternetProtocolFamily family, int port) {
        return IpCommand.copyable(ipTypeKey, ip, family, ":" + port);
    }

    public static String formatIPString(String ip, InternetProtocolFamily family) {
        if (family == InternetProtocolFamily.IPv6) {
            ip = "[" + (String)ip + "]";
        }
        return ip;
    }

    public static class_5250 copyable(String ipTypeKey, String ip, InternetProtocolFamily family, String suffix) {
        return IpCommand.copyable(class_2564.method_10885((class_2561)class_2561.method_43469((String)ipTypeKey, (Object[])new Object[]{family.toString()})), IpCommand.formatIPString(ip, family) + suffix);
    }

    public static class_5250 copyable(String content) {
        return IpCommand.copyable(class_2561.method_43470((String)content), content);
    }

    public static class_5250 copyable(class_5250 base, String content) {
        return base.method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10606(content)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.copy.click").method_27693("\n").method_27693(content))).method_10975(content));
    }

    public static List<InetAddress> getLocalIPs() {
        LinkedList<InetAddress> results = new LinkedList<InetAddress>();
        Enumeration<NetworkInterface> ifaces = null;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Throwable t) {
            return results;
        }
        while (ifaces.hasMoreElements()) {
            Enumeration<InetAddress> addrs;
            NetworkInterface iface = ifaces.nextElement();
            try {
                if (!iface.isUp() || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint()) {
                    continue;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (iface.getDisplayName().contains("Virtual") || iface.getDisplayName().contains("VMware") || iface.getDisplayName().contains("VirtualBox") || iface.getDisplayName().contains("Bluetooth") || iface.getDisplayName().contains("Hyper-V") || (addrs = iface.getInetAddresses()) == null) continue;
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLinkLocalAddress()) continue;
                results.add(addr);
            }
        }
        return results;
    }
}

