/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.satxm.mcwifipnp.Config;
import io.github.satxm.mcwifipnp.network.UPnPModule;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;

public class UPnPCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder cmdBuilder = (LiteralArgumentBuilder)Commands.literal((String)"upnp").requires(cmdStack -> cmdStack.hasPermission(3));
        cmdBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)cmdBuilder.then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> UPnPCommand.setEnabled((CommandSourceStack)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"enabled"))))).executes(commandContext -> UPnPCommand.showEnabled((CommandSourceStack)commandContext.getSource()));
        commandDispatcher.register(cmdBuilder);
    }

    private static int setEnabled(CommandSourceStack commandSourceStack, boolean enabled) {
        MinecraftServer server = commandSourceStack.getServer();
        Config cfg = Config.readFromPublishedServer(server);
        if (cfg.useUPnP ^ enabled) {
            cfg.useUPnP = enabled;
            cfg.saveAndApply(server);
            if (enabled) {
                if (server.isPublished()) {
                    UPnPModule.startIfEnabled(server, cfg);
                }
            } else {
                UPnPModule.stop(server);
            }
        }
        return UPnPCommand.showEnabled(commandSourceStack);
    }

    private static int showEnabled(CommandSourceStack commandSourceStack) {
        MinecraftServer server = commandSourceStack.getServer();
        Config cfg = Config.readFromPublishedServer(server);
        MutableComponent status = Component.literal((String)"UPnP: ").append(cfg.useUPnP ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        commandSourceStack.sendSuccess(() -> UPnPCommand.lambda$showEnabled$3((Component)status), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$showEnabled$3(Component status) {
        return status;
    }
}

