/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.mojang.brigadier.CommandDispatcher;
import io.github.satxm.mcwifipnp.MCWiFiPnP;
import io.github.satxm.mcwifipnp.UUIDFixer;
import io.github.satxm.mcwifipnp.commands.IpCommand;
import io.github.satxm.mcwifipnp.commands.OnlineModeCommand;
import io.github.satxm.mcwifipnp.commands.UPnPCommand;
import io.github.satxm.mcwifipnp.commands.UUIDFixerCommand;
import io.github.satxm.mcwifipnp.network.UPnPModule;
import net.minecraft.class_2168;
import net.minecraft.class_3012;
import net.minecraft.class_3014;
import net.minecraft.class_3016;
import net.minecraft.class_3030;
import net.minecraft.class_3083;
import net.minecraft.class_3086;
import net.minecraft.class_3088;
import net.minecraft.class_3156;
import net.minecraft.class_3321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCWiFiPnPUnit {
    public static final String MODID = "mcwifipnp";
    public static final Logger LOGGER = LogManager.getLogger(MCWiFiPnP.class);

    public static void registerCommands(CommandDispatcher<class_2168> cmdDispatcher, boolean isDedicatedServer) {
        UUIDFixerCommand.register(cmdDispatcher);
        if (isDedicatedServer) {
            MCWiFiPnPUnit.enableUUIDFixerOnDedicatedServer();
            return;
        }
        IpCommand.register(cmdDispatcher);
        OnlineModeCommand.register(cmdDispatcher);
        UPnPCommand.register(cmdDispatcher);
        class_3030.method_13143(cmdDispatcher);
        class_3083.method_13464(cmdDispatcher);
        class_3156.method_13836(cmdDispatcher);
        class_3012.method_13008(cmdDispatcher);
        class_3014.method_13014(cmdDispatcher);
        class_3016.method_13021(cmdDispatcher);
        class_3086.method_13472(cmdDispatcher);
        class_3088.method_13478(cmdDispatcher);
    }

    public static void onServerStopping(MinecraftServer server) {
        if (!server.method_3816()) {
            UPnPModule.stop(server);
        }
    }

    public static void onServerStarting(MinecraftServer server) {
    }

    public static void enableUUIDFixerOnDedicatedServer() {
        UUIDFixer.enabled = true;
        LOGGER.info("UUID Fixer has been enabled on the dedicated server.To disable, delete mod McWifiPnP. Config file is \"uuid_fixer.json\".");
    }

    public static boolean convertOldUsers(MinecraftServer server) {
        int i;
        boolean bl = false;
        for (i = 0; !bl && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl = class_3321.method_14547((MinecraftServer)server);
        }
        boolean bl2 = false;
        for (i = 0; !bl2 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl2 = class_3321.method_14545((MinecraftServer)server);
        }
        boolean bl3 = false;
        for (i = 0; !bl3 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl3 = class_3321.method_14539((MinecraftServer)server);
        }
        boolean bl4 = false;
        for (i = 0; !bl4 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl4 = class_3321.method_14533((MinecraftServer)server);
        }
        return bl || bl2 || bl3 || bl4;
    }

    private static void waitForRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

