/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.satxm.mcwifipnp.Config;
import io.github.satxm.mcwifipnp.UUIDFixer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class UUIDFixerCommand {
    private static final class_2561 POLICY_ONLINE = class_2561.method_43471((String)"mcwifipnp.commands.uuidfixer.policy.online");
    private static final class_2561 POLICY_OFFLINE = class_2561.method_43471((String)"mcwifipnp.commands.uuidfixer.policy.offline");
    private static final class_2561 POLICY_INVALID = class_2561.method_43471((String)"mcwifipnp.commands.uuidfixer.policy.invalid");

    private static class_2561 policyToComponent(String policy) {
        if (UUIDFixer.PolicyHolder.isUUID(policy)) {
            return class_2561.method_43470((String)policy);
        }
        if (UUIDFixer.PolicyHolder.isOfflinePolicy(policy)) {
            return POLICY_OFFLINE;
        }
        if (UUIDFixer.PolicyHolder.isOnlinePolicy(policy)) {
            return POLICY_ONLINE;
        }
        return POLICY_INVALID;
    }

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        LiteralArgumentBuilder cmdBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"uuidfixer").requires(cmdStack -> cmdStack.method_9259(3));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(class_2170.method_9247((String)"list").executes(commandContext -> UUIDFixerCommand.showList((class_2168)commandContext.getSource())));
        RequiredArgumentBuilder anyKnownPlayerNameArg = class_2170.method_9244((String)"playerName", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            MinecraftServer server = ((class_2168)commandContext.getSource()).method_9211();
            Set players = server.method_3760().method_14571().stream().map(player -> player.method_7334().name()).collect(Collectors.toSet());
            LinkedHashSet hints = new LinkedHashSet();
            UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
            policyHolder.getUsers().stream().filter(playerName -> !players.contains(playerName)).forEach(hints::add);
            hints.addAll(players);
            return class_2172.method_9265(hints, (SuggestionsBuilder)suggestionsBuilder);
        });
        RequiredArgumentBuilder modeArg = class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> class_2172.method_9265(List.of("online", "offline", "<UUID>"), (SuggestionsBuilder)suggestionsBuilder));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(class_2170.method_9247((String)"force").then(modeArg.then(anyKnownPlayerNameArg.executes(commandContext -> UUIDFixerCommand.setPolicy((class_2168)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"playerName"), StringArgumentType.getString((CommandContext)commandContext, (String)"mode"))))));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"default-online").then(class_2170.method_9244((String)"mode", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> UUIDFixerCommand.setDefaultPolicy((class_2168)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"mode"))))).executes(commandContext -> UUIDFixerCommand.showDefaultPolicy((class_2168)commandContext.getSource())));
        RequiredArgumentBuilder playerNameArg = class_2170.method_9244((String)"playerName", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> {
            UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
            return class_2172.method_9265(policyHolder.getUsers(), (SuggestionsBuilder)suggestionsBuilder);
        });
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(class_2170.method_9247((String)"remove").then(playerNameArg.executes(commandContext -> UUIDFixerCommand.removePolicy((class_2168)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"playerName")))));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(class_2170.method_9247((String)"test").then(anyKnownPlayerNameArg.executes(commandContext -> UUIDFixerCommand.testPolicy((class_2168)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"playerName")))));
        cmdBuilder = (LiteralArgumentBuilder)cmdBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enabled").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> UUIDFixerCommand.setEnabled((class_2168)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"enabled"))))).executes(commandContext -> UUIDFixerCommand.showEnabled((class_2168)commandContext.getSource())));
        commandDispatcher.register(cmdBuilder);
    }

    private static int setEnabled(class_2168 commandSourceStack, boolean enabled) {
        MinecraftServer server = commandSourceStack.method_9211();
        Config cfg = Config.readFromPublishedServer(server);
        cfg.enableUUIDFixer = enabled;
        cfg.saveAndApply(server);
        return UUIDFixerCommand.showEnabled(commandSourceStack);
    }

    private static int showEnabled(class_2168 commandSourceStack) {
        MinecraftServer server = commandSourceStack.method_9211();
        Config cfg = Config.readFromPublishedServer(server);
        class_5250 status = class_2561.method_43471((String)"mcwifipnp.commands.uuidfixer.name").method_27693(": ").method_10852(cfg.enableUUIDFixer ? class_5244.field_24332 : class_5244.field_24333);
        commandSourceStack.method_9226(() -> UUIDFixerCommand.lambda$showEnabled$14((class_2561)status), false);
        return 1;
    }

    private static int setPolicy(class_2168 commandSourceStack, String playerName, String policy) throws CommandSyntaxException {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        if (!UUIDFixer.PolicyHolder.isValidPolicy(policy)) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.set.bad-policy", (Object[])new Object[]{policy})).create();
        }
        policyHolder.set(playerName, policy);
        if (UUIDFixer.PolicyHolder.isUUID(policy)) {
            commandSourceStack.method_9226(() -> class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.set.override", (Object[])new Object[]{playerName, policy}), true);
        } else {
            commandSourceStack.method_9226(() -> class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.set.success", (Object[])new Object[]{playerName, UUIDFixerCommand.policyToComponent(policy)}), true);
        }
        policyHolder.save();
        return 1;
    }

    private static int removePolicy(class_2168 commandSourceStack, String playerName) throws CommandSyntaxException {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        if (policyHolder.getOrNull(playerName) == null) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.policy.not-exist", (Object[])new Object[]{playerName})).create();
        }
        policyHolder.remove(playerName);
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.remove.success", (Object[])new Object[]{playerName}), true);
        policyHolder.save();
        commandSourceStack.method_9211().method_3728();
        return 1;
    }

    private static int setDefaultPolicy(class_2168 commandSourceStack, boolean defaultIsOnline) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        policyHolder.setDefaultPolicy(defaultIsOnline);
        policyHolder.save();
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.default.set", (Object[])new Object[]{defaultIsOnline ? POLICY_ONLINE : POLICY_OFFLINE}), false);
        return 1;
    }

    private static Supplier<class_2561> showDefaultPolicy(UUIDFixer.PolicyHolder policyHolder) {
        boolean defaultIsOnline = policyHolder.isOnlineByDefault();
        return () -> class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.default.show", (Object[])new Object[]{defaultIsOnline ? POLICY_ONLINE : POLICY_OFFLINE});
    }

    private static int showDefaultPolicy(class_2168 commandSourceStack) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        commandSourceStack.method_9226(UUIDFixerCommand.showDefaultPolicy(policyHolder), false);
        return 1;
    }

    private static class_2561 showPolicy(UUIDFixer.PolicyHolder policyHolder, String playerName, boolean simulate) {
        class_5250 policyStr = class_2561.method_43473();
        policyStr.method_27693(playerName + ": ");
        String policy = policyHolder.getOrNull(playerName);
        if (simulate && policy == null) {
            policyStr.method_10852(policyHolder.isOnlineByDefault() ? POLICY_ONLINE : POLICY_OFFLINE);
        } else {
            policyStr.method_10852(UUIDFixerCommand.policyToComponent(policy));
        }
        return policyStr;
    }

    private static int showList(class_2168 commandSourceStack) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        int count = policyHolder.count();
        class_5250 list = (class_5250)UUIDFixerCommand.showDefaultPolicy(policyHolder).get();
        if (count == 0) {
            list.method_27693("\n");
            list.method_10852((class_2561)class_2561.method_43471((String)"mcwifipnp.commands.uuidfixer.none"));
        } else {
            list.method_27693("\n");
            list.method_10852((class_2561)class_2561.method_43469((String)"mcwifipnp.commands.uuidfixer.list", (Object[])new Object[]{policyHolder.count()}));
            for (String playerName : policyHolder.getUsers()) {
                list.method_27693("\n");
                list.method_10852(UUIDFixerCommand.showPolicy(policyHolder, playerName, false));
            }
        }
        commandSourceStack.method_9226(() -> list, false);
        return count;
    }

    private static int testPolicy(class_2168 commandSourceStack, String playerName) {
        UUIDFixer.PolicyHolder policyHolder = new UUIDFixer.PolicyHolder();
        class_2561 component = UUIDFixerCommand.showPolicy(policyHolder, playerName, true);
        commandSourceStack.method_9226(() -> component, false);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$showEnabled$14(class_2561 status) {
        return status;
    }
}

