/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp.network;

import com.dosse.upnp.UPnP;
import io.github.satxm.mcwifipnp.Config;
import io.github.satxm.mcwifipnp.MCWiFiPnPUnit;
import io.github.satxm.mcwifipnp.network.IUPnPProvider;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public record UPnPModule(int port, String displayName) implements Runnable
{
    private static final Logger LOGGER = MCWiFiPnPUnit.LOGGER;

    public static void startIfEnabled(MinecraftServer server, Config cfg) {
        if (!cfg.useUPnP) {
            ((IUPnPProvider)server).setUPnPInstance(null);
            return;
        }
        UPnPModule instance = new UPnPModule(cfg.port, cfg.motd);
        ((IUPnPProvider)server).setUPnPInstance(instance);
        new Thread((Runnable)instance, "MCWiFiPnP_UPnP").start();
    }

    public static boolean has(MinecraftServer server) {
        return ((IUPnPProvider)server).getUPnPInstance() != null;
    }

    public static void stop(MinecraftServer server) {
        UPnPModule uPnPModule = ((IUPnPProvider)server).getUPnPInstance();
        if (uPnPModule != null) {
            uPnPModule.stop();
        }
        ((IUPnPProvider)server).setUPnPInstance(null);
    }

    public void stop() {
        UPnP.closePortTCP(this.port);
        LOGGER.info("Stopped forwarding port " + this.port + ".");
    }

    @Override
    public void run() {
        class_1132 server = class_310.method_1551().method_1576();
        class_3222 player = server.method_3760().method_14602(server.method_43824().id());
        if (UPnP.isUPnPAvailable()) {
            if (UPnP.isMappedTCP(this.port)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.failed.mapped", (Object[])new Object[]{this.port}));
            } else if (UPnP.openPortTCP(this.port, this.displayName)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.success", (Object[])new Object[]{this.port}));
                LOGGER.info("Started forwarded port " + this.port + ".");
            } else {
                player.method_64398((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.failed", (Object[])new Object[]{this.port}));
            }
        } else {
            player.method_64398((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.failed.disabled", (Object[])new Object[]{this.port}));
        }
    }
}

