/*
 * Decompiled with CFR 0.152.
 */
package com.dosse.upnp;

import com.dosse.upnp.Gateway;
import com.dosse.upnp.GatewayFinder;

public class UPnP {
    private static Gateway defaultGW = null;
    private static final String DEFAULT_APP_NAME = "WaifUPnP";
    private static final GatewayFinder finder = new GatewayFinder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gatewayFound(Gateway g) {
            GatewayFinder gatewayFinder = finder;
            synchronized (gatewayFinder) {
                if (defaultGW == null) {
                    defaultGW = g;
                }
            }
        }
    };

    public static void waitInit() {
        while (finder.isSearching()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isUPnPAvailable() {
        UPnP.waitInit();
        return defaultGW != null;
    }

    public static boolean openPortTCP(int port) {
        return UPnP.openPortTCP(port, DEFAULT_APP_NAME);
    }

    public static boolean openPortTCP(int port, String appName) {
        return UPnP.openPortTCP(port, null, appName);
    }

    public static boolean openPortTCP(int port, String remoteHost, String appName) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.openPort(port, remoteHost, false, appName);
    }

    public static boolean openPortUDP(int port) {
        return UPnP.openPortUDP(port, null, DEFAULT_APP_NAME);
    }

    public static boolean openPortUDP(int port, String appName) {
        return UPnP.openPortUDP(port, null, appName);
    }

    public static boolean openPortUDP(int port, String remoteHost, String appName) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.openPort(port, remoteHost, true, appName);
    }

    public static boolean closePortTCP(int port) {
        return UPnP.closePortTCP(port, null);
    }

    public static boolean closePortTCP(int port, String remoteHost) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.closePort(port, remoteHost, false);
    }

    public static boolean closePortUDP(int port) {
        return UPnP.closePortUDP(port, null);
    }

    public static boolean closePortUDP(int port, String remoteHost) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.closePort(port, remoteHost, true);
    }

    public static boolean isMappedTCP(int port) {
        return UPnP.isMappedTCP(port, null);
    }

    public static boolean isMappedTCP(int port, String remoteHost) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.isMapped(port, remoteHost, false);
    }

    public static boolean isMappedUDP(int port) {
        return UPnP.isMappedUDP(port, null);
    }

    public static boolean isMappedUDP(int port, String remoteHost) {
        if (!UPnP.isUPnPAvailable()) {
            return false;
        }
        return defaultGW.isMapped(port, remoteHost, true);
    }

    public static String getExternalIP() {
        if (!UPnP.isUPnPAvailable()) {
            return null;
        }
        return defaultGW.getExternalIP();
    }

    public static String getLocalIP() {
        if (!UPnP.isUPnPAvailable()) {
            return null;
        }
        return defaultGW.getLocalIP();
    }

    public static String getDefaultGatewayIP() {
        if (!UPnP.isUPnPAvailable()) {
            return null;
        }
        return defaultGW.getGatewayIP();
    }
}

