/*
 * Decompiled with CFR 0.152.
 */
package net.plastoid501.collect.gui.widget;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.plastoid501.collect.config.CollectItemConfig;
import net.plastoid501.collect.config.Configs;
import net.plastoid501.collect.config.HotkeyConfig;
import net.plastoid501.collect.config.ModConfig;
import net.plastoid501.collect.config.json.JCollectItemConfig;
import net.plastoid501.collect.gui.ConfigScreen;
import net.plastoid501.collect.gui.ListScreen;
import net.plastoid501.collect.mixin.IScreenMixin;
import net.plastoid501.collect.util.JsonUtil;
import net.plastoid501.collect.util.KeyCodeUtil;
import net.plastoid501.collect.util.NbtUtil;

@Environment(value=EnvType.CLIENT)
public class ConfigWidget
extends class_4265<Entry> {
    final ConfigScreen parent;
    private final class_310 client;
    private final ModConfig CONFIG = Configs.config;

    public ConfigWidget(ConfigScreen parent, class_310 client) {
        super(client, parent.field_22789 + 155, parent.field_22790 - 52, 20, 23);
        this.parent = parent;
        this.client = client;
        this.initEntries(client);
    }

    private void initEntries(class_310 client) {
        if (this.CONFIG != null) {
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)"-- Collect Item --"), client.field_1772));
            Configs.getToggleHotkeys().keySet().forEach(key -> this.method_25321((class_350.class_351)new CollectItemEntry((String)key, this.client.field_1772, this.CONFIG)));
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)""), client.field_1772));
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)"-- List --"), client.field_1772));
            Configs.collectItems.getStacks().keySet().forEach(key -> this.method_25321((class_350.class_351)new ListEntry((String)key, this.client.field_1772, this.CONFIG, this.client, this.parent)));
            this.method_25321((class_350.class_351)new AddListEntry(this.client.field_1772));
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)""), client.field_1772));
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)"-- Hotkey --"), client.field_1772));
            Configs.getHotkeys().keySet().forEach(key -> this.method_25321((class_350.class_351)new HotkeyEntry((String)key, this.client.field_1772, this.CONFIG)));
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)""), client.field_1772));
        }
    }

    public int method_25322() {
        return super.method_25322() + 150;
    }

    public void update() {
        this.updateChildren();
    }

    public void updateChildren() {
        this.method_25396().forEach(Entry::update);
    }

    public class CategoryEntry
    extends Entry {
        private final class_7842 text;
        private final int textWidth;

        CategoryEntry(class_2561 CategoryName, class_327 textRenderer) {
            this.text = new class_7842(CategoryName, textRenderer);
            this.textWidth = this.text.method_25368();
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.text);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.text);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.text.method_48229(ConfigWidget.this.client.field_1755.field_22789 / 2 - this.textWidth / 2, this.method_46427() + 5);
            this.text.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
        }
    }

    public class AddListEntry
    extends Entry {
        private final class_342 listText;
        private final class_4185 addButton;

        AddListEntry(class_327 textRenderer) {
            this.listText = new class_342(textRenderer, 0, 0, 160, 18, (class_2561)class_2561.method_43470((String)""));
            this.listText.method_1852("");
            this.addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Add"), button -> {
                String name = this.listText.method_1882();
                if (name.isEmpty() || name.isBlank()) {
                    return;
                }
                if (ConfigWidget.this.client.field_1687 == null) {
                    return;
                }
                if (NbtUtil.addNewNbtList(name, ConfigWidget.this.client.field_1687.method_30349())) {
                    ((IScreenMixin)((Object)ConfigWidget.this.parent)).collect_items$clearAndInit();
                }
            }).method_46434(0, 0, 60, 20).method_46431();
            boolean bl = this.addButton.field_22763 = ConfigWidget.this.client.field_1687 != null;
            if (!this.addButton.field_22763) {
                this.addButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)"This button is active when joined world")));
            }
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.listText, (Object)this.addButton);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.listText, (Object)this.addButton);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.listText.method_48229(this.method_46426() + 130, this.method_46427() + 1);
            this.listText.method_25394(context, mouseX, mouseY, tickDelta);
            this.addButton.method_48229(this.method_46426() + 293, this.method_46427());
            this.addButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
        }
    }

    public class HotkeyEntry
    extends Entry {
        private final HotkeyConfig defaultConfig;
        private List<String> keys;
        private final class_7842 text;
        private final class_4185 editButton;
        private final class_4185 resetButton;

        HotkeyEntry(String key, class_327 textRenderer, ModConfig config) {
            this.defaultConfig = Configs.getHotkeys().get(key);
            this.keys = config.getHotkeys().get(key).getKeys();
            this.text = new class_7842((class_2561)class_2561.method_43470((String)key), textRenderer);
            this.text.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)Configs.getHotkeys().get(key).getNarrator())));
            this.editButton = class_4185.method_46430((class_2561)this.getKeyBindText(this.keys), button -> {
                ConfigWidget.this.parent.keyBinding = key;
                ConfigWidget.this.parent.keys = new HashSet<Integer>();
                this.update();
            }).method_46437(160, 20).method_46431();
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"RESET"), button -> {
                this.keys = this.defaultConfig.getKeys();
                JsonUtil.updateHotkeyConfig(key, this.keys);
                this.update();
            }).method_46437(40, 20).method_46431();
            this.resetButton.field_22763 = !Objects.equals(this.defaultConfig.getKeys(), this.keys);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.text, (Object)this.editButton, (Object)this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.editButton, (Object)this.resetButton);
        }

        private class_2561 getKeyBindText(List<String> keys) {
            StringBuilder text = new StringBuilder();
            if (keys.isEmpty()) {
                if (!this.text.method_25369().getString().equals(ConfigWidget.this.parent.keyBinding)) {
                    text.append("NONE");
                    return class_2561.method_43470((String)text.toString());
                }
            } else {
                Iterator<String> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    text.append(key);
                    if (!iterator.hasNext()) continue;
                    text.append(" + ");
                }
            }
            if (this.text.method_25369().getString().equals(ConfigWidget.this.parent.keyBinding)) {
                text.insert(0, "> ").append(" <");
            }
            return class_2561.method_43470((String)text.toString());
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.text.method_48229(this.method_46426() - 122, this.method_46427() + 5);
            this.text.method_25394(context, mouseX, mouseY, tickDelta);
            this.editButton.method_48229(this.method_46426() + 153, this.method_46427());
            this.editButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.resetButton.method_48229(this.method_46426() + 316, this.method_46427());
            this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected void update() {
            if (this.text.method_25369().getString().equals(ConfigWidget.this.parent.keyBinding)) {
                this.keys = null;
                Set<Integer> keyCodes = ConfigWidget.this.parent.keys;
                if (!keyCodes.isEmpty() && this.isEnd(ConfigWidget.this.parent.lastKey)) {
                    keyCodes.remove(keyCodes.size() - 1);
                    this.keys = KeyCodeUtil.getKeyForCode(keyCodes);
                    JsonUtil.updateHotkeyConfig(this.text.method_25369().getString(), this.keys);
                    this.editButton.method_25365(false);
                    ConfigWidget.this.parent.keyBinding = null;
                    this.editButton.method_25355(this.getKeyBindText(this.keys));
                    ConfigWidget.this.parent.keys = null;
                } else {
                    this.editButton.method_25355(this.getKeyBindText(KeyCodeUtil.getKeyForCode(keyCodes)));
                }
            } else {
                this.editButton.method_25355(this.getKeyBindText(this.keys));
            }
            this.resetButton.field_22763 = !Objects.equals(this.defaultConfig.getKeys(), this.keys);
        }

        private boolean isEnd(int keyCode) {
            return keyCode == 256 || keyCode == 0 || keyCode == 1;
        }
    }

    public class ListEntry
    extends Entry {
        private final class_7842 listText;
        private final class_4185 detailButton;
        private final class_4185 removeButton;

        ListEntry(String key, class_327 textRenderer, ModConfig config, class_310 client, class_437 parent) {
            this.listText = new class_7842((class_2561)class_2561.method_43470((String)key), textRenderer);
            this.detailButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Details"), button -> {
                if (client != null) {
                    JsonUtil.updateConfigs();
                    client.method_1507((class_437)new ListScreen(parent, key));
                }
            }).method_46437(60, 20).method_46431();
            this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), button -> {
                if (ConfigWidget.this.client.field_1687 == null) {
                    return;
                }
                if (NbtUtil.removeNbtList(key, ConfigWidget.this.client.field_1687.method_30349())) {
                    ((IScreenMixin)parent).collect_items$clearAndInit();
                }
            }).method_46437(60, 20).method_46431();
            this.detailButton.field_22763 = ConfigWidget.this.client.field_1687 != null;
            boolean bl = this.removeButton.field_22763 = ConfigWidget.this.client.field_1687 != null;
            if (!this.detailButton.field_22763) {
                this.detailButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)"This button is active when joined world")));
            }
            if (!this.removeButton.field_22763) {
                this.removeButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)"This button is active when joined world")));
            }
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.listText, (Object)this.detailButton, (Object)this.removeButton);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.detailButton, (Object)this.removeButton);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.listText.method_48229(this.method_46426() - 122, this.method_46427() + 5);
            this.listText.method_25394(context, mouseX, mouseY, tickDelta);
            this.detailButton.method_48229(this.method_46426() + 230, this.method_46427());
            this.detailButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.removeButton.method_48229(this.method_46426() + 293, this.method_46427());
            this.removeButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
        }
    }

    public class CollectItemEntry
    extends Entry {
        private final CollectItemConfig defaultConfig;
        private boolean enable;
        private List<String> keys;
        private int selected;
        private List<String> list;
        private final class_7842 text;
        private final class_4185 enableButton;
        private final class_4185 toggleButton;
        private final class_4185 editButton;
        private final class_4185 resetButton;

        CollectItemEntry(String key, class_327 textRenderer, ModConfig config) {
            this.defaultConfig = Configs.getToggleHotkeys().get(key);
            this.enable = Configs.collectItems.isEnable();
            this.keys = Configs.collectItems.getKeys();
            this.list = Configs.collectItems.getStacks().keySet().stream().toList();
            this.selected = this.list.indexOf(Configs.collectItems.getSelected());
            this.text = new class_7842((class_2561)class_2561.method_43470((String)key), textRenderer);
            this.text.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)Configs.getToggleHotkeys().get(key).getNarrator())));
            this.enableButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(this.enable)).method_10862(class_2583.field_24360.method_36139(this.enable ? Color.GREEN.getRGB() : Color.red.getRGB())), button -> {
                this.enable = !this.enable;
                JsonUtil.updateThrowItemConfig(key, new JCollectItemConfig(this.enable, this.keys, this.list.get(this.selected)));
                this.update();
            }).method_46437(60, 20).method_46431();
            this.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.list.get(this.selected)), button -> {
                this.selected = this.selected + 1 >= this.list.size() ? 0 : this.selected + 1;
                JsonUtil.updateThrowItemConfig(key, new JCollectItemConfig(this.enable, this.keys, this.list.get(this.selected)));
                this.update();
            }).method_46437(60, 20).method_46431();
            this.editButton = class_4185.method_46430((class_2561)this.getKeyBindText(this.keys), button -> {
                ConfigWidget.this.parent.keyBinding = key;
                ConfigWidget.this.parent.keys = new HashSet<Integer>();
                this.update();
            }).method_46437(160, 20).method_46431();
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"RESET"), button -> {
                this.enable = this.defaultConfig.isEnable();
                this.keys = this.defaultConfig.getKeys();
                this.selected = this.list.indexOf(Configs.collectItems.getSelected());
                JsonUtil.updateThrowItemConfig(key, new JCollectItemConfig(this.enable, this.keys, this.list.get(this.selected)));
                this.update();
            }).method_46437(40, 20).method_46431();
            this.resetButton.field_22763 = this.defaultConfig.isEnable() != this.enable || !Objects.equals(this.defaultConfig.getKeys(), this.keys);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.text, (Object)this.enableButton, (Object)this.toggleButton, (Object)this.editButton, (Object)this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.enableButton, (Object)this.toggleButton, (Object)this.editButton, (Object)this.resetButton);
        }

        private class_2561 getKeyBindText(List<String> keys) {
            StringBuilder text = new StringBuilder();
            if (keys.isEmpty()) {
                if (!this.text.method_25369().getString().equals(ConfigWidget.this.parent.keyBinding)) {
                    text.append("NONE");
                    return class_2561.method_43470((String)text.toString());
                }
            } else {
                Iterator<String> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    text.append(key);
                    if (!iterator.hasNext()) continue;
                    text.append(" + ");
                }
            }
            if (this.text.method_25369().getString().equals(ConfigWidget.this.parent.keyBinding)) {
                text.insert(0, "> ").append(" <");
            }
            return class_2561.method_43470((String)text.toString());
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.text.method_48229(this.method_46426() - 122, this.method_46427() + 5);
            this.text.method_25394(context, mouseX, mouseY, tickDelta);
            this.enableButton.method_48229(this.method_46426() + 27, this.method_46427());
            this.enableButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.toggleButton.method_48229(this.method_46426() + 90, this.method_46427());
            this.toggleButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.editButton.method_48229(this.method_46426() + 153, this.method_46427());
            this.editButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.resetButton.method_48229(this.method_46426() + 316, this.method_46427());
            this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
            this.enableButton.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.enable)).method_10862(class_2583.field_24360.method_36139(this.enable ? Color.GREEN.getRGB() : Color.red.getRGB())));
            this.toggleButton.method_25355((class_2561)class_2561.method_43470((String)this.list.get(this.selected)));
            if (this.text.method_25369().getString().equals(ConfigWidget.this.parent.keyBinding)) {
                this.keys = null;
                Set<Integer> keyCodes = ConfigWidget.this.parent.keys;
                if (!keyCodes.isEmpty() && this.isEnd(ConfigWidget.this.parent.lastKey)) {
                    keyCodes.remove(keyCodes.size() - 1);
                    this.keys = KeyCodeUtil.getKeyForCode(keyCodes);
                    JsonUtil.updateThrowItemConfig(this.text.method_25369().getString(), new JCollectItemConfig(this.enable, this.keys, this.list.get(this.selected)));
                    this.editButton.method_25365(false);
                    ConfigWidget.this.parent.keyBinding = null;
                    this.editButton.method_25355(this.getKeyBindText(this.keys));
                    ConfigWidget.this.parent.keys = null;
                } else {
                    this.editButton.method_25355(this.getKeyBindText(KeyCodeUtil.getKeyForCode(keyCodes)));
                }
            } else {
                this.editButton.method_25355(this.getKeyBindText(this.keys));
            }
            this.resetButton.field_22763 = this.defaultConfig.isEnable() != this.enable || !Objects.equals(this.defaultConfig.getKeys(), this.keys);
        }

        private boolean isEnd(int keyCode) {
            return keyCode == 256 || keyCode == 0 || keyCode == 1;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        abstract void update();
    }
}

