/*
 * Decompiled with CFR 0.152.
 */
package net.plastoid501.collect.gui.widget;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7923;
import net.plastoid501.collect.config.Configs;
import net.plastoid501.collect.config.ModConfig;
import net.plastoid501.collect.gui.ItemListScreen;
import net.plastoid501.collect.gui.ListScreen;
import net.plastoid501.collect.util.ItemUtil;
import net.plastoid501.collect.util.JsonUtil;
import net.plastoid501.collect.util.NbtUtil;

public class ListWidget
extends class_4265<Entry> {
    final ListScreen parent;
    private final class_310 client;

    public ListWidget(ListScreen parent, class_310 client, String listName) {
        super(client, parent.field_22789 + 45, parent.field_22790 - 80, 48, 23);
        this.parent = parent;
        this.client = client;
        this.initEntries(client, listName);
    }

    private void initEntries(class_310 client, String listName) {
        ModConfig config = JsonUtil.readConfig();
        if (config != null) {
            String search = ListScreen.searchBox.method_1882();
            this.method_25321((class_350.class_351)new CategoryEntry(this, (class_2561)class_2561.method_43470((String)("-- " + listName + " --")), client.field_1772));
            for (class_1799 stack : Configs.collectItems.getStacks().get(listName)) {
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                if (!search.isEmpty() && !itemId.contains(search)) continue;
                this.method_25321((class_350.class_351)new ItemEntry((class_2561)class_2561.method_43470((String)itemId), stack, client.field_1772, config, listName));
            }
            this.method_25321((class_350.class_351)new CategoryEntry(this, (class_2561)class_2561.method_43470((String)""), client.field_1772));
        }
    }

    public int method_25322() {
        return super.method_25322() + 250;
    }

    public class CategoryEntry
    extends Entry {
        private final class_7842 categoryText;

        CategoryEntry(ListWidget this$0, class_2561 CategoryName, class_327 textRenderer) {
            this.categoryText = new class_7842(CategoryName, textRenderer);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.categoryText);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.categoryText);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.categoryText.method_48229(this.method_46426() + 170, this.method_46427() + 5);
            this.categoryText.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
        }
    }

    public class ItemEntry
    extends Entry {
        private final class_1799 stack;
        private final class_7842 itemText;
        private final String listName;
        private final class_4185 addButton;
        private final class_4185 removeButton;
        private final class_327 textRenderer;

        ItemEntry(class_2561 itemId, class_1799 stack, class_327 textRenderer, ModConfig config, String listName) {
            this.textRenderer = textRenderer;
            this.stack = stack;
            this.itemText = new class_7842(itemId, this.textRenderer);
            this.listName = listName;
            this.addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), button -> {
                if (!ItemUtil.contains((Collection<? extends class_1799>)Configs.collectItems.getStacks().get(this.listName), stack) && ListWidget.this.client.field_1687 != null) {
                    NbtUtil.addItemStack(stack, ListWidget.this.client.field_1687.method_30349());
                    ItemListScreen.update();
                    this.update();
                }
            }).method_46434(0, 0, 50, 20).method_46431();
            this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), button -> {
                int index = ItemUtil.indexOf((Collection<? extends class_1799>)Configs.collectItems.getStacks().get(this.listName), stack);
                if (index != -1 && ListWidget.this.client.field_1687 != null) {
                    NbtUtil.removeItemStack(index, ListWidget.this.client.field_1687.method_30349());
                    ItemListScreen.update();
                    this.update();
                }
            }).method_46434(0, 0, 50, 20).method_46431();
            this.addButton.field_22763 = !ItemUtil.contains((Collection<? extends class_1799>)Configs.collectItems.getStacks().get(this.listName), stack);
            this.removeButton.field_22763 = ItemUtil.contains((Collection<? extends class_1799>)Configs.collectItems.getStacks().get(this.listName), stack);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.itemText, (Object)this.addButton, (Object)this.removeButton);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.addButton, (Object)this.removeButton);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_51427(this.stack, this.method_46426() + 18, this.method_46427() + 2);
            if (this.method_46426() + 18 <= mouseX && mouseX <= this.method_46426() + 18 + 16 && this.method_46427() + 2 <= mouseY && mouseY <= this.method_46427() + 2 + 16) {
                context.method_51446(this.textRenderer, this.stack, mouseX, mouseY);
            }
            this.itemText.method_48229(this.method_46426() + 38, this.method_46427() + 5);
            this.itemText.method_25394(context, mouseX, mouseY, tickDelta);
            this.addButton.method_48229(this.method_46426() + 332, this.method_46427());
            this.addButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.removeButton.method_48229(this.method_46426() + 385, this.method_46427());
            this.removeButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
            if (ItemUtil.contains((Collection<? extends class_1799>)Configs.collectItems.getStacks().get(this.listName), this.stack)) {
                this.addButton.field_22763 = false;
                this.removeButton.field_22763 = true;
            } else {
                this.addButton.field_22763 = true;
                this.removeButton.field_22763 = false;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        abstract void update();
    }
}

