/*
 * Decompiled with CFR 0.152.
 */
package net.plastoid501.collect.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public class KeyCodeUtil {
    private static final Map<String, Integer> keyNameToCodeMap = new HashMap<String, Integer>();
    private static final Map<Integer, String> keyCodeToNameMap = new HashMap<Integer, String>();
    private static final List<Integer> pressedKeys = new ArrayList<Integer>();
    public static List<Integer> lastPressedKeys = new ArrayList<Integer>();

    public static List<Integer> getCodeForKey(Collection<String> keyNames) {
        ArrayList<Integer> keyCodes = new ArrayList<Integer>();
        for (String keyName : keyNames) {
            keyCodes.add(keyNameToCodeMap.get(keyName));
        }
        return keyCodes;
    }

    public static String getKeyForCode(int keyCode) {
        return keyCodeToNameMap.get(keyCode);
    }

    public static List<String> getKeyForCode(Collection<Integer> keyCodes) {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Integer keyCode : keyCodes) {
            keyNames.add(keyCodeToNameMap.get(keyCode));
        }
        return keyNames;
    }

    public static List<Integer> getAllKeyCode() {
        return new ArrayList<Integer>(keyNameToCodeMap.values());
    }

    public static boolean updateKeyStatus() {
        lastPressedKeys = new ArrayList<Integer>(pressedKeys);
        boolean isChange = false;
        for (Integer keyCode : lastPressedKeys) {
            if (keyCode <= 7) {
                if (KeyCodeUtil.isMousePressed(keyCode)) continue;
                pressedKeys.remove(keyCode);
                isChange = true;
                continue;
            }
            if (KeyCodeUtil.isKeyPressed(keyCode)) continue;
            pressedKeys.remove(keyCode);
            isChange = true;
        }
        return isChange;
    }

    public static void add(int value) {
        lastPressedKeys = new ArrayList<Integer>(pressedKeys);
        if (!pressedKeys.contains(value)) {
            pressedKeys.add(value);
        }
    }

    public static void remove(int value) {
        lastPressedKeys = new ArrayList<Integer>(pressedKeys);
        pressedKeys.remove((Object)value);
    }

    public static boolean isKeyPressed(int keyCode) {
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)keyCode);
    }

    public static boolean isMousePressed(int button) {
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        GLFW.glfwMakeContextCurrent((long)windowHandle);
        return GLFW.glfwGetMouseButton((long)windowHandle, (int)button) == 1;
    }

    public static List<Integer> getPressedKeys() {
        return pressedKeys;
    }

    public static List<Integer> getLastPressedKeys() {
        return lastPressedKeys;
    }

    public static boolean matchKeyCodes(List<Integer> keyCodes) {
        return !keyCodes.isEmpty() && KeyCodeUtil.getPressedKeys().size() == keyCodes.size() && new HashSet<Integer>(KeyCodeUtil.getPressedKeys()).containsAll(keyCodes);
    }

    static {
        keyNameToCodeMap.put("BUTTON_LEFT", 0);
        keyNameToCodeMap.put("BUTTON_RIGHT", 1);
        keyNameToCodeMap.put("BUTTON_MIDDLE", 2);
        keyNameToCodeMap.put("BUTTON_4", 3);
        keyNameToCodeMap.put("BUTTON_5", 4);
        keyNameToCodeMap.put("BUTTON_6", 5);
        keyNameToCodeMap.put("BUTTON_7", 6);
        keyNameToCodeMap.put("BUTTON_8", 7);
        keyNameToCodeMap.put("0", 48);
        keyNameToCodeMap.put("1", 49);
        keyNameToCodeMap.put("2", 50);
        keyNameToCodeMap.put("3", 51);
        keyNameToCodeMap.put("4", 52);
        keyNameToCodeMap.put("5", 53);
        keyNameToCodeMap.put("6", 54);
        keyNameToCodeMap.put("7", 55);
        keyNameToCodeMap.put("8", 56);
        keyNameToCodeMap.put("9", 57);
        keyNameToCodeMap.put("A", 65);
        keyNameToCodeMap.put("B", 66);
        keyNameToCodeMap.put("C", 67);
        keyNameToCodeMap.put("D", 68);
        keyNameToCodeMap.put("E", 69);
        keyNameToCodeMap.put("F", 70);
        keyNameToCodeMap.put("G", 71);
        keyNameToCodeMap.put("H", 72);
        keyNameToCodeMap.put("I", 73);
        keyNameToCodeMap.put("J", 74);
        keyNameToCodeMap.put("K", 75);
        keyNameToCodeMap.put("L", 76);
        keyNameToCodeMap.put("M", 77);
        keyNameToCodeMap.put("N", 78);
        keyNameToCodeMap.put("O", 79);
        keyNameToCodeMap.put("P", 80);
        keyNameToCodeMap.put("Q", 81);
        keyNameToCodeMap.put("R", 82);
        keyNameToCodeMap.put("S", 83);
        keyNameToCodeMap.put("T", 84);
        keyNameToCodeMap.put("U", 85);
        keyNameToCodeMap.put("V", 86);
        keyNameToCodeMap.put("W", 87);
        keyNameToCodeMap.put("X", 88);
        keyNameToCodeMap.put("Y", 89);
        keyNameToCodeMap.put("Z", 90);
        keyNameToCodeMap.put("F1", 290);
        keyNameToCodeMap.put("F2", 291);
        keyNameToCodeMap.put("F3", 292);
        keyNameToCodeMap.put("F4", 293);
        keyNameToCodeMap.put("F5", 294);
        keyNameToCodeMap.put("F6", 295);
        keyNameToCodeMap.put("F7", 296);
        keyNameToCodeMap.put("F8", 297);
        keyNameToCodeMap.put("F9", 298);
        keyNameToCodeMap.put("F10", 299);
        keyNameToCodeMap.put("F11", 300);
        keyNameToCodeMap.put("F12", 301);
        keyNameToCodeMap.put("F13", 302);
        keyNameToCodeMap.put("F14", 303);
        keyNameToCodeMap.put("F15", 304);
        keyNameToCodeMap.put("F16", 305);
        keyNameToCodeMap.put("F17", 306);
        keyNameToCodeMap.put("F18", 307);
        keyNameToCodeMap.put("F19", 308);
        keyNameToCodeMap.put("F20", 309);
        keyNameToCodeMap.put("F21", 310);
        keyNameToCodeMap.put("F22", 311);
        keyNameToCodeMap.put("F23", 312);
        keyNameToCodeMap.put("F24", 313);
        keyNameToCodeMap.put("F25", 314);
        keyNameToCodeMap.put("NUM_LOCK", 282);
        keyNameToCodeMap.put("KP_0", 320);
        keyNameToCodeMap.put("KP_1", 321);
        keyNameToCodeMap.put("KP_2", 322);
        keyNameToCodeMap.put("KP_3", 323);
        keyNameToCodeMap.put("KP_4", 324);
        keyNameToCodeMap.put("KP_5", 325);
        keyNameToCodeMap.put("KP_6", 326);
        keyNameToCodeMap.put("KP_7", 327);
        keyNameToCodeMap.put("KP_8", 328);
        keyNameToCodeMap.put("KP_9", 329);
        keyNameToCodeMap.put("KP_ADD", 334);
        keyNameToCodeMap.put("KP_DECIMAL", 330);
        keyNameToCodeMap.put("KP_ENTER", 335);
        keyNameToCodeMap.put("KP_EQUAL", 336);
        keyNameToCodeMap.put("KP_MULTIPLY", 332);
        keyNameToCodeMap.put("KP_DIVIDE", 331);
        keyNameToCodeMap.put("KP_SUBTRACT", 333);
        keyNameToCodeMap.put("DOWN", 264);
        keyNameToCodeMap.put("LEFT", 263);
        keyNameToCodeMap.put("RIGHT", 262);
        keyNameToCodeMap.put("UP", 265);
        keyNameToCodeMap.put("APOSTROPHE", 39);
        keyNameToCodeMap.put("BACKSLASH", 92);
        keyNameToCodeMap.put("COMMA", 44);
        keyNameToCodeMap.put("EQUAL", 61);
        keyNameToCodeMap.put("GRAVE_ACCENT", 96);
        keyNameToCodeMap.put("LEFT_BRACKET", 91);
        keyNameToCodeMap.put("MINUS", 45);
        keyNameToCodeMap.put("PERIOD", 46);
        keyNameToCodeMap.put("RIGHT_BRACKET", 93);
        keyNameToCodeMap.put("SEMICOLON", 59);
        keyNameToCodeMap.put("SLASH", 47);
        keyNameToCodeMap.put("SPACE", 32);
        keyNameToCodeMap.put("TAB", 258);
        keyNameToCodeMap.put("LEFT_ALT", 342);
        keyNameToCodeMap.put("LEFT_CONTROL", 341);
        keyNameToCodeMap.put("LEFT_SHIFT", 340);
        keyNameToCodeMap.put("LEFT_WIN", 343);
        keyNameToCodeMap.put("RIGHT_ALT", 346);
        keyNameToCodeMap.put("RIGHT_CONTROL", 345);
        keyNameToCodeMap.put("RIGHT_SHIFT", 344);
        keyNameToCodeMap.put("RIGHT_WIN", 347);
        keyNameToCodeMap.put("ENTER", 257);
        keyNameToCodeMap.put("ESCAPE", 256);
        keyNameToCodeMap.put("BACKSPACE", 259);
        keyNameToCodeMap.put("DELETE", 261);
        keyNameToCodeMap.put("END", 269);
        keyNameToCodeMap.put("HOME", 268);
        keyNameToCodeMap.put("INSERT", 260);
        keyNameToCodeMap.put("PAGE_DOWN", 267);
        keyNameToCodeMap.put("PAGE_UP", 266);
        keyNameToCodeMap.put("CAPS_LOCK", 280);
        keyNameToCodeMap.put("PAUSE", 284);
        keyNameToCodeMap.put("SCROLL_LOCK", 281);
        keyNameToCodeMap.put("MENU", 348);
        keyNameToCodeMap.put("PRINT_SCREEN", 283);
        keyNameToCodeMap.put("WORLD_1", 161);
        keyNameToCodeMap.put("WORLD_2", 162);
        for (Map.Entry<String, Integer> entry : keyNameToCodeMap.entrySet()) {
            keyCodeToNameMap.put(entry.getValue(), entry.getKey());
        }
    }
}

