/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.worldgen;

import com.mojang.serialization.Codec;
import de.larsensmods.stl_backport.worldgen.FallenTreeFeatureConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3746;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FallenTreeFeature
extends class_3031<FallenTreeFeatureConfig> {
    public FallenTreeFeature(Codec<FallenTreeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<FallenTreeFeatureConfig> placeContext) {
        this.placeFallenTree((FallenTreeFeatureConfig)placeContext.method_33656(), placeContext.method_33655(), placeContext.method_33652(), placeContext.method_33654());
        return true;
    }

    private void placeFallenTree(FallenTreeFeatureConfig config, class_2338 pos, class_5281 level, class_5819 randomSource) {
        this.placeStump(config, level, randomSource, pos.method_25503());
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(randomSource);
        int length = config.logLength.method_35008(randomSource) - 2;
        class_2338.class_2339 mutableBlockPos = pos.method_10079(direction, 2 + randomSource.method_43048(2)).method_25503();
        this.setGroundHeightForFallenLogStartPos(level, mutableBlockPos);
        if (this.canPlaceEntireFallenLog(level, length, mutableBlockPos, direction)) {
            this.placeFallenLog(config, level, randomSource, length, mutableBlockPos, direction);
        }
    }

    private void setGroundHeightForFallenLogStartPos(class_5281 level, class_2338.class_2339 mutableBlockPos) {
        mutableBlockPos.method_10104(class_2350.field_11036, 1);
        for (int i = 0; i < 6; ++i) {
            if (this.mayPlaceOn((class_1936)level, (class_2338)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
    }

    private void placeStump(FallenTreeFeatureConfig config, class_5281 level, class_5819 randomSource, class_2338.class_2339 mutableBlockPos) {
        class_2338 blockPos = this.placeLogBlock(config, level, randomSource, mutableBlockPos, Function.identity());
        this.decorateLogs(level, randomSource, Set.of(blockPos), config.stumpDecorators);
    }

    private boolean canPlaceEntireFallenLog(class_5281 level, int length, class_2338.class_2339 mutableBlockPos, class_2350 direction) {
        int suspendedLogs = 0;
        for (int i = 0; i < length; ++i) {
            if (!class_2944.method_27371((class_3746)level, (class_2338)mutableBlockPos)) {
                return false;
            }
            if (!this.isOverSolidGround((class_1936)level, (class_2338)mutableBlockPos)) {
                if (++suspendedLogs > 2) {
                    return false;
                }
            } else {
                suspendedLogs = 0;
            }
            mutableBlockPos.method_10098(direction);
        }
        mutableBlockPos.method_10104(direction.method_10153(), length);
        return true;
    }

    private void placeFallenLog(FallenTreeFeatureConfig config, class_5281 level, class_5819 randomSource, int length, class_2338.class_2339 mutableBlockPos, class_2350 direction) {
        HashSet<class_2338> fallenLogPositions = new HashSet<class_2338>();
        for (int i = 0; i < length; ++i) {
            fallenLogPositions.add(this.placeLogBlock(config, level, randomSource, mutableBlockPos, FallenTreeFeature.getSidewaysStateModifier(direction)));
            mutableBlockPos.method_10098(direction);
        }
        this.decorateLogs(level, randomSource, fallenLogPositions, config.logDecorators);
    }

    private boolean mayPlaceOn(class_1936 level, class_2338 pos) {
        return class_2944.method_27371((class_3746)level, (class_2338)pos) && this.isOverSolidGround(level, pos);
    }

    private boolean isOverSolidGround(class_1936 level, class_2338 pos) {
        return level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos, class_2350.field_11036);
    }

    private class_2338 placeLogBlock(FallenTreeFeatureConfig config, class_5281 level, class_5819 randomSource, class_2338.class_2339 mutableBlockPos, Function<class_2680, class_2680> blockStateModifier) {
        level.method_8652((class_2338)mutableBlockPos, blockStateModifier.apply(config.trunkProvider.method_23455(randomSource, (class_2338)mutableBlockPos)), 3);
        class_2338 below = mutableBlockPos.method_10074();
        if (level.method_8320(below).method_27852(class_2246.field_10219)) {
            level.method_8652(below, class_2246.field_10566.method_9564(), 3);
        }
        this.method_37256(level, (class_2338)mutableBlockPos);
        return mutableBlockPos.method_10062();
    }

    private void decorateLogs(class_5281 level, class_5819 randomSource, Set<class_2338> logPositions, List<class_4662> treeDecorators) {
        if (!treeDecorators.isEmpty()) {
            class_4662.class_7402 decoratorContext = new class_4662.class_7402((class_3746)level, this.getDecorationSetter(level), randomSource, logPositions, Set.of(), Set.of());
            treeDecorators.forEach(decorator -> decorator.method_23469(decoratorContext));
        }
    }

    private BiConsumer<class_2338, class_2680> getDecorationSetter(class_5281 level) {
        return (pos, state) -> level.method_8652(pos, state, 19);
    }

    private static Function<class_2680, class_2680> getSidewaysStateModifier(class_2350 direction) {
        return original -> (class_2680)original.method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166());
    }
}

