/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class STLBushBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);

    protected STLBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.getValidSpreadPos(Direction.Plane.HORIZONTAL.m_122557_().toList(), level, pos, state).isPresent();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState state) {
        Optional<BlockPos> neighbourPos = this.getValidSpreadPos(Direction.Plane.HORIZONTAL.m_235694_(level.f_46441_), (LevelReader)level, blockPos, state);
        neighbourPos.ifPresent(pos -> level.m_46597_(pos, this.m_49966_()));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    private Optional<BlockPos> getValidSpreadPos(List<Direction> directions, LevelReader levelReader, BlockPos blockPos, BlockState state) {
        for (Direction dir : directions) {
            BlockPos pos = blockPos.m_121945_(dir);
            if (!levelReader.m_46859_(pos) || !state.m_60710_(levelReader, pos)) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }
}

