/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.block;

import de.larsensmods.stl_backport.audio.STLSoundEvents;
import de.larsensmods.stl_backport.particles.STLParticleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class STLFireflyBushBlock
extends BushBlock
implements BonemealableBlock {
    public STLFireflyBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(30) == 0 && this.isMoonVisible(level) && level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_()) {
            level.m_245747_(pos, STLSoundEvents.FIREFLY_BUSH_IDLE.get(), SoundSource.AMBIENT, 0.6f, 1.0f, false);
        }
        level.m_46465_();
        if (level.m_46803_(pos) <= 13 && random.m_188500_() <= 0.7) {
            double partX = (double)pos.m_123341_() + random.m_188500_() * 10.0 - 5.0;
            double partY = (double)pos.m_123342_() + random.m_188500_() * 5.0;
            double partZ = (double)pos.m_123343_() + random.m_188500_() * 10.0 - 5.0;
            level.m_7106_((ParticleOptions)STLParticleTypes.FIREFLY.get(), partX, partY, partZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.getValidSpreadPos(Direction.Plane.HORIZONTAL.m_122557_().toList(), level, pos, state).isPresent();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState state) {
        Optional<BlockPos> neighbourPos = this.getValidSpreadPos(Direction.Plane.HORIZONTAL.m_235694_(level.f_46441_), (LevelReader)level, blockPos, state);
        neighbourPos.ifPresent(pos -> level.m_46597_(pos, this.m_49966_()));
    }

    private boolean isMoonVisible(Level level) {
        if (!level.m_6042_().f_63858_()) {
            return false;
        }
        int time = (int)(level.m_46468_() % 24000L);
        return time >= 12600 && time <= 23400;
    }

    private Optional<BlockPos> getValidSpreadPos(List<Direction> directions, LevelReader levelReader, BlockPos blockPos, BlockState state) {
        for (Direction dir : directions) {
            BlockPos pos = blockPos.m_121945_(dir);
            if (!levelReader.m_46859_(pos) || !state.m_60710_(levelReader, pos)) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }
}

