/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.block;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SegmentableBlock {
    public static final IntegerProperty SEGMENT_AMOUNT;
    public static final IntegerProperty AMOUNT;

    default public Function<BlockState, VoxelShape> getShapeCalculator(EnumProperty<Direction> directionProperty, IntegerProperty segments) {
        EnumMap shapes = Maps.newEnumMap(Map.of(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)this.getShapeHeight(), (double)8.0), Direction.EAST, Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)this.getShapeHeight(), (double)8.0), Direction.SOUTH, Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)this.getShapeHeight(), (double)16.0), Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)this.getShapeHeight(), (double)16.0)));
        return state -> {
            VoxelShape resultShape = Shapes.m_83040_();
            Direction resultDirection = (Direction)state.m_61143_((Property)directionProperty);
            int segmentCount = (Integer)state.m_61143_((Property)segments);
            for (int i = 0; i < segmentCount; ++i) {
                resultShape = Shapes.m_83110_((VoxelShape)resultShape, (VoxelShape)((VoxelShape)shapes.get(resultDirection)));
                resultDirection = resultDirection.m_122428_();
            }
            return resultShape.m_83281_() ? Shapes.m_83040_() : Shapes.m_83048_((double)resultShape.m_83288_(Direction.Axis.X), (double)resultShape.m_83288_(Direction.Axis.Y), (double)resultShape.m_83288_(Direction.Axis.Z), (double)resultShape.m_83297_(Direction.Axis.X), (double)resultShape.m_83297_(Direction.Axis.Y), (double)resultShape.m_83297_(Direction.Axis.Z));
        };
    }

    default public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    default public double getShapeHeight() {
        return 1.0;
    }

    default public boolean canBeReplaced(BlockState state, BlockPlaceContext placeContext, IntegerProperty segments) {
        return !placeContext.m_7078_() && placeContext.m_43722_().m_150930_(state.m_60734_().m_5456_()) && (Integer)state.m_61143_((Property)segments) < 4;
    }

    default public BlockState getStateForPlacement(BlockPlaceContext placeContext, Block block, IntegerProperty segments, EnumProperty<Direction> direction) {
        BlockState state = placeContext.m_43725_().m_8055_(placeContext.m_8083_());
        return state.m_60713_(block) ? (BlockState)state.m_61124_((Property)segments, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.m_61143_((Property)segments) + 1))) : (BlockState)block.m_49966_().m_61124_(direction, (Comparable)placeContext.m_8125_().m_122424_());
    }

    static {
        AMOUNT = SEGMENT_AMOUNT = IntegerProperty.m_61631_((String)"segment_amount", (int)1, (int)4);
    }
}

