/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.forge.event;

import de.larsensmods.stl_backport.SpringToLifeMod;
import de.larsensmods.stl_backport.block.STLBlocks;
import de.larsensmods.stl_backport.entity.STLEntityTypes;
import de.larsensmods.stl_backport.entity.client.ColdChickenModel;
import de.larsensmods.stl_backport.entity.client.ColdChickenRenderer;
import de.larsensmods.stl_backport.entity.client.ColdCowModel;
import de.larsensmods.stl_backport.entity.client.ColdCowRenderer;
import de.larsensmods.stl_backport.entity.client.ColdPigModel;
import de.larsensmods.stl_backport.entity.client.ColdPigRenderer;
import de.larsensmods.stl_backport.entity.client.STLModelLayers;
import de.larsensmods.stl_backport.entity.client.WarmChickenRenderer;
import de.larsensmods.stl_backport.entity.client.WarmCowModel;
import de.larsensmods.stl_backport.entity.client.WarmCowRenderer;
import de.larsensmods.stl_backport.entity.client.WarmPigModel;
import de.larsensmods.stl_backport.entity.client.WarmPigRenderer;
import de.larsensmods.stl_backport.item.STLItems;
import de.larsensmods.stl_backport.particles.STLParticleTypes;
import de.larsensmods.stl_backport.particles.client.FallingLeavesParticle;
import de.larsensmods.stl_backport.particles.client.FireflyParticle;
import de.larsensmods.stl_backport.util.ClientColorUtils;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="spring_to_life", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_(STLEntityTypes.WARM_CHICKEN.get(), WarmChickenRenderer::new);
        EntityRenderers.m_174036_(STLEntityTypes.COLD_CHICKEN.get(), ColdChickenRenderer::new);
        EntityRenderers.m_174036_(STLEntityTypes.WARM_PIG.get(), WarmPigRenderer::new);
        EntityRenderers.m_174036_(STLEntityTypes.COLD_PIG.get(), ColdPigRenderer::new);
        EntityRenderers.m_174036_(STLEntityTypes.WARM_COW.get(), WarmCowRenderer::new);
        EntityRenderers.m_174036_(STLEntityTypes.COLD_COW.get(), ColdCowRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(STLModelLayers.WARM_CHICKEN, ChickenModel::m_170491_);
        event.registerLayerDefinition(STLModelLayers.COLD_CHICKEN, ColdChickenModel::createBodyLayer);
        event.registerLayerDefinition(STLModelLayers.WARM_PIG, () -> WarmPigModel.m_170800_((CubeDeformation)CubeDeformation.f_171458_));
        event.registerLayerDefinition(STLModelLayers.COLD_PIG, ColdPigModel::createBodyLayer);
        event.registerLayerDefinition(STLModelLayers.WARM_COW, WarmCowModel::createBodyLayer);
        event.registerLayerDefinition(STLModelLayers.COLD_COW, ColdCowModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerColorResolvers(RegisterColorHandlersEvent.ColorResolvers event) {
        event.register(ClientColorUtils.DRY_FOLIAGE_COLOR_RESOLVER);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? SpringToLifeMod.getColorUtils().getAverageDryFoliageColor(level, pos) : -10732494, new Block[]{STLBlocks.LEAF_LITTER.get()});
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return level != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.m_276205_();
            }
            return -1;
        }, new Block[]{STLBlocks.WILDFLOWERS.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.m_276205_(), new Block[]{STLBlocks.BUSH.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> GrassColor.m_276205_(), new ItemLike[]{(ItemLike)STLItems.BUSH.get()});
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet(STLParticleTypes.TINTED_LEAVES.get(), FallingLeavesParticle.TintedLeavesProvider::new);
        event.registerSpriteSet((ParticleType)STLParticleTypes.FIREFLY.get(), FireflyParticle.FireflyProvider::new);
    }
}

