/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.forge.register;

import com.mojang.serialization.Codec;
import de.larsensmods.regutil.IRegistrationProvider;
import de.larsensmods.stl_backport.SpringToLifeMod;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;

public class ForgeRegistrationProvider
implements IRegistrationProvider {
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"spring_to_life");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"spring_to_life");
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"spring_to_life");
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"spring_to_life");
    private static final DeferredRegister<SoundEvent> SOUND_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256840_, (String)"spring_to_life");
    private static final DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256833_, (String)"spring_to_life");
    private static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATOR_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256845_, (String)"spring_to_life");
    private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256890_, (String)"spring_to_life");
    private final Map<String, Object> overrideKeys = new HashMap<String, Object>();
    private final IEventBus bus;

    public ForgeRegistrationProvider(IEventBus bus) {
        this.bus = bus;
    }

    public void addOverrideKey(String key, Object value) {
        this.overrideKeys.put(key, value);
    }

    @Override
    public Supplier<Block> registerBlock(String key, Function<BlockBehaviour.Properties, Block> constructor, BlockBehaviour.Properties properties) {
        Object object;
        if (this.overrideKeys.containsKey("block:" + key) && (object = this.overrideKeys.get("block:" + key)) instanceof Function) {
            Function function = (Function)object;
            SpringToLifeMod.LOGGER.info("Overriding Block {}", (Object)key);
            return BLOCK_REGISTER.register(key, () -> (Block)function.apply(properties));
        }
        return BLOCK_REGISTER.register(key, () -> (Block)constructor.apply(properties));
    }

    @Override
    public Supplier<CreativeModeTab> registerCreativeTab(String key, Supplier<CreativeModeTab.Builder> tab) {
        return TAB_REGISTER.register(key, () -> ((CreativeModeTab.Builder)tab.get()).m_257652_());
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntityType(String key, Supplier<EntityType.Builder<T>> entityTypeBuilder) {
        return ENTITY_TYPE_REGISTER.register(key, () -> ((EntityType.Builder)entityTypeBuilder.get()).m_20712_(key));
    }

    @Override
    public <T extends FeatureConfiguration> Supplier<Feature<T>> registerFeature(String key, Supplier<Feature<T>> feature) {
        return FEATURE_REGISTER.register(key, feature);
    }

    @Override
    public Supplier<Item> registerItem(String key, Supplier<Item> item) {
        Object object;
        if (this.overrideKeys.containsKey("item:" + key) && (object = this.overrideKeys.get("item:" + key)) instanceof Supplier) {
            Supplier supplier = (Supplier)object;
            SpringToLifeMod.LOGGER.info("Overriding Item {}", (Object)key);
            return ITEM_REGISTER.register(key, supplier);
        }
        return ITEM_REGISTER.register(key, item);
    }

    @Override
    public <T extends ParticleOptions> Supplier<ParticleType<T>> registerParticleType(String key, Supplier<ParticleType<T>> particleType) {
        return PARTICLE_TYPE_REGISTER.register(key, particleType);
    }

    @Override
    public Supplier<SimpleParticleType> registerParticleTypeSimple(String key) {
        return PARTICLE_TYPE_REGISTER.register(key, () -> new SimpleParticleType(false));
    }

    @Override
    public Supplier<SoundEvent> registerSoundEvent(String key, Supplier<SoundEvent> soundEvent) {
        return SOUND_REGISTER.register(key, soundEvent);
    }

    @Override
    public <T extends TreeDecorator> Supplier<TreeDecoratorType<T>> registerTreeDecoratorType(String key, Codec<T> treeDecoratorTypeCodec) {
        return TREE_DECORATOR_REGISTER.register(key, () -> new TreeDecoratorType(treeDecoratorTypeCodec));
    }

    @Override
    public void finalizeRegistrationStage(IRegistrationProvider.RegistrationStage stage) {
        if (stage.equals((Object)IRegistrationProvider.RegistrationStage.CREATIVE_TABS)) {
            TAB_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.ENTITY_TYPES)) {
            ENTITY_TYPE_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.ITEMS)) {
            ITEM_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.BLOCKS)) {
            BLOCK_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.SOUNDS)) {
            SOUND_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.FEATURES)) {
            FEATURE_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.PARTICLE_TYPES)) {
            PARTICLE_TYPE_REGISTER.register(this.bus);
        } else if (stage.equals((Object)IRegistrationProvider.RegistrationStage.TREE_DECORATOR_TYPES)) {
            TREE_DECORATOR_REGISTER.register(this.bus);
        }
    }
}

