/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.mixin;

import de.larsensmods.stl_backport.entity.ColdChicken;
import de.larsensmods.stl_backport.entity.STLEntityTypes;
import de.larsensmods.stl_backport.entity.WarmChicken;
import de.larsensmods.stl_backport.mixin.AnimalMixin;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chicken.class})
public abstract class ChickenMixin
extends AnimalMixin {
    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerGoals(CallbackInfo ci) {
        Chicken c = (Chicken)this;
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)c, 1.0, ColdChicken.class));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)c, 1.0, WarmChicken.class));
    }

    @Override
    public void canMate(Animal otherAnimal, CallbackInfoReturnable<Boolean> cir) {
        Chicken c = (Chicken)this;
        if (otherAnimal == c) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)(otherAnimal instanceof Chicken && c.m_27593_() && otherAnimal.m_27593_() ? 1 : 0));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Chicken;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBreedOffspring(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<Chicken> cir) {
        Chicken otherChicken;
        if (!(otherParent instanceof Chicken)) {
            cir.setReturnValue(null);
        }
        if ((otherChicken = (Chicken)otherParent) instanceof WarmChicken) {
            cir.setReturnValue((Object)(Math.random() < 0.5 ? (Chicken)STLEntityTypes.WARM_CHICKEN.get().m_20615_((Level)level) : (Chicken)EntityType.f_20555_.m_20615_((Level)level)));
        } else if (otherChicken instanceof ColdChicken) {
            cir.setReturnValue((Object)(Math.random() < 0.5 ? (Chicken)STLEntityTypes.COLD_CHICKEN.get().m_20615_((Level)level) : (Chicken)EntityType.f_20555_.m_20615_((Level)level)));
        } else {
            cir.setReturnValue((Object)((Chicken)EntityType.f_20555_.m_20615_((Level)level)));
        }
    }
}

