/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.mixin;

import de.larsensmods.stl_backport.entity.ColdCow;
import de.larsensmods.stl_backport.entity.STLEntityTypes;
import de.larsensmods.stl_backport.entity.WarmCow;
import de.larsensmods.stl_backport.mixin.AnimalMixin;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cow.class})
public abstract class CowMixin
extends AnimalMixin {
    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerGoals(CallbackInfo ci) {
        Cow c = (Cow)this;
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)c, 1.0, ColdCow.class));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)c, 1.0, WarmCow.class));
    }

    @Override
    public void canMate(Animal otherAnimal, CallbackInfoReturnable<Boolean> cir) {
        Cow c = (Cow)this;
        if (otherAnimal == c) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)(otherAnimal instanceof Cow && c.m_27593_() && otherAnimal.m_27593_() ? 1 : 0));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Cow;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBreedOffspring(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<Cow> cir) {
        Cow otherCow;
        if (!(otherParent instanceof Cow)) {
            cir.setReturnValue(null);
        }
        if ((otherCow = (Cow)otherParent) instanceof WarmCow) {
            cir.setReturnValue((Object)(Math.random() < 0.5 ? (Cow)STLEntityTypes.WARM_COW.get().m_20615_((Level)level) : (Cow)EntityType.f_20557_.m_20615_((Level)level)));
        } else if (otherCow instanceof ColdCow) {
            cir.setReturnValue((Object)(Math.random() < 0.5 ? (Cow)STLEntityTypes.COLD_COW.get().m_20615_((Level)level) : (Cow)EntityType.f_20557_.m_20615_((Level)level)));
        } else {
            cir.setReturnValue((Object)((Cow)EntityType.f_20557_.m_20615_((Level)level)));
        }
    }
}

